/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.clusterers.AbstractClusterer;
import moa.core.Measurement;

public abstract class MyBaseOutlierDetector
extends AbstractClusterer {
    public IntOption windowSizeOption = new IntOption("windowSize", 'w', "Size of the window.", 1000);
    public OutlierNotifier outlierNotifier = null;
    protected Random random;
    protected int iMaxMemUsage = 0;
    protected int nRangeQueriesExecuted = 0;
    protected Long nTotalRunTime = 0L;
    protected double nTimePerObj;
    private Clustering myClusters = null;
    private TreeSet<Outlier> outliersFound;
    private Long m_timePreObjSum;
    private int nProcessed;
    private static final int m_timePreObjInterval = 100;
    protected ProgressInfo myProgressInfo;
    protected PrintMsg myOut;
    protected boolean bTrace = false;
    protected boolean bShowProgress = false;
    public boolean bStopAlgorithm = false;
    private Long _msPrev = 0L;
    private Long _msNow = 0L;

    protected void UpdateMaxMemUsage() {
        int x = this.GetMemoryUsage();
        if (this.iMaxMemUsage < x) {
            this.iMaxMemUsage = x;
        }
    }

    public double getTimePerObj() {
        return this.nTimePerObj;
    }

    public String getObjectInfo(Object obj) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String getStatistics() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public double[] getInstanceValues(Instance inst) {
        int length = inst.numValues() - 1;
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = inst.value(i);
        }
        return values;
    }

    public void PrintInstance(Instance inst) {
        this.Print("instance: [ ");
        for (int i = 0; i < inst.numValues() - 1; ++i) {
            this.Printf("%.2f ", inst.value(i));
        }
        this.Print("] ");
        this.Println("");
    }

    @Override
    public void resetLearningImpl() {
        this.Init();
    }

    protected void Init() {
        this.random = new Random(System.currentTimeMillis());
        this.outliersFound = new TreeSet();
        this.m_timePreObjSum = 0L;
        this.nProcessed = 0;
        this.nTimePerObj = 0.0;
        StdPrintMsg printer = new StdPrintMsg();
        printer.RedirectToDisplay();
        this.SetUserInfo(true, false, printer, 1000);
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        this.processNewInstanceImpl(inst);
    }

    public void processNewInstanceImpl(Instance inst) {
        Long nsNow = System.nanoTime();
        this.ProcessNewStreamObj(inst);
        this.UpdateMaxMemUsage();
        this.nTotalRunTime = this.nTotalRunTime + (System.nanoTime() - nsNow) / 0x100000L;
        ++this.nProcessed;
        this.m_timePreObjSum = this.m_timePreObjSum + (System.nanoTime() - nsNow);
        if (this.nProcessed % 100 == 0) {
            this.nTimePerObj = (double)this.m_timePreObjSum.longValue() / 100.0;
            if (this.bShowProgress) {
                this.ShowTimePerObj();
            }
            this.m_timePreObjSum = 0L;
        }
    }

    private void ShowTimePerObj() {
        double ms = this.nTimePerObj / 1000000.0;
        this.Println("Process time per object (ms): " + String.format("%.3f", ms));
    }

    protected void ProcessNewStreamObj(Instance inst) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void PrintOutliers() {
        this.Print("Outliers: ");
        for (Outlier o : this.outliersFound) {
            this.Printf("[%d] ", o.id);
        }
        this.Println("");
    }

    public Set<Outlier> GetOutliersFound() {
        return this.outliersFound;
    }

    protected boolean IsNodeIdInWin(long id) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Clustering getClusteringResult() {
        this.myClusters = new Clustering();
        for (Outlier o : this.outliersFound) {
            if (!this.IsNodeIdInWin(o.id)) continue;
            double[] center = new double[o.inst.numValues() - 1];
            for (int i = 0; i < o.inst.numValues() - 1; ++i) {
                center[i] = o.inst.value(i);
            }
            SphereCluster c = new SphereCluster(center, 0.0);
            this.myClusters.add(c);
        }
        return this.myClusters;
    }

    public Vector<Outlier> getOutliersResult() {
        Vector<Outlier> outliers = new Vector<Outlier>();
        for (Outlier o : this.outliersFound) {
            if (!this.IsNodeIdInWin(o.id)) continue;
            outliers.add(o);
        }
        return outliers;
    }

    protected void AddOutlier(Outlier newOutlier) {
        boolean bNewAdd = this.outliersFound.add(newOutlier);
        if (this.outlierNotifier != null && bNewAdd) {
            this.outlierNotifier.OnOutlier(newOutlier);
        }
    }

    protected boolean RemoveExpiredOutlier(Outlier outlier) {
        boolean bFound = this.outliersFound.remove(outlier);
        return bFound;
    }

    protected boolean RemoveOutlier(Outlier outlier) {
        boolean bFound = this.outliersFound.remove(outlier);
        if (this.outlierNotifier != null && bFound) {
            this.outlierNotifier.OnInlier(outlier);
        }
        return bFound;
    }

    @Override
    public boolean implementsMicroClusterer() {
        return false;
    }

    @Override
    public Clustering getMicroClusteringResult() {
        return null;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public boolean keepClassLabel() {
        return true;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return null;
    }

    public void SetShowProgress(boolean b) {
        this.bShowProgress = b;
    }

    public void SetTrace(boolean b) {
        this.bTrace = b;
    }

    public void SetProgressInterval(int iProgressInterval) {
        this.myProgressInfo = new MyProgressInfo(iProgressInterval);
    }

    public void SetMessagePrinter(PrintMsg logPrinter) {
        this.myOut = logPrinter;
    }

    public void SetUserInfo(boolean bShowProgress, boolean bTrace, PrintMsg logPrinter, int iProgressInterval) {
        this.bShowProgress = bShowProgress;
        this.bTrace = bTrace;
        this.myProgressInfo = new MyProgressInfo(iProgressInterval);
        this.myOut = logPrinter;
    }

    protected void ShowProgress(String sMsg) {
        this.ShowProgress(sMsg, false);
    }

    protected void ShowProgress(String sMsg, boolean bShowAlways) {
        if (bShowAlways || this._msNow - this._msPrev >= (long)this.myProgressInfo.GetInterval()) {
            this.myProgressInfo.ShowProgress(sMsg);
            this._msPrev = this._msNow = Long.valueOf(System.currentTimeMillis());
        } else {
            this._msNow = System.currentTimeMillis();
        }
    }

    protected void Println(String s) {
        if (this.myOut != null) {
            this.myOut.println(s);
        }
    }

    protected void Print(String s) {
        if (this.myOut != null) {
            this.myOut.print(s);
        }
    }

    protected void Printf(String fmt, Object ... args) {
        if (this.myOut != null) {
            this.myOut.printf(fmt, args);
        }
    }

    protected int GetMemoryUsage() {
        int iMemory = (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
        return iMemory;
    }

    class MyProgressInfo
    implements ProgressInfo {
        int progressInterval;

        public MyProgressInfo(int interval) {
            this.progressInterval = interval;
        }

        public void setProgressInterval(int progressInterval) {
            this.progressInterval = progressInterval;
        }

        @Override
        public int GetInterval() {
            return this.progressInterval;
        }

        @Override
        public void ShowProgress(String sMsg) {
            MyBaseOutlierDetector.this.myOut.println(sMsg);
        }
    }

    public class StdPrintMsg
    implements PrintMsg {
        private PrintStream printStream;
        private PrintStream fileStream;

        public StdPrintMsg() {
            this.RedirectToDisplay();
        }

        public StdPrintMsg(String sFilename) {
            this.RedirectToFile(sFilename);
        }

        public void RedirectToDisplay() {
            this.printStream = System.out;
        }

        public void RedirectToFile(String sFilename) {
            File file = new File(sFilename);
            try {
                this.printStream = this.fileStream = new PrintStream(new FileOutputStream(file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void RedirectToFile() {
            this.printStream = this.fileStream;
        }

        @Override
        public void println(String s) {
            this.printStream.println(s);
        }

        @Override
        public void print(String s) {
            this.printStream.print(s);
        }

        @Override
        public void printf(String fmt, Object ... args) {
            this.printStream.printf(fmt, args);
        }
    }

    public static interface ProgressInfo {
        public int GetInterval();

        public void ShowProgress(String var1);
    }

    public static interface PrintMsg {
        public void print(String var1);

        public void println(String var1);

        public void printf(String var1, Object ... var2);
    }

    public static abstract class OutlierNotifier {
        public void OnOutlier(Outlier outlier) {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public void OnInlier(Outlier outlier) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public static class Outlier
    implements Comparable<Outlier> {
        public long id;
        public Instance inst;
        public Object obj;

        public Outlier(Instance inst, long id, Object obj) {
            this.id = id;
            this.inst = inst;
            this.obj = obj;
        }

        @Override
        public int compareTo(Outlier o) {
            if (this.id > o.id) {
                return 1;
            }
            if (this.id < o.id) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            return this.id == ((Outlier)o).id;
        }
    }
}

