/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.ConstantPopulation;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.OldAbstractCoalescentLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class VariableSkylineLikelihood
extends OldAbstractCoalescentLikelihood
implements Citable {
    private double[] popPoints = null;
    private final Parameter popSizeParameter;
    private final Parameter indicatorParameter;
    private boolean groupsValid = false;
    List<Integer> groupSizes = new ArrayList<Integer>();
    List<Double> groupHeights = new ArrayList<Double>();
    List<Double> groupEnds = new ArrayList<Double>();
    private final ArrayList<Integer> storeSizes = new ArrayList();
    private final ArrayList<Double> storeHeights = new ArrayList();
    private final ArrayList<Double> storeEnds = new ArrayList();
    private boolean storeValid;
    private final Type type;
    private boolean logSpace = false;
    public static Citation CITATION = new Citation(new Author[]{new Author("J", "Heled"), new Author("AJ", "Drummond")}, "", 0, "", 0, 0, 0, "");

    public VariableSkylineLikelihood(Tree tree, Parameter parameter, Parameter parameter2, Type type, boolean bl) {
        super("ovariableSkyLineLikelihood");
        this.popSizeParameter = parameter;
        this.indicatorParameter = parameter2;
        int n = type == Type.STEPWISE ? 1 : 0;
        int n2 = tree.getExternalNodeCount() - n;
        int n3 = parameter.getDimension();
        int n4 = parameter2.getDimension();
        this.type = type;
        this.logSpace = bl;
        if (n3 != n2) {
            throw new IllegalArgumentException("Dimension of population parameter (" + n3 + ") must be the same as the number of internal nodes in the tree (" + n2 + ").");
        }
        if (n4 != n2 - 1) {
            throw new IllegalArgumentException("Dimension of indicator parameter must one less than the number of internal nodes in the tree. (" + n4 + " != " + (n2 - 1) + ")");
        }
        this.tree = tree;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        this.addVariable(parameter2);
        this.addVariable(parameter);
        this.setupIntervals();
    }

    @Override
    public synchronized double getLogLikelihood() {
        this.insureValid();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        ConstantPopulation constantPopulation = new ConstantPopulation(Units.Type.YEARS);
        final double[] dArray = new double[1];
        if (this.type == Type.LINEAR) {
            constantPopulation = new ConstantPopulation(Units.Type.YEARS){

                @Override
                public double getDemographic(double d) {
                    return dArray[0];
                }
            };
        }
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.type == Type.LINEAR) {
                dArray[0] = this.getPopSize(n, d2 + this.intervals[i]);
            }
            constantPopulation.setN0(this.getPopSize(n, d2 + this.intervals[i] / 2.0));
            OldAbstractCoalescentLikelihood.CoalescentEventType coalescentEventType = this.getIntervalType(i);
            if (coalescentEventType == OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT && ++n2 >= this.groupSizes.get(n)) {
                ++n;
                n2 = 0;
            }
            if ((d += VariableSkylineLikelihood.calculateIntervalLikelihood(constantPopulation, this.intervals[i], d2, this.lineageCounts[i], coalescentEventType)) > 0.0 && i > 1) {
                System.out.println(d);
            }
            int n3 = this.getCoalescentEvents(i) - 1;
            for (int j = 0; j < n3; ++j) {
                dArray[0] = this.getPopSize(n, d2);
                constantPopulation.setN0(dArray[0]);
                d += VariableSkylineLikelihood.calculateIntervalLikelihood(constantPopulation, 0.0, d2, this.lineageCounts[i] - j - 1, OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT);
                if (++n2 < this.groupSizes.get(n)) continue;
                ++n;
                n2 = 0;
            }
            d2 += this.intervals[i];
        }
        return d;
    }

    private void insureValid() {
        if (!this.intervalsKnown) {
            this.setupIntervals();
            this.groupsValid = false;
        }
        if (!this.groupsValid) {
            this.calculateGroupSizesHeightsAndEnds();
            this.popPoints = null;
        }
    }

    public double[] getPopulation(int n) {
        this.insureValid();
        if (this.popPoints != null && this.popPoints.length == n) {
            return this.popPoints;
        }
        if (this.popPoints == null || this.popPoints.length != n) {
            this.popPoints = new double[n];
        }
        double d = this.tree.getNodeHeight(this.tree.getRoot());
        double d2 = d / (double)this.popPoints.length;
        int n2 = 0;
        double d3 = 0.0;
        double d4 = this.groupEnds.get(n2);
        for (int i = 0; i < this.popPoints.length - 1; ++i) {
            this.popPoints[i] = this.getPopSize(n2, d3);
            d3 += d2;
            while (d3 >= d4) {
                d4 = this.groupEnds.get(++n2);
            }
        }
        this.popPoints[this.popPoints.length - 1] = this.getPopSize(n2, d3);
        return this.popPoints;
    }

    private double getPopSize(int n, double d) {
        double d2 = n > 0 ? this.groupEnds.get(n - 1) : 0.0;
        double d3 = this.groupEnds.get(n);
        double d4 = this.groupHeights.get(n);
        if (!(d2 <= d && (this.type != Type.STEPWISE && d <= d3 || this.type == Type.STEPWISE && d < d3))) {
            System.out.println(d + " " + d2 + "/" + d3);
        }
        switch (this.type) {
            case EXPONENTIAL: {
                throw new UnsupportedOperationException("Exponential Skyline Plot not implemented yet");
            }
            case LINEAR: {
                if (n + 1 >= this.groupHeights.size()) {
                    return d4;
                }
                double d5 = (d - d2) / (d3 - d2);
                double d6 = this.groupHeights.get(n + 1);
                double d7 = (1.0 - d5) * d4 + d5 * d6;
                if (d7 <= 0.0) {
                    if (d5 == 1.0) {
                        assert (d6 > 0.0);
                        return d6;
                    }
                    System.out.println(d7);
                    assert (d7 > 0.0);
                }
                return d7;
            }
            case STEPWISE: {
                return d4;
            }
        }
        return -1.0;
    }

    private void calculateGroupSizesHeightsAndEnds() {
        int n;
        this.groupSizes.clear();
        this.groupHeights.clear();
        this.groupEnds.clear();
        int n2 = 1;
        int n3 = 0;
        double d = 0.0;
        for (n = 0; n < this.indicatorParameter.getDimension(); ++n) {
            d += this.intervals[n];
            if (this.indicatorParameter.getParameterValue(n) != 0.0) {
                this.groupSizes.add(n2);
                this.groupHeights.add(this.popSizeParameter.getParameterValue(n3));
                n2 = 1;
                n3 = n + 1;
                this.groupEnds.add(d);
                continue;
            }
            ++n2;
        }
        this.groupSizes.add(n2);
        this.groupHeights.add(this.popSizeParameter.getParameterValue(n3));
        this.groupEnds.add(d += this.intervals[this.indicatorParameter.getDimension()]);
        if (this.logSpace) {
            for (n = 0; n < this.groupHeights.size(); ++n) {
                this.groupHeights.set(n, Math.exp(this.groupHeights.get(n)));
            }
        }
        this.groupsValid = true;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        this.groupsValid = false;
    }

    @Override
    protected void storeState() {
        super.storeState();
        this.storeSizes.clear();
        this.storeSizes.addAll(this.groupSizes);
        this.storeHeights.clear();
        this.storeHeights.addAll(this.groupHeights);
        this.storeEnds.clear();
        this.storeEnds.addAll(this.groupEnds);
        this.storeValid = this.groupsValid;
    }

    @Override
    protected void restoreState() {
        super.restoreState();
        this.groupsValid = this.storeValid;
        this.groupSizes.clear();
        this.groupSizes.addAll(this.storeSizes);
        this.groupHeights.clear();
        this.groupHeights.addAll(this.storeHeights);
        this.groupEnds.clear();
        this.groupEnds.addAll(this.storeEnds);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Extended Skyline Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    public static enum Type {
        STEPWISE,
        LINEAR,
        EXPONENTIAL;

    }
}

