/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.PoissonDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PoissonDistributionModel
extends AbstractModel
implements ParametricDistributionModel {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return PoissonDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final Variable<Double> mean;

    public PoissonDistributionModel(Variable<Double> variable) {
        super("poissonDistributionModel");
        this.mean = variable;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    @Override
    public double pdf(double d) {
        return PoissonDistribution.pdf(d, this.mean());
    }

    @Override
    public double logPdf(double d) {
        return PoissonDistribution.logPdf(d, this.mean());
    }

    @Override
    public double cdf(double d) {
        return PoissonDistribution.cdf(d, this.mean());
    }

    @Override
    public double quantile(double d) {
        return PoissonDistribution.quantile(d, this.mean());
    }

    @Override
    public double mean() {
        return this.mean.getValue(0);
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.mean;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }
}

