/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalUtils {
    public static BigDecimal intPower(BigDecimal bigDecimal, long l, int n) {
        if (l < 0L) {
            return BigDecimal.valueOf(1L).divide(BigDecimalUtils.intPower(bigDecimal, -l, n), n, 6);
        }
        BigDecimal bigDecimal2 = BigDecimal.valueOf(1L);
        while (l > 0L) {
            if ((l & 1L) == 1L) {
                bigDecimal2 = bigDecimal2.multiply(bigDecimal).setScale(n, 6);
            }
            bigDecimal = bigDecimal.multiply(bigDecimal).setScale(n, 6);
            l >>= 1;
            Thread.yield();
        }
        return bigDecimal2;
    }

    public static BigDecimal intRoot(BigDecimal bigDecimal, long l, int n) {
        BigDecimal bigDecimal2;
        if (bigDecimal.signum() < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        int n2 = n + 1;
        BigDecimal bigDecimal3 = bigDecimal;
        BigDecimal bigDecimal4 = BigDecimal.valueOf(l);
        BigDecimal bigDecimal5 = BigDecimal.valueOf(l - 1L);
        BigDecimal bigDecimal6 = BigDecimal.valueOf(5L).movePointLeft(n2);
        bigDecimal = bigDecimal.divide(bigDecimal4, n, 6);
        do {
            BigDecimal bigDecimal7 = BigDecimalUtils.intPower(bigDecimal, l - 1L, n2);
            BigDecimal bigDecimal8 = bigDecimal.multiply(bigDecimal7).setScale(n2, 6);
            BigDecimal bigDecimal9 = bigDecimal3.add(bigDecimal5.multiply(bigDecimal8)).setScale(n2, 6);
            BigDecimal bigDecimal10 = bigDecimal4.multiply(bigDecimal7).setScale(n2, 6);
            bigDecimal2 = bigDecimal;
            bigDecimal = bigDecimal9.divide(bigDecimal10, n2, 1);
            Thread.yield();
        } while (bigDecimal.subtract(bigDecimal2).abs().compareTo(bigDecimal6) > 0);
        return bigDecimal;
    }

    public static BigDecimal exp(BigDecimal bigDecimal, int n) {
        if (bigDecimal.signum() == 0) {
            return BigDecimal.valueOf(1L);
        }
        if (bigDecimal.signum() == -1) {
            return BigDecimal.valueOf(1L).divide(BigDecimalUtils.exp(bigDecimal.negate(), n), n, 6);
        }
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, 1);
        if (bigDecimal2.signum() == 0) {
            return BigDecimalUtils.expTaylor(bigDecimal, n);
        }
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        BigDecimal bigDecimal4 = BigDecimal.valueOf(1L).add(bigDecimal3.divide(bigDecimal2, n, 6));
        BigDecimal bigDecimal5 = BigDecimalUtils.expTaylor(bigDecimal4, n);
        BigDecimal bigDecimal6 = BigDecimal.valueOf(Long.MAX_VALUE);
        BigDecimal bigDecimal7 = BigDecimal.valueOf(1L);
        while (bigDecimal2.compareTo(bigDecimal6) >= 0) {
            bigDecimal7 = bigDecimal7.multiply(BigDecimalUtils.intPower(bigDecimal5, Long.MAX_VALUE, n)).setScale(n, 6);
            bigDecimal2 = bigDecimal2.subtract(bigDecimal6);
            Thread.yield();
        }
        return bigDecimal7.multiply(BigDecimalUtils.intPower(bigDecimal5, bigDecimal2.longValue(), n)).setScale(n, 6);
    }

    private static BigDecimal expTaylor(BigDecimal bigDecimal, int n) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3 = BigDecimal.valueOf(1L);
        BigDecimal bigDecimal4 = bigDecimal;
        BigDecimal bigDecimal5 = bigDecimal.add(BigDecimal.valueOf(1L));
        int n2 = 2;
        do {
            bigDecimal4 = bigDecimal4.multiply(bigDecimal).setScale(n, 6);
            bigDecimal3 = bigDecimal3.multiply(BigDecimal.valueOf(n2));
            BigDecimal bigDecimal6 = bigDecimal4.divide(bigDecimal3, n, 6);
            bigDecimal2 = bigDecimal5;
            bigDecimal5 = bigDecimal5.add(bigDecimal6);
            ++n2;
            Thread.yield();
        } while (bigDecimal5.compareTo(bigDecimal2) != 0);
        return bigDecimal5;
    }

    public static BigDecimal ln(BigDecimal bigDecimal, int n) {
        if (bigDecimal.signum() <= 0) {
            throw new IllegalArgumentException("x <= 0");
        }
        int n2 = bigDecimal.toString().length() - bigDecimal.scale() - 1;
        if (n2 < 3) {
            return BigDecimalUtils.lnNewton(bigDecimal, n);
        }
        BigDecimal bigDecimal2 = BigDecimalUtils.intRoot(bigDecimal, n2, n);
        BigDecimal bigDecimal3 = BigDecimalUtils.lnNewton(bigDecimal2, n);
        return BigDecimal.valueOf(n2).multiply(bigDecimal3).setScale(n, 6);
    }

    private static BigDecimal lnNewton(BigDecimal bigDecimal, int n) {
        BigDecimal bigDecimal2;
        int n2 = n + 1;
        BigDecimal bigDecimal3 = bigDecimal;
        BigDecimal bigDecimal4 = BigDecimal.valueOf(5L).movePointLeft(n2);
        do {
            BigDecimal bigDecimal5 = BigDecimalUtils.exp(bigDecimal, n2);
            bigDecimal2 = bigDecimal5.subtract(bigDecimal3).divide(bigDecimal5, n2, 1);
            bigDecimal = bigDecimal.subtract(bigDecimal2);
            Thread.yield();
        } while (bigDecimal2.compareTo(bigDecimal4) > 0);
        return bigDecimal.setScale(n, 6);
    }

    public static BigDecimal arctan(BigDecimal bigDecimal, int n) {
        if (bigDecimal.abs().compareTo(BigDecimal.valueOf(1L)) >= 0) {
            throw new IllegalArgumentException("|x| >= 1");
        }
        if (bigDecimal.signum() == -1) {
            return BigDecimalUtils.arctan(bigDecimal.negate(), n).negate();
        }
        return BigDecimalUtils.arctanTaylor(bigDecimal, n);
    }

    private static BigDecimal arctanTaylor(BigDecimal bigDecimal, int n) {
        BigDecimal bigDecimal2;
        int n2 = n + 1;
        int n3 = 3;
        boolean bl = false;
        BigDecimal bigDecimal3 = bigDecimal;
        BigDecimal bigDecimal4 = bigDecimal;
        BigDecimal bigDecimal5 = BigDecimal.valueOf(5L).movePointLeft(n2);
        do {
            bigDecimal3 = bigDecimal3.multiply(bigDecimal).multiply(bigDecimal).setScale(n2, 6);
            bigDecimal2 = bigDecimal3.divide(BigDecimal.valueOf(n3), n2, 6);
            bigDecimal4 = bl ? bigDecimal4.add(bigDecimal2) : bigDecimal4.subtract(bigDecimal2);
            n3 += 2;
            bl = !bl;
            Thread.yield();
        } while (bigDecimal2.compareTo(bigDecimal5) > 0);
        return bigDecimal4;
    }

    public static BigDecimal sqrt(BigDecimal bigDecimal, int n) {
        BigInteger bigInteger;
        if (bigDecimal.signum() < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        BigInteger bigInteger2 = bigDecimal.movePointRight(n << 1).toBigInteger();
        int n2 = bigInteger2.bitLength() + 1 >> 1;
        BigInteger bigInteger3 = bigInteger2.shiftRight(n2);
        do {
            bigInteger = bigInteger3;
            bigInteger3 = bigInteger3.add(bigInteger2.divide(bigInteger3)).shiftRight(1);
            Thread.yield();
        } while (bigInteger3.compareTo(bigInteger) != 0);
        return new BigDecimal(bigInteger3, n);
    }
}

