/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.smooth;

import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.TreeIntervals;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.AbstractCoalescentLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.NumericalDerivative;
import dr.math.UnivariateFunction;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.RombergIntegrator;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegrator;

public class OldSmoothSkygridLikelihood
extends AbstractCoalescentLikelihood
implements Citable {
    private final List<IntervalList> intervalList;
    private final Parameter logPopSizeParameter;
    private final Parameter gridPointParameter;
    private final double[] gridPoints;
    private final int numGridIntervals;
    private Units.Type units;
    private double[] coalescentCount;
    private double[] coalescentIntensity;
    private double[] savedCoalescentCount;
    private double[] savedCoalescentIntensity;
    private static final UnivariateRealIntegrator integrator = new RombergIntegrator();
    private List<TreeIntervals> debugIntervalList;

    public OldSmoothSkygridLikelihood(String string, List<IntervalList> list, Parameter parameter, Parameter parameter2) {
        super(string);
        this.intervalList = list;
        this.logPopSizeParameter = parameter;
        this.gridPointParameter = parameter2;
        this.gridPoints = parameter2.getParameterValues();
        this.numGridIntervals = this.gridPoints.length + 2;
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.units = list.get(0).getUnits();
        for (IntervalList intervalList : list) {
            if (intervalList instanceof Model) {
                this.addModel((Model)((Object)intervalList));
            }
            if (intervalList.getUnits() == this.units) continue;
            throw new IllegalArgumentException("All intervalLists must have the same units.");
        }
        if (!OldSmoothSkygridLikelihood.checkValidParameters(parameter, parameter2)) {
            throw new IllegalArgumentException("Invalid initial parameters");
        }
        this.addKeyword("smooth0skygrid");
        if (list.size() > 1) {
            this.addKeyword("multilocus");
        }
    }

    public void setDebugIntervalList(List<TreeIntervals> list) {
        this.debugIntervalList = list;
    }

    public static boolean checkValidParameters(Parameter parameter, Parameter parameter2) {
        return parameter.getDimension() == parameter2.getDimension() + 1 && OldSmoothSkygridLikelihood.checkStrictlyIncreasing(parameter2);
    }

    private static boolean checkStrictlyIncreasing(Parameter parameter) {
        double d = parameter.getParameterValue(0);
        for (int i = 1; i < parameter.getDimension(); ++i) {
            double d2 = parameter.getParameterValue(i);
            if (d2 <= d) {
                return false;
            }
            d = d2;
        }
        return true;
    }

    @Override
    public Units.Type getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(Units.Type type) {
        this.units = type;
        for (IntervalList intervalList : this.intervalList) {
            intervalList.setUnits(type);
        }
    }

    @Override
    public String toString() {
        return Double.toString(this.getLogLikelihood());
    }

    @Override
    protected double calculateLogLikelihood() {
        if (!this.intervalsKnown) {
            this.computeSufficientStatistics();
            this.intervalsKnown = true;
        }
        return 0.0;
    }

    private void computeSufficientStatistics() {
        for (IntervalList intervalList : this.intervalList) {
            double d = intervalList.getStartTime();
            int n = 0;
            while (d > this.gridPoints[n]) {
                ++n;
            }
            for (int i = 0; i < intervalList.getIntervalCount() - 1; ++i) {
                double d2 = intervalList.getIntervalTime(i);
                int n2 = intervalList.getLineageCount(i);
                while (intervalList.getIntervalTime(i + 1) > this.gridPoints[n]) {
                }
            }
        }
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void storeState() {
        super.storeState();
        if (this.savedCoalescentCount == null) {
            this.savedCoalescentCount = new double[this.coalescentCount.length];
            this.savedCoalescentIntensity = new double[this.coalescentIntensity.length];
        }
        System.arraycopy(this.coalescentCount, 0, this.savedCoalescentCount, 0, this.coalescentCount.length);
        System.arraycopy(this.coalescentIntensity, 0, this.savedCoalescentIntensity, 0, this.coalescentIntensity.length);
    }

    @Override
    protected void restoreState() {
        super.restoreState();
        double[] dArray = this.coalescentCount;
        this.coalescentCount = this.savedCoalescentCount;
        this.savedCoalescentCount = dArray;
        dArray = this.coalescentIntensity;
        this.coalescentIntensity = this.savedCoalescentIntensity;
        this.savedCoalescentIntensity = dArray;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        if (variable == this.gridPointParameter) {
            throw new RuntimeException("Not yet implemented");
        }
        if (variable == this.logPopSizeParameter) {
            this.likelihoodKnown = false;
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        super.handleModelChangedEvent(model, object, n);
        if (model instanceof IntervalList) {
            this.intervalsKnown = false;
            this.likelihoodKnown = false;
        }
    }

    @Override
    public int getNumberOfCoalescentEvents() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double getCoalescentEventsStatisticValue(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Differentiable skygrid coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(CommonCitations.GILL_2013_IMPROVING, new Citation(new Author[]{new Author("MA", "Suchard"), new Author("X", "Ji")}, Citation.Status.IN_PREPARATION));
    }

    public static double getIntensityInInterval(double d, double d2, double d3, double d4, double d5, double d6, double d7) throws Exception {
        assert (d >= d3 && d2 >= d3);
        assert (d <= d4 && d2 <= d4);
        assert (d != d2);
        if (d7 == 1.0) {
            return OldSmoothSkygridLikelihood.getAnalyticIntensityForLinearModel(d, d2, d3, d4, d5, d6);
        }
        if (d7 == 0.0) {
            return OldSmoothSkygridLikelihood.getAnalyticIntensityForConstantModel(d, d2, d3, d4, d5, d6);
        }
        if (d7 == Double.POSITIVE_INFINITY) {
            return OldSmoothSkygridLikelihood.getAnalyticIntensityForShiftedSkygridModel(d, d2, d3, d4, d5, d6);
        }
        return OldSmoothSkygridLikelihood.getNumericIntensityInInterval(d, d2, d3, d4, d5, d6, d7);
    }

    public static double getAnalyticIntensityForShiftedSkygridModel(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d3 + d4) * 0.5;
        if (d < d7) {
            if (d2 <= d7) {
                return (d2 - d) / Math.exp(d5);
            }
            return (d7 - d) / Math.exp(d5) + (d2 - d7) / Math.exp(d6);
        }
        return (d2 - d) / Math.exp(d6);
    }

    public static double getAnalyticIntensityForConstantModel(double d, double d2, double d3, double d4, double d5, double d6) {
        return (d2 - d) / Math.exp((d5 + d6) * 0.5);
    }

    public static double[] getGradientWrtLogPopSizesInInterval(double d, double d2, double d3, double d4, double d5, double d6, double d7) throws Exception {
        double d8 = OldSmoothSkygridLikelihood.getNumericFunctionalInInterval(d, d2, d3, d4, d5, d6, d7);
        double d9 = OldSmoothSkygridLikelihood.getNumericIntensityInInterval(d, d2, d3, d4, d5, d6, d7);
        return new double[]{d8 - d9, -d8};
    }

    public static double[] getGradientWrtLogPopSizesInIntervalViaCentralDifference(final double d, final double d2, final double d3, final double d4, final double d5, final double d6, final double d7) {
        double d8 = NumericalDerivative.firstDerivative(new UnivariateFunction(){

            @Override
            public double evaluate(double d5) {
                try {
                    return OldSmoothSkygridLikelihood.getIntensityInInterval(d, d2, d3, d4, d5, d6, d7);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return 0.0;
                }
            }

            @Override
            public double getLowerBound() {
                return Double.NEGATIVE_INFINITY;
            }

            @Override
            public double getUpperBound() {
                return Double.POSITIVE_INFINITY;
            }
        }, d5);
        double d9 = NumericalDerivative.firstDerivative(new UnivariateFunction(){

            @Override
            public double evaluate(double d6) {
                try {
                    return OldSmoothSkygridLikelihood.getIntensityInInterval(d, d2, d3, d4, d5, d6, d7);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return 0.0;
                }
            }

            @Override
            public double getLowerBound() {
                return Double.NEGATIVE_INFINITY;
            }

            @Override
            public double getUpperBound() {
                return Double.POSITIVE_INFINITY;
            }
        }, d6);
        return new double[]{d8, d9};
    }

    public static double getNumericIntensityInInterval(double d, double d2, double d3, double d4, double d5, double d7, double d8) throws Exception {
        UnivariateRealFunction univariateRealFunction = d6 -> OldSmoothSkygridLikelihood.getReciprocalPopSizeInInterval(d6, d3, d4, d5, d7, d8);
        return integrator.integrate(univariateRealFunction, d, d2);
    }

    public static double getNumericFunctionalInInterval(double d, double d2, double d3, double d4, double d5, double d7, double d8) throws Exception {
        UnivariateRealFunction univariateRealFunction = d6 -> OldSmoothSkygridLikelihood.getReciprocalPopSizeInInterval(d6, d3, d4, d5, d7, d8) / (1.0 + OldSmoothSkygridLikelihood.getScaledOdds(d6, d3, d4, d8));
        return integrator.integrate(univariateRealFunction, d, d2);
    }

    public static double getNumericLogPopSizeIntensity(double d, double d2, double d3, double d5, double d6) throws Exception {
        UnivariateRealFunction univariateRealFunction = d4 -> OldSmoothSkygridLikelihood.getLogPopSizeIntensity(d4, d3, d5, d6);
        return integrator.integrate(univariateRealFunction, d, d2);
    }

    public static double getAnalyticIntensityForLinearModel(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d6 - d5) / (d4 - d3);
        double d8 = Math.exp(-d7 * (d -= d3) - d5);
        double d9 = Math.exp(-d7 * (d2 -= d3) - d5);
        return (d8 - d9) / d7;
    }

    public static double getReciprocalPopSizeInInterval(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.exp(-OldSmoothSkygridLikelihood.getLogPopSizeInInterval(d, d2, d3, d4, d5, d6));
    }

    public static double getPopSizeInInterval(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.exp(OldSmoothSkygridLikelihood.getLogPopSizeInInterval(d, d2, d3, d4, d5, d6));
    }

    public static double getLogPopSizeIntensity(double d, double d2, double d3, double d4) {
        return Math.exp(-OldSmoothSkygridLikelihood.getLogPopSizeWeight(d, d2, d3, d4));
    }

    public static double getLogPopSizeWeight(double d, double d2, double d3, double d4) {
        assert (d >= d2);
        assert (d <= d3);
        if (d == d2) {
            if (d4 == 0.0) {
                return 2.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        return 1.0 + OldSmoothSkygridLikelihood.getScaledOdds(d, d2, d3, d4);
    }

    public static double getLogPopSizeInInterval(double d, double d2, double d3, double d4, double d5, double d6) {
        assert (d >= d2);
        assert (d <= d3);
        if (d == d2) {
            if (d6 == 0.0) {
                return (d4 + d5) * 0.5;
            }
            return d4;
        }
        double d7 = OldSmoothSkygridLikelihood.getScaledOdds(d, d2, d3, d6);
        return d4 + (d5 - d4) / (1.0 + d7);
    }

    private static double getScaledOdds(double d, double d2, double d3, double d4) {
        double d5 = (d3 - d) / (d - d2);
        return Math.pow(d5, d4);
    }

    class Event {
        double integratedIntensity;
        double logReciprocalPopSize;
        int lineages;

        Event() {
        }
    }
}

