/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class VectorSliceParameter
extends CompoundParameter {
    public static final String VECTOR_SLICE_PARAMETER = "vectorSlice";
    public static final String SLICE_DIMENSION = "sliceDimension";
    private final int sliceDimension;
    private Bounds<Double> bounds;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE), AttributeRule.newIntegerRule("sliceDimension")};

        @Override
        public String getParserName() {
            return VectorSliceParameter.VECTOR_SLICE_PARAMETER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = xMLObject.getIntegerAttribute(VectorSliceParameter.SLICE_DIMENSION);
            VectorSliceParameter vectorSliceParameter = new VectorSliceParameter(xMLObject.getId(), n - 1);
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Parameter parameter = (Parameter)xMLObject.getChild(i);
                if (parameter instanceof MatrixParameter) {
                    MatrixParameter matrixParameter = (MatrixParameter)parameter;
                    for (int j = 0; j < matrixParameter.getParameterCount(); ++j) {
                        this.checkAndAdd(vectorSliceParameter, matrixParameter.getParameter(j), n);
                    }
                    continue;
                }
                this.checkAndAdd(vectorSliceParameter, parameter, n);
            }
            return vectorSliceParameter;
        }

        private void checkAndAdd(VectorSliceParameter vectorSliceParameter, Parameter parameter, int n) throws XMLParseException {
            vectorSliceParameter.addParameter(parameter);
            if (n < 1 || n > parameter.getDimension()) {
                throw new XMLParseException("Slice dimension " + n + " is invalid for a parameter with dimension = " + parameter.getDimension());
            }
        }

        @Override
        public String getParserDescription() {
            return "A vector parameter constructed from a slice of component parameters.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return VectorSliceParameter.class;
        }
    };

    @Override
    public Bounds<Double> getBounds() {
        if (this.bounds == null) {
            this.bounds = new sliceBounds();
        }
        return this.bounds;
    }

    public VectorSliceParameter(String string, int n) {
        super(string);
        this.sliceDimension = n;
    }

    @Override
    public int getDimension() {
        return this.getParameterCount();
    }

    @Override
    public double getParameterValue(int n) {
        Parameter parameter = this.getParameter(n);
        return parameter.getParameterValue(this.sliceDimension);
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void setParameterValue(int n, double d) {
        Parameter parameter = this.getParameter(n);
        parameter.setParameterValue(this.sliceDimension, d);
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        Parameter parameter = this.getParameter(n);
        parameter.setParameterValueQuietly(this.sliceDimension, d);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        Parameter parameter = this.getParameter(n);
        parameter.setParameterValueNotifyChangedAll(this.sliceDimension, d);
    }

    @Override
    public String getDimensionName(int n) {
        return this.getParameter(n).getVariableName() + Integer.toString(this.sliceDimension + 1);
    }

    private class sliceBounds
    implements Bounds<Double> {
        private sliceBounds() {
        }

        @Override
        public Double getUpperLimit(int n) {
            return VectorSliceParameter.this.getParameter(n).getBounds().getUpperLimit(VectorSliceParameter.this.sliceDimension);
        }

        @Override
        public Double getLowerLimit(int n) {
            return VectorSliceParameter.this.getParameter(n).getBounds().getLowerLimit(VectorSliceParameter.this.sliceDimension);
        }

        @Override
        public int getBoundsDimension() {
            return VectorSliceParameter.this.getDimension();
        }
    }
}

