/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.simpleDesign;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import org.ohdsi.simpleDesign.SimpleLinearModel;

abstract class SimpleLinearModelGradient
implements GradientWrtParameterProvider {
    final SimpleLinearModel linearModel;
    final Parameter argument;
    final Parameter effect;
    final Parameter precision;
    final DesignMatrix designMatrix;

    public SimpleLinearModelGradient(SimpleLinearModel linearModel) {
        this.linearModel = linearModel;
        this.argument = linearModel.getArgument();
        this.effect = linearModel.getEffects();
        this.precision = linearModel.getPrecision();
        this.designMatrix = linearModel.getDesignMatrix();
    }

    public Likelihood getLikelihood() {
        return this.linearModel;
    }

    double[] computeGradient() {
        double[] gradient = new double[this.argument.getDimension()];
        double[] innerProduct = this.linearModel.getInnerProduct();
        double tau = this.precision.getParameterValue(0);
        int i = 0;
        while (i < gradient.length) {
            gradient[i] = (innerProduct[i] - this.argument.getParameterValue(i)) * tau;
            ++i;
        }
        return gradient;
    }

    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError((GradientWrtParameterProvider)this, (double)((Double)this.getParameter().getBounds().getLowerLimit(0)), (double)((Double)this.getParameter().getBounds().getUpperLimit(0)), (Double)0.001);
    }
}

