/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;

public class PowerMathFunction
implements MathFunction,
MathFunctionWithFirstDerivative {
    private MathFunction func;
    private double a;
    private double b;
    private double power;

    public PowerMathFunction(MathFunction mathFunction, double d) {
        this(mathFunction, 1.0, 0.0, d);
    }

    public PowerMathFunction(MathFunction mathFunction, double d, double d2, double d3) {
        if (mathFunction == null) {
            throw new NullPointerException();
        }
        this.func = mathFunction;
        this.a = d;
        this.b = d2;
        this.power = d3;
    }

    public MathFunction getFunction() {
        return this.func;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getPower() {
        return this.power;
    }

    public double derivative(double d) {
        double d2 = MathFunctionUtil.derivative(this.func, d);
        return this.getA() * this.getPower() * Math.pow(this.getA() * this.func.evaluate(d) + this.getB(), this.getPower() - 1.0) * d2;
    }

    public double evaluate(double d) {
        double d2 = this.func.evaluate(d);
        return Math.pow(this.a * d2 + this.b, this.power);
    }
}

