/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class NonSparseToSparse
extends Filter
implements UnsupervisedFilter,
StreamableFilter {
    static final long serialVersionUID = 4694489111366063852L;

    public String globalInfo() {
        return "An instance filter that converts all incoming instances into sparse format.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        SparseInstance sparseInstance = new SparseInstance(instance);
        sparseInstance.setDataset(instance.dataset());
        this.push(sparseInstance);
        return true;
    }

    public static void main(String[] stringArray) {
        NonSparseToSparse.runFilter(new NonSparseToSparse(), stringArray);
    }
}

