/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Clas.neuralnet;

import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.softmax.ISoftmaxClassifier;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.AbstractNeuralNet;

public class NeuralNetClassifier
extends AbstractNeuralNet
implements ISoftmaxClassifier {
    @Override
    public byte[] classify(double[] inputs) {
        double[] obtained = this.rawOutputs(inputs);
        byte[] classes = new byte[this.outputLayer.getNofneurons() + 1];
        double max = obtained[0];
        classes[0] = 1;
        int index = 0;
        for (int j = 1; j < obtained.length; ++j) {
            if (!(obtained[j] >= max)) continue;
            classes[j] = 1;
            if (obtained[j] > max) {
                classes[index] = 0;
            }
            max = obtained[j];
            index = j;
        }
        return classes;
    }

    @Override
    public byte[][] classify(double[][] inputs) {
        double[][] obtained = this.rawOutputs(inputs);
        byte[][] classes = new byte[this.outputLayer.getNofneurons() + 1][inputs[0].length];
        double[] max = new double[inputs[0].length];
        System.arraycopy(obtained[0], 0, max, 0, inputs[0].length);
        int[] maxIndex = new int[inputs[0].length];
        for (int i = 0; i < maxIndex.length; ++i) {
            classes[0][i] = 1;
            maxIndex[i] = 0;
        }
        for (int j = 1; j < obtained.length; ++j) {
            for (int i = 0; i < inputs[0].length; ++i) {
                if (!(obtained[j][i] >= max[i])) continue;
                classes[j][i] = 1;
                if (obtained[j][i] > max[i]) {
                    classes[maxIndex[i]][i] = 0;
                }
                max[i] = obtained[j][i];
                maxIndex[i] = j;
            }
        }
        return classes;
    }

    @Override
    public double[] rawOutputs(double[] inputs) {
        double[] obtained = new double[this.outputLayer.getNofneurons() + 1];
        for (int i = 0; i < obtained.length - 1; ++i) {
            obtained[i] = this.outputLayer.getNeuron(i).operate(inputs);
        }
        obtained[obtained.length - 1] = 0.0;
        return obtained;
    }

    @Override
    public double[][] rawOutputs(double[][] inputs) {
        double[][] obtained = new double[this.outputLayer.getNofneurons() + 1][];
        for (int i = 0; i < obtained.length - 1; ++i) {
            obtained[i] = this.outputLayer.getNeuron(i).operate(inputs);
        }
        obtained[obtained.length - 1] = new double[inputs[0].length];
        for (int j = 0; j < inputs[0].length; ++j) {
            obtained[obtained.length - 1][j] = 0.0;
        }
        return obtained;
    }

    @Override
    public double[] softmaxProbabilities(double[] inputs) {
        int i;
        double[] probabilities = this.rawOutputs(inputs);
        double expSum = 0.0;
        for (i = 0; i < probabilities.length; ++i) {
            probabilities[i] = i != probabilities.length - 1 ? Math.exp(probabilities[i]) : 1.0;
            expSum += probabilities[i];
        }
        if (Double.isInfinite(expSum) || Double.isNaN(expSum)) {
            probabilities = this.rawOutputs(inputs);
            expSum = 0.0;
            for (i = 0; i < probabilities.length; ++i) {
                int n = i;
                probabilities[n] = probabilities[n] / 50000.0;
                probabilities[i] = i != probabilities.length - 1 ? Math.exp(probabilities[i]) : 1.0;
                expSum += probabilities[i];
            }
        }
        i = 0;
        while (i < probabilities.length) {
            int n = i++;
            probabilities[n] = probabilities[n] / expSum;
        }
        return probabilities;
    }

    @Override
    public double[][] softmaxProbabilities(double[][] inputs) {
        int j;
        int i;
        double[][] probabilities = this.rawOutputs(inputs);
        double[] expSum = new double[inputs[0].length];
        for (i = 0; i < expSum.length; ++i) {
            expSum[i] = 0.0;
        }
        for (i = 0; i < probabilities.length; ++i) {
            for (j = 0; j < inputs[0].length; ++j) {
                probabilities[i][j] = i != probabilities.length - 1 ? Math.exp(probabilities[i][j]) : 1.0;
                int n = j;
                expSum[n] = expSum[n] + probabilities[i][j];
            }
        }
        for (int j2 = 0; j2 < inputs[0].length; ++j2) {
            int i2;
            if (!Double.isInfinite(expSum[j2]) && !Double.isNaN(expSum[j2])) continue;
            probabilities = this.rawOutputs(inputs);
            for (i2 = 0; i2 < expSum.length; ++i2) {
                expSum[i2] = 0.0;
            }
            for (i2 = 0; i2 < probabilities.length; ++i2) {
                for (int k = 0; k < inputs[0].length; ++k) {
                    double[] dArray = probabilities[i2];
                    int n = k;
                    dArray[n] = dArray[n] / 50000.0;
                    probabilities[i2][k] = i2 != probabilities.length - 1 ? Math.exp(probabilities[i2][k]) : 1.0;
                    int n2 = k;
                    expSum[n2] = expSum[n2] + probabilities[i2][k];
                }
            }
            j2 = inputs[0].length;
        }
        for (i = 0; i < probabilities.length; ++i) {
            for (j = 0; j < inputs[0].length; ++j) {
                double[] dArray = probabilities[i];
                int n = j;
                dArray[n] = dArray[n] / expSum[j];
            }
        }
        return probabilities;
    }
}

