/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Selection.SGA;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Instance_Selection.SGA.Cromosoma;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import org.core.Fichero;
import org.core.Randomize;

public class SGA
extends Metodo {
    private long semilla;
    private double pMutacion1to0;
    private double pMutacion0to1;
    private double pCruce;
    private int tamPoblacion;
    private int nEval;
    private double alfa;
    private boolean torneo;
    private int kNeigh;

    public SGA(String ficheroScript) {
        super(ficheroScript);
    }

    public void ejecutar() {
        int j;
        int sel2;
        int sel1;
        Cromosoma[] newPob;
        int i;
        int nSel = 0;
        int ev = 0;
        double NUmax = 1.5;
        double NUmin = 0.5;
        long tiempo = System.currentTimeMillis();
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        Randomize.setSeed(this.semilla);
        Object[] poblacion = new Cromosoma[this.tamPoblacion];
        for (i = 0; i < this.tamPoblacion; ++i) {
            poblacion[i] = new Cromosoma(this.datosTrain.length);
        }
        for (i = 0; i < this.tamPoblacion; ++i) {
            poblacion[i].evalua(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.alfa, this.kNeigh, nClases, this.distanceEu);
        }
        if (this.torneo) {
            while (ev < this.nEval) {
                int comp2;
                newPob = new Cromosoma[2];
                int comp1 = Randomize.Randint(0, this.tamPoblacion - 1);
                while ((comp2 = Randomize.Randint(0, this.tamPoblacion - 1)) == comp1) {
                }
                sel1 = ((Cromosoma)poblacion[comp1]).getCalidad() > ((Cromosoma)poblacion[comp2]).getCalidad() ? comp1 : comp2;
                comp1 = Randomize.Randint(0, this.tamPoblacion - 1);
                while ((comp2 = Randomize.Randint(0, this.tamPoblacion - 1)) == comp1) {
                }
                sel2 = ((Cromosoma)poblacion[comp1]).getCalidad() > ((Cromosoma)poblacion[comp2]).getCalidad() ? comp1 : comp2;
                if (Randomize.Rand() < this.pCruce) {
                    this.crucePMX((Cromosoma[])poblacion, newPob, sel1, sel2);
                } else {
                    newPob[0] = new Cromosoma(this.datosTrain.length, (Cromosoma)poblacion[sel1]);
                    newPob[1] = new Cromosoma(this.datosTrain.length, (Cromosoma)poblacion[sel2]);
                }
                for (i = 0; i < 2; ++i) {
                    newPob[i].mutacion(this.pMutacion1to0, this.pMutacion0to1);
                }
                for (i = 0; i < 2; ++i) {
                    if (newPob[i].estaEvaluado()) continue;
                    newPob[i].evalua(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.alfa, this.kNeigh, nClases, this.distanceEu);
                    ++ev;
                }
                Arrays.sort(poblacion);
                poblacion[this.tamPoblacion - 2] = new Cromosoma(this.datosTrain.length, newPob[0]);
                poblacion[this.tamPoblacion - 1] = new Cromosoma(this.datosTrain.length, newPob[1]);
            }
        } else {
            double[] prob = new double[this.tamPoblacion];
            for (i = 0; i < this.tamPoblacion; ++i) {
                double aux = (NUmax - NUmin) * ((double)i / (double)(this.tamPoblacion - 1));
                prob[i] = 1.0 / (double)this.tamPoblacion * (NUmax - aux);
            }
            for (i = 1; i < this.tamPoblacion; ++i) {
                prob[i] = prob[i] + prob[i - 1];
            }
            while (ev < this.nEval) {
                Arrays.sort(poblacion);
                newPob = new Cromosoma[2];
                double pos1 = Randomize.Rand();
                double pos2 = Randomize.Rand();
                for (j = 0; j < this.tamPoblacion && prob[j] < pos1; ++j) {
                }
                sel1 = j;
                for (j = 0; j < this.tamPoblacion && prob[j] < pos2; ++j) {
                }
                sel2 = j;
                if (Randomize.Rand() < this.pCruce) {
                    this.crucePMX((Cromosoma[])poblacion, newPob, sel1, sel2);
                } else {
                    newPob[0] = new Cromosoma(this.datosTrain.length, (Cromosoma)poblacion[sel1]);
                    newPob[1] = new Cromosoma(this.datosTrain.length, (Cromosoma)poblacion[sel2]);
                }
                for (i = 0; i < 2; ++i) {
                    newPob[i].mutacion(this.pMutacion1to0, this.pMutacion0to1);
                }
                for (i = 0; i < 2; ++i) {
                    if (newPob[i].estaEvaluado()) continue;
                    newPob[i].evalua(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.alfa, this.kNeigh, nClases, this.distanceEu);
                    ++ev;
                }
                poblacion[this.tamPoblacion - 2] = new Cromosoma(this.datosTrain.length, newPob[0]);
                poblacion[this.tamPoblacion - 1] = new Cromosoma(this.datosTrain.length, newPob[1]);
            }
        }
        nSel = poblacion[0].genesActivos();
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        int l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!((Cromosoma)poblacion[0]).getGen(i)) continue;
            for (j = 0; j < this.datosTrain[0].length; ++j) {
                conjS[l][j] = this.datosTrain[i][j];
                conjR[l][j] = this.realTrain[i][j];
                conjN[l][j] = this.nominalTrain[i][j];
                conjM[l][j] = this.nulosTrain[i][j];
            }
            clasesS[l] = this.clasesTrain[i];
            ++l;
        }
        System.out.println("SGA " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        int[][] trainRealClass = new int[this.datosTrain.length][1];
        int[][] trainPrediction = new int[this.datosTrain.length][1];
        for (i = 0; i < this.datosTrain.length; ++i) {
            trainRealClass[i][0] = this.clasesTrain[i];
            trainPrediction[i][0] = KNN.evaluate(this.datosTrain[i], conjS, nClases, clasesS, this.kNeigh);
        }
        KNN.writeOutput(this.ficheroSalida[0], trainRealClass, trainPrediction, this.entradas, this.salida, this.relation);
        int[][] realClass = new int[this.datosTest.length][1];
        int[][] prediction = new int[this.datosTest.length][1];
        for (i = 0; i < realClass.length; ++i) {
            realClass[i][0] = this.clasesTest[i];
            prediction[i][0] = KNN.evaluate(this.datosTest[i], conjS, nClases, clasesS, this.kNeigh);
        }
        KNN.writeOutput(this.ficheroSalida[1], realClass, prediction, this.entradas, this.salida, this.relation);
    }

    public void crucePMX(Cromosoma[] poblacion, Cromosoma[] newPob, int sel1, int sel2) {
        int i;
        int limInf;
        int limSup;
        int e2;
        boolean[] temp = new boolean[this.datosTrain.length];
        int e1 = Randomize.Randint(0, this.datosTrain.length - 1);
        if (e1 > (e2 = Randomize.Randint(0, this.datosTrain.length - 1))) {
            limSup = e1;
            limInf = e2;
        } else {
            limSup = e2;
            limInf = e1;
        }
        for (i = 0; i < this.datosTrain.length; ++i) {
            temp[i] = i < limInf || i > limSup ? poblacion[sel1].getGen(i) : poblacion[sel2].getGen(i);
        }
        newPob[0] = new Cromosoma(temp);
        for (i = 0; i < this.datosTrain.length; ++i) {
            temp[i] = i < limInf || i > limSup ? poblacion[sel2].getGen(i) : poblacion[sel1].getGen(i);
        }
        newPob[1] = new Cromosoma(temp);
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroValidation = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.semilla = Long.parseLong(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.pMutacion1to0 = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.pMutacion0to1 = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.pCruce = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.tamPoblacion = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.nEval = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.alfa = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        token = token.substring(1);
        this.torneo = token.equalsIgnoreCase("binary_tournament");
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.kNeigh = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
    }
}

