/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection;

import java.util.HashSet;
import java.util.Iterator;
import keel.Algorithms.Preprocess.Basic.CheckException;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Fichero;

public class Datos {
    private String trainFileNames;
    private String testFileNames;
    private InstanceSet train;
    private InstanceSet test;
    private double[][] trainInputNormalized;
    private double[][] testInputNormalized;
    private int[] trainOutput;
    private int[] testOutput;
    private int paramKNN = 1;
    private boolean areDiscretized;

    public Datos(String trainFileNames1, String testFileNames1, int k) {
        this.trainFileNames = trainFileNames1;
        this.testFileNames = testFileNames1;
        if (k >= 1) {
            this.paramKNN = k;
        } else {
            System.err.println("WARNING: k-parameter for the KNN Classifier is fewer than 1");
            System.err.println("It will be assigned to 1");
            this.paramKNN = 1;
        }
        try {
            this.train = new InstanceSet();
            this.train.readSet(this.trainFileNames, true);
            this.normalizeTraining();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(0);
        }
        try {
            this.test = new InstanceSet();
            this.test.readSet(this.testFileNames, false);
            this.normalizeTest();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(0);
        }
        this.areDiscretized = true;
        for (int i = 0; i < Attributes.getInputNumAttributes() && this.areDiscretized; ++i) {
            if (Attributes.getInputAttribute(i).getType() != 1 && Attributes.getInputAttribute(i).getType() != 2) continue;
            this.areDiscretized = false;
        }
    }

    public int returnNumFeatures() {
        if (this.train == null || this.test == null) {
            System.err.println("ERROR: Dataset hasn't already read. It's not possible to return the number of features");
            System.exit(0);
        }
        return Attributes.getInputNumAttributes();
    }

    public int returnNumInstances() {
        if (this.train == null || this.test == null) {
            System.err.println("ERROR: Dataset hasn't already read. It's not possible to return the number of instances");
            System.exit(0);
        }
        return this.train.getNumInstances();
    }

    private void normalizeTraining() throws CheckException {
        if (Attributes.getOutputNumAttributes() < 1) {
            throw new CheckException("This dataset hasn't outputs, so it's not corresponding to a classification problem.");
        }
        if (Attributes.getOutputNumAttributes() > 1) {
            throw new CheckException("This dataset has more than an output.");
        }
        if (Attributes.getOutputAttribute(0).getType() == 2) {
            throw new CheckException("This dataset has an input attribute with floating values, so it's not corresponding to a classification problem.");
        }
        this.trainInputNormalized = new double[this.train.getNumInstances()][Attributes.getInputNumAttributes()];
        this.trainOutput = new int[this.train.getNumInstances()];
        double[] caja = new double[1];
        for (int i = 0; i < this.train.getNumInstances(); ++i) {
            int j;
            Instance temp = this.train.getInstance(i);
            boolean[] nulls = temp.getInputMissingValues();
            this.trainInputNormalized[i] = new double[Attributes.getInputNumAttributes()];
            double[] vectorInputs = this.train.getInstance(i).getAllInputValues();
            for (j = 0; j < vectorInputs.length; ++j) {
                this.trainInputNormalized[i][j] = vectorInputs[j];
            }
            for (j = 0; j < nulls.length; ++j) {
                if (!nulls[j]) continue;
                this.trainInputNormalized[i][j] = 0.0;
            }
            caja = this.train.getInstance(i).getAllOutputValues();
            this.trainOutput[i] = (int)caja[0];
            for (int k = 0; k < this.trainInputNormalized[i].length; ++k) {
                if (Attributes.getInputAttribute(k).getType() == 0) {
                    if (Attributes.getInputAttribute(k).getNominalValuesList().size() - 1 == 0) {
                        this.trainInputNormalized[i][k] = 0.0;
                        continue;
                    }
                    double[] dArray = this.trainInputNormalized[i];
                    int n = k;
                    dArray[n] = dArray[n] / (double)(Attributes.getInputAttribute(k).getNominalValuesList().size() - 1);
                    continue;
                }
                double[] dArray = this.trainInputNormalized[i];
                int n = k;
                dArray[n] = dArray[n] - Attributes.getInputAttribute(k).getMinAttribute();
                if (Attributes.getInputAttribute(k).getMaxAttribute() - Attributes.getInputAttribute(k).getMinAttribute() == 0.0) {
                    this.trainInputNormalized[i][k] = 0.0;
                    continue;
                }
                double[] dArray2 = this.trainInputNormalized[i];
                int n2 = k;
                dArray2[n2] = dArray2[n2] / (Attributes.getInputAttribute(k).getMaxAttribute() - Attributes.getInputAttribute(k).getMinAttribute());
            }
        }
    }

    private void normalizeTest() throws CheckException {
        if (Attributes.getOutputNumAttributes() < 1) {
            throw new CheckException("This dataset hasn't outputs, so it's not corresponding to a classification problem.");
        }
        if (Attributes.getOutputNumAttributes() > 1) {
            throw new CheckException("This dataset has more than an output.");
        }
        if (Attributes.getOutputAttribute(0).getType() == 2) {
            throw new CheckException("This dataset has an input attribute with floating values, so it's not corresponding to a classification problem.");
        }
        this.testInputNormalized = new double[this.test.getNumInstances()][Attributes.getInputNumAttributes()];
        this.testOutput = new int[this.test.getNumInstances()];
        double[] caja = new double[1];
        for (int i = 0; i < this.test.getNumInstances(); ++i) {
            int j;
            Instance temp = this.test.getInstance(i);
            boolean[] nulls = temp.getInputMissingValues();
            this.testInputNormalized[i] = new double[Attributes.getInputNumAttributes()];
            double[] vectorInputs = this.test.getInstance(i).getAllInputValues();
            for (j = 0; j < vectorInputs.length; ++j) {
                this.testInputNormalized[i][j] = vectorInputs[j];
            }
            for (j = 0; j < nulls.length; ++j) {
                if (!nulls[j]) continue;
                this.testInputNormalized[i][j] = 0.0;
            }
            caja = this.test.getInstance(i).getAllOutputValues();
            this.testOutput[i] = (int)caja[0];
            for (int k = 0; k < this.testInputNormalized[i].length; ++k) {
                if (Attributes.getInputAttribute(k).getType() == 0) {
                    if (Attributes.getInputAttribute(k).getNominalValuesList().size() - 1 == 0) {
                        this.testInputNormalized[i][k] = 0.0;
                        continue;
                    }
                    double[] dArray = this.testInputNormalized[i];
                    int n = k;
                    dArray[n] = dArray[n] / (double)(Attributes.getInputAttribute(k).getNominalValuesList().size() - 1);
                    continue;
                }
                double[] dArray = this.testInputNormalized[i];
                int n = k;
                dArray[n] = dArray[n] - Attributes.getInputAttribute(k).getMinAttribute();
                if (Attributes.getInputAttribute(k).getMaxAttribute() - Attributes.getInputAttribute(k).getMinAttribute() == 0.0) {
                    this.testInputNormalized[i][k] = 0.0;
                    continue;
                }
                double[] dArray2 = this.testInputNormalized[i];
                int n2 = k;
                dArray2[n2] = dArray2[n2] / (Attributes.getInputAttribute(k).getMaxAttribute() - Attributes.getInputAttribute(k).getMinAttribute());
            }
        }
    }

    private static double distancia(double[] ej1, double[] ej2, boolean[] featuresVector) {
        double suma = 0.0;
        for (int i = 0; i < ej1.length; ++i) {
            if (!featuresVector[i]) continue;
            suma += (ej1[i] - ej2[i]) * (ej1[i] - ej2[i]);
        }
        suma = Math.sqrt(suma);
        return suma;
    }

    public double LVO(boolean[] featuresVector) {
        int errores = 0;
        double[] distancias = new double[this.train.getNumInstances()];
        int[] kClases = new int[this.paramKNN];
        for (int i = 0; i < this.train.getNumInstances(); ++i) {
            int k;
            int j;
            for (j = 0; j < this.train.getNumInstances(); ++j) {
                distancias[j] = i != j ? Datos.distancia(this.trainInputNormalized[i], this.trainInputNormalized[j], featuresVector) : Double.MAX_VALUE;
            }
            for (k = 0; k < this.paramKNN; ++k) {
                double min = Double.MAX_VALUE;
                int posMin = -1;
                for (j = 0; j < distancias.length; ++j) {
                    if (!(distancias[j] < min)) continue;
                    min = distancias[j];
                    posMin = j;
                }
                distancias[posMin] = Double.MAX_VALUE;
                kClases[k] = this.trainOutput[posMin];
            }
            double media = 0.0;
            for (k = 0; k < this.paramKNN; ++k) {
                media += (double)kClases[k];
            }
            if (this.trainOutput[i] == (int)Math.round(media /= (double)this.paramKNN)) continue;
            ++errores;
        }
        return (double)errores / (double)this.train.getNumInstances();
    }

    public double medidaInconsistencia(boolean[] featuresVector) {
        int i;
        double ratioInconsistencias = 0.0;
        if (!this.areDiscretized) {
            System.err.println("ERROR: Data values aren't discretized!. This is an algorithm precondition");
            System.exit(0);
        }
        int[] inconClase = new int[Attributes.getOutputAttribute(0).getNominalValuesList().size()];
        for (i = 0; i < inconClase.length; ++i) {
            inconClase[i] = 0;
        }
        boolean[] vMarcados = new boolean[this.train.getNumInstances()];
        for (i = 0; i < this.train.getNumInstances(); ++i) {
            int j;
            if (vMarcados[i]) continue;
            int n = (int)this.train.getOutputNumericValue(i, 0);
            inconClase[n] = inconClase[n] + 1;
            vMarcados[i] = true;
            for (j = i + 1; j < this.train.getNumInstances(); ++j) {
                if (vMarcados[j]) continue;
                boolean caracsIguales = true;
                for (int k = 0; k < Attributes.getInputNumAttributes() && caracsIguales; ++k) {
                    if (!featuresVector[k] || this.train.getInputNumericValue(i, k) == this.train.getInputNumericValue(j, k)) continue;
                    caracsIguales = false;
                }
                if (!caracsIguales) continue;
                int n2 = (int)this.train.getOutputNumericValue(j, 0);
                inconClase[n2] = inconClase[n2] + 1;
                vMarcados[j] = true;
            }
            int max = 0;
            int cuenta = 0;
            for (j = 0; j < inconClase.length; ++j) {
                if (inconClase[j] > max) {
                    max = inconClase[j];
                }
                cuenta += inconClase[j];
            }
            ratioInconsistencias += (double)(cuenta -= max);
            for (j = 0; j < inconClase.length; ++j) {
                inconClase[j] = 0;
            }
        }
        return ratioInconsistencias /= (double)this.train.getNumInstances();
    }

    public double measureIEP(boolean[] featuresVector) {
        int i;
        double ratioInconsistencias = 0.0;
        if (!this.areDiscretized) {
            System.err.println("ERROR: Data values aren't discretized!. This is an algorithm precondition");
            System.exit(0);
        }
        int[] inconClase = new int[Attributes.getOutputAttribute(0).getNominalValuesList().size()];
        for (i = 0; i < inconClase.length; ++i) {
            inconClase[i] = 0;
        }
        boolean[] vMarcados = new boolean[this.train.getNumInstances()];
        for (i = 0; i < this.train.getNumInstances(); ++i) {
            int j;
            if (vMarcados[i]) continue;
            int n = (int)this.train.getOutputNumericValue(i, 0);
            inconClase[n] = inconClase[n] + 1;
            vMarcados[i] = true;
            for (j = i + 1; j < this.train.getNumInstances(); ++j) {
                if (vMarcados[j]) continue;
                boolean caracsIguales = true;
                for (int k = 0; k < Attributes.getInputNumAttributes() && caracsIguales; ++k) {
                    if (!featuresVector[k] || this.train.getInputNumericValue(i, k) == this.train.getInputNumericValue(j, k)) continue;
                    caracsIguales = false;
                }
                if (!caracsIguales) continue;
                int n2 = (int)this.train.getOutputNumericValue(j, 0);
                inconClase[n2] = inconClase[n2] + 1;
                vMarcados[j] = true;
            }
            int max = 0;
            int cuenta = 0;
            for (j = 0; j < inconClase.length; ++j) {
                if (inconClase[j] > max) {
                    max = inconClase[j];
                }
                cuenta += inconClase[j];
            }
            ratioInconsistencias += (double)((cuenta -= max) * (cuenta - 1) / 2);
            for (j = 0; j < inconClase.length; ++j) {
                inconClase[j] = 0;
            }
        }
        return ratioInconsistencias /= (double)(this.train.getNumInstances() * (this.train.getNumInstances() - 1) / 2);
    }

    public double[] obtenerIMVarsClase() {
        if (!this.areDiscretized) {
            System.err.println("ERROR: Data values aren't discretized!. This is an algorithm precondition");
            System.exit(0);
        }
        double[] I = new double[Attributes.getInputNumAttributes()];
        int max_num_inter = -1;
        for (int k = 0; k < I.length; ++k) {
            if (Attributes.getInputAttribute(k).getNominalValuesList().size() <= max_num_inter) continue;
            max_num_inter = Attributes.getInputAttribute(k).getNominalValuesList().size();
        }
        int numeroIntervalos = max_num_inter;
        int numeroValoresClase = Attributes.getOutputAttribute(0).getNominalValuesList().size();
        for (int k = 0; k < I.length; ++k) {
            int i;
            int[] nc = new int[numeroValoresClase];
            int[] nf = new int[numeroIntervalos];
            int[][] ncf = new int[numeroValoresClase][numeroIntervalos];
            for (i = 0; i < this.train.getNumInstances(); ++i) {
                int posNC = (int)this.train.getOutputNumericValue(i, 0);
                int posNF = Integer.valueOf(this.train.getInputNominalValue(i, k));
                int n = posNC;
                nc[n] = nc[n] + 1;
                int n2 = posNF;
                nf[n2] = nf[n2] + 1;
                int[] nArray = ncf[posNC];
                int n3 = posNF;
                nArray[n3] = nArray[n3] + 1;
            }
            double suma = 0.0;
            for (i = 0; i < numeroValoresClase; ++i) {
                double pc = (double)nc[i] / (double)this.train.getNumInstances();
                for (int j = 0; j < numeroIntervalos; ++j) {
                    double pcf = (double)ncf[i][j] / (double)this.train.getNumInstances();
                    double pf = (double)nf[j] / (double)this.train.getNumInstances();
                    if (pf == 0.0 || pcf == 0.0 || pc == 0.0) continue;
                    suma += pcf * (Math.log10(pcf / (pc * pf)) / Math.log10(2.0));
                }
            }
            I[k] = suma;
        }
        return I;
    }

    public double[][] obtenerIMVars() {
        if (!this.areDiscretized) {
            System.err.println("ERROR: Data values aren't discretized! This is an algorithm precondition");
            System.exit(0);
        }
        double[][] IMV = new double[Attributes.getInputNumAttributes()][Attributes.getInputNumAttributes()];
        int max_num_inter = -1;
        for (int k = 0; k < Attributes.getInputNumAttributes(); ++k) {
            if (Attributes.getInputAttribute(k).getNominalValuesList().size() <= max_num_inter) continue;
            max_num_inter = Attributes.getInputAttribute(k).getNominalValuesList().size();
        }
        int numeroIntervalos = max_num_inter;
        for (int k = 0; k < Attributes.getInputNumAttributes(); ++k) {
            for (int l = 0; l < Attributes.getInputNumAttributes(); ++l) {
                int i;
                int[] nx = new int[numeroIntervalos];
                int[] ny = new int[numeroIntervalos];
                int[][] nxy = new int[numeroIntervalos][numeroIntervalos];
                for (i = 0; i < this.train.getNumInstances(); ++i) {
                    int posNX = Integer.valueOf(this.train.getInputNominalValue(i, k));
                    int posNY = Integer.valueOf(this.train.getInputNominalValue(i, l));
                    int n = posNX;
                    nx[n] = nx[n] + 1;
                    int n2 = posNY;
                    ny[n2] = ny[n2] + 1;
                    int[] nArray = nxy[posNX];
                    int n3 = posNY;
                    nArray[n3] = nArray[n3] + 1;
                }
                double suma = 0.0;
                for (i = 0; i < numeroIntervalos; ++i) {
                    double px = (double)nx[i] / (double)this.train.getNumInstances();
                    for (int j = 0; j < numeroIntervalos; ++j) {
                        double py = (double)ny[j] / (double)this.train.getNumInstances();
                        double pxy = (double)nxy[i][j] / (double)this.train.getNumInstances();
                        if (px == 0.0 || py == 0.0 || pxy == 0.0) continue;
                        suma += pxy * (Math.log10(pxy / (px * py)) / Math.log10(2.0));
                    }
                }
                IMV[k][l] = suma;
            }
        }
        return IMV;
    }

    public int findNearestHit(int posI) {
        int j;
        double[] distancias = new double[this.train.getNumInstances()];
        boolean[] featuresVector = new boolean[this.returnNumFeatures()];
        for (j = 0; j < featuresVector.length; ++j) {
            featuresVector[j] = true;
        }
        for (j = 0; j < distancias.length; ++j) {
            distancias[j] = posI != j ? Datos.distancia(this.trainInputNormalized[posI], this.trainInputNormalized[j], featuresVector) : Double.MAX_VALUE;
        }
        double min = Double.MAX_VALUE;
        int posMin = -1;
        for (j = 0; j < distancias.length; ++j) {
            if (!(distancias[j] < min) || this.train.getInstance(j).getOutputRealValues(0) != this.train.getInstance(posI).getOutputRealValues(0)) continue;
            min = distancias[j];
            posMin = j;
        }
        return posMin;
    }

    public int findNearestMiss(int posI) {
        int j;
        double[] distancias = new double[this.train.getNumInstances()];
        boolean[] featuresVector = new boolean[this.returnNumFeatures()];
        for (j = 0; j < featuresVector.length; ++j) {
            featuresVector[j] = true;
        }
        for (j = 0; j < distancias.length; ++j) {
            distancias[j] = posI != j ? Datos.distancia(this.trainInputNormalized[posI], this.trainInputNormalized[j], featuresVector) : Double.MAX_VALUE;
        }
        double min = Double.MAX_VALUE;
        int posMin = -1;
        for (j = 0; j < distancias.length; ++j) {
            if (!(distancias[j] < min) || this.train.getInstance(j).getOutputRealValues(0) == this.train.getInstance(posI).getOutputRealValues(0)) continue;
            min = distancias[j];
            posMin = j;
        }
        return posMin;
    }

    private double[] getAllClassesTrain() {
        HashSet<Double> c = new HashSet<Double>(0);
        for (int i = 0; i < this.train.getNumInstances(); ++i) {
            Double d = new Double(this.train.getInstance(i).getOutputRealValues(0));
            if (c.contains(d)) continue;
            c.add(d);
        }
        double[] classes = new double[c.size()];
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            classes[i] = (Double)it.next();
            ++i;
        }
        return classes;
    }

    private double probPriori(double theClass) {
        int count = 0;
        for (int i = 0; i < this.train.getNumInstances(); ++i) {
            if (this.train.getInstance(i).getOutputRealValues(0) != theClass) continue;
            ++count;
        }
        return (double)count / (double)this.train.getNumInstances();
    }

    public double sumDifferentClasses(int posExample, int feature) {
        double[] classes = this.getAllClassesTrain();
        double exampleClass = this.train.getInstance(posExample).getOutputRealValues(0);
        double sum = 0.0;
        int posMiss = this.findNearestMiss(posExample);
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] == exampleClass) continue;
            sum += this.probPriori(classes[i]) * (double)this.diff(feature, posExample, posMiss);
        }
        return sum;
    }

    public int diff(int numCarac, int numInstancia1, int numInstancia2) {
        if (!this.areDiscretized) {
            System.err.println("ERROR: Data values aren't discretized! This is an algorithm precondition ");
            System.exit(0);
        }
        if (this.train.getInstance(numInstancia1).getInputRealValues(numCarac) == this.train.getInstance(numInstancia2).getInputRealValues(numCarac)) {
            return 0;
        }
        return 1;
    }

    public double LVOTest(boolean[] featuresVector) {
        int errores = 0;
        double[] distancias = new double[this.test.getNumInstances()];
        int[] kClases = new int[this.paramKNN];
        for (int i = 0; i < this.test.getNumInstances(); ++i) {
            int k;
            int j;
            for (j = 0; j < this.test.getNumInstances(); ++j) {
                distancias[j] = i != j ? Datos.distancia(this.testInputNormalized[i], this.testInputNormalized[j], featuresVector) : Double.MAX_VALUE;
            }
            for (k = 0; k < this.paramKNN; ++k) {
                double min = Double.MAX_VALUE;
                int posMin = -1;
                for (j = 0; j < distancias.length; ++j) {
                    if (!(distancias[j] < min)) continue;
                    min = distancias[j];
                    posMin = j;
                }
                distancias[posMin] = Double.MAX_VALUE;
                kClases[k] = this.testOutput[posMin];
            }
            double media = 0.0;
            for (k = 0; k < this.paramKNN; ++k) {
                media += (double)kClases[k];
            }
            if (this.testOutput[i] == (int)Math.round(media /= (double)this.paramKNN)) continue;
            ++errores;
        }
        return (double)errores / (double)this.test.getNumInstances();
    }

    public double validacionCruzada(boolean[] featuresVector) {
        int errores = 0;
        double[] distancias = new double[this.train.getNumInstances()];
        int[] kClases = new int[this.paramKNN];
        for (int i = 0; i < this.test.getNumInstances(); ++i) {
            int k;
            int j;
            for (j = 0; j < this.train.getNumInstances(); ++j) {
                distancias[j] = Datos.distancia(this.testInputNormalized[i], this.trainInputNormalized[j], featuresVector);
            }
            for (k = 0; k < this.paramKNN; ++k) {
                double min = Double.MAX_VALUE;
                int posMin = -1;
                for (j = 0; j < distancias.length; ++j) {
                    if (!(distancias[j] < min)) continue;
                    min = distancias[j];
                    posMin = j;
                }
                distancias[posMin] = Double.MAX_VALUE;
                kClases[k] = this.trainOutput[posMin];
            }
            double media = 0.0;
            for (k = 0; k < this.paramKNN; ++k) {
                media += (double)kClases[k];
            }
            if (this.testOutput[i] == (int)Math.round(media /= (double)this.paramKNN)) continue;
            ++errores;
        }
        return (double)errores / (double)this.test.getNumInstances();
    }

    public void generarFicherosSalida(String ficheroTrainSalida, String ficheroTestSalida, boolean[] solucion) {
        Fichero fic = new Fichero();
        int k = 0;
        int i = 0;
        while (i < Attributes.getInputNumAttributes()) {
            if (!solucion[k]) {
                this.train.removeAttribute(this.test, true, i);
            } else {
                ++i;
            }
            ++k;
        }
        String cadena = this.train.getNewHeader();
        cadena = cadena + "@data\n";
        for (i = 0; i < this.train.getNumInstances(); ++i) {
            cadena = cadena + this.train.getInstance(i).toString() + "\n";
        }
        Fichero.escribeFichero(ficheroTrainSalida, cadena);
        cadena = this.test.getNewHeader();
        cadena = cadena + "@data\n";
        for (i = 0; i < this.test.getNumInstances(); ++i) {
            cadena = cadena + this.test.getInstance(i).toString() + "\n";
        }
        Fichero.escribeFichero(ficheroTestSalida, cadena);
    }
}

