/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCBA;

import java.util.ArrayList;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Item;
import keel.Algorithms.Associative_Classification.ClassifierCBA.myDataset;

public class Itemset
implements Comparable {
    ArrayList<Item> itemset;
    int clas;
    double support;
    double supportRule;
    double per;
    int hits;
    int misses;

    public Itemset() {
    }

    public Itemset(int clas) {
        this.itemset = new ArrayList();
        this.clas = clas;
        this.support = 0.0;
        this.supportRule = 0.0;
        this.per = 0.0;
        this.hits = 0;
        this.misses = 0;
    }

    public Itemset clone() {
        Itemset d = new Itemset(this.clas);
        for (int i = 0; i < this.itemset.size(); ++i) {
            d.add(this.itemset.get(i).clone());
        }
        d.clas = this.clas;
        d.support = this.support;
        d.supportRule = this.supportRule;
        d.per = this.per;
        d.hits = this.hits;
        d.misses = this.misses;
        return d;
    }

    public void add(Item item) {
        this.itemset.add(item);
    }

    public Item get(int pos) {
        return this.itemset.get(pos);
    }

    public Item remove(int pos) {
        return this.itemset.remove(pos);
    }

    public int size() {
        return this.itemset.size();
    }

    public double getSupport() {
        return this.support;
    }

    public double getSupportClass() {
        return this.supportRule;
    }

    public int getHits() {
        return this.hits;
    }

    public int getMisses() {
        return this.misses;
    }

    public double getPer() {
        return this.per;
    }

    public int getClas() {
        return this.clas;
    }

    public void setClas(int clas) {
        this.clas = clas;
    }

    public boolean isEqual(Itemset a) {
        if (this.itemset.size() != a.size()) {
            return false;
        }
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item item = this.itemset.get(i);
            if (item.isEqual(a.get(i))) continue;
            return false;
        }
        return this.clas == a.getClas();
    }

    public boolean isEqualAnt(Itemset a) {
        if (this.itemset.size() != a.size()) {
            return false;
        }
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item item = this.itemset.get(i);
            if (item.isEqual(a.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isSubItemset(Itemset a) {
        if (this.clas != a.getClas()) {
            return false;
        }
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item itemi = this.itemset.get(i);
            boolean stop = false;
            for (int j = 0; j < a.itemset.size() && !stop; ++j) {
                Item itemj = a.itemset.get(j);
                if (itemi.isEqual(itemj)) {
                    stop = true;
                    continue;
                }
                if (itemj.getVariable() < itemi.getVariable()) continue;
                return false;
            }
            if (stop) continue;
            return false;
        }
        return true;
    }

    public void calculateSupports(myDataset train) {
        this.support = 0.0;
        this.supportRule = 0.0;
        this.hits = 0;
        this.misses = 0;
        for (int i = 0; i < train.size(); ++i) {
            double degree = this.degree(train.getExample(i));
            if (!(degree > 0.0)) continue;
            this.support += degree;
            if (train.getOutputAsInteger(i) == this.clas) {
                this.supportRule += degree;
                ++this.hits;
                continue;
            }
            ++this.misses;
        }
        this.support /= (double)train.getnData();
        this.supportRule /= (double)train.getnData();
        this.per = (1.0 * (double)this.misses + this.errors((double)this.hits + (double)this.misses * 1.0, (double)this.misses * 1.0, 0.25)) / (double)(this.misses + this.hits);
    }

    private double degree(int[] example) {
        double degree = 1.0;
        for (int i = 0; i < this.itemset.size() && degree > 0.0; ++i) {
            Item item = this.itemset.get(i);
            if (item.getValue() == example[item.getVariable()]) continue;
            degree = 0.0;
        }
        return degree;
    }

    private double errors(double N, double e, double CF) {
        double[] Val = new double[]{0.0, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 5.0E-5, 1.0E-4, 5.0E-4, 0.001, 0.005, 0.01, 0.05, 0.1, 0.2, 0.4, 1.0};
        double[] Dev = new double[]{100.0, 6.0, 5.61, 5.2, 4.75, 4.26, 3.89, 3.72, 3.29, 3.09, 2.58, 2.33, 1.65, 1.28, 0.84, 0.25, 0.0};
        double Coeff = 0.0;
        int i = 0;
        while (CF > Val[i]) {
            ++i;
        }
        Coeff = Dev[i - 1] + (Dev[i] - Dev[i - 1]) * (CF - Val[i - 1]) / (Val[i] - Val[i - 1]);
        Coeff *= Coeff;
        if (e < 1.0E-6) {
            return N * (1.0 - Math.exp(Math.log(CF) / N));
        }
        if (e < 0.9999) {
            double Val0 = N * (1.0 - Math.exp(Math.log(CF) / N));
            return Val0 + e * (this.errors(N, 1.0, CF) - Val0);
        }
        if (e + 0.5 >= N) {
            return 0.67 * (N - e);
        }
        double Pr = (e + 0.5 + Coeff / 2.0 + Math.sqrt(Coeff * ((e + 0.5) * (1.0 - (e + 0.5) / N) + Coeff / 4.0))) / (N + Coeff);
        return N * Pr - e;
    }

    public int compareTo(Object a) {
        for (int i = 0; i < this.size(); ++i) {
            Item itemi = this.itemset.get(i);
            Item itemj = ((Itemset)a).get(i);
            if (itemj.variable > itemi.variable) {
                return -1;
            }
            if (itemj.variable < itemi.variable) {
                return 1;
            }
            if (itemj.value > itemi.value) {
                return -1;
            }
            if (itemj.value >= itemi.value) continue;
            return 1;
        }
        if (((Itemset)a).getClas() > this.getClas()) {
            return -1;
        }
        if (((Itemset)a).getClas() < this.getClas()) {
            return 1;
        }
        return 0;
    }
}

