/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.selector;

import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.fitness.IValueFitness;
import net.sourceforge.jclec.selector.StochasticSelector;
import org.apache.commons.lang.builder.EqualsBuilder;

public class RouletteSelector
extends StochasticSelector {
    private static final long serialVersionUID = -7486679623259737868L;
    protected transient double[] roulette;

    public RouletteSelector() {
    }

    public RouletteSelector(ISystem context) {
        super(context);
    }

    @Override
    protected void prepareSelection() {
        if (this.roulette == null || this.roulette.length != this.actsrcsz) {
            this.roulette = new double[this.actsrcsz];
        }
        double acc = 0.0;
        int idx = 0;
        for (IIndividual ind : this.actsrc) {
            this.roulette[idx++] = acc += ((IValueFitness)ind.getFitness()).getValue();
        }
        while (idx > 0) {
            if (acc != 0.0) {
                int n = --idx;
                this.roulette[n] = this.roulette[n] / acc;
                continue;
            }
            --idx;
        }
    }

    @Override
    protected IIndividual selectNext() {
        double value = this.randgen.raw();
        int i = 0;
        while (i < this.actsrcsz) {
            if (value < this.roulette[i]) {
                return (IIndividual)this.actsrc.get(i);
            }
            ++i;
        }
        return (IIndividual)this.actsrc.get(this.randgen.choose(0, this.roulette.length - 1));
    }

    public boolean equals(Object other) {
        if (other instanceof RouletteSelector) {
            RouletteSelector o = (RouletteSelector)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.randgen, o.randgen);
            return eb.isEquals();
        }
        return false;
    }
}

