/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util.dataset;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.jclec.util.dataset.AbstractAttribute;
import net.sourceforge.jclec.util.dataset.AttributeType;
import net.sourceforge.jclec.util.intset.Closure;
import net.sourceforge.jclec.util.intset.Interval;

public class CategoricalAttribute
extends AbstractAttribute {
    private static final long serialVersionUID = 1L;
    protected List<String> categories = new ArrayList<String>();
    protected transient Hashtable<String, Double> categoryToValue = new Hashtable();
    protected transient Hashtable<Double, String> valueToCategory = new Hashtable();

    public CategoricalAttribute() {
    }

    public CategoricalAttribute(String name) {
        super(name);
    }

    public CategoricalAttribute(String name, List<String> categories) {
        super(name);
        this.setCategories(categories);
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
        this.categoryToValue.clear();
        this.valueToCategory.clear();
        double aux = 0.0;
        for (String category : categories) {
            if (!this.categoryToValue.containsKey(category)) {
                this.categoryToValue.put(category, aux);
                this.valueToCategory.put(aux, category);
                aux += 1.0;
                continue;
            }
            throw new IllegalArgumentException("List of categories contain duplicated values");
        }
    }

    public Interval intervalValues() {
        Interval interval = new Interval(1, this.categories.size(), Closure.ClosedClosed);
        return interval;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    public AttributeType getType() {
        return AttributeType.Categorical;
    }

    @Override
    public boolean isValid(double ivalue) {
        return this.valueToCategory.containsKey(ivalue);
    }

    @Override
    public boolean isValid(Object evalue) {
        if (evalue instanceof String) {
            return this.categoryToValue.containsKey(evalue);
        }
        throw new IllegalArgumentException("String expected");
    }

    @Override
    public double parse(String string) {
        if (this.categoryToValue.containsKey(string)) {
            return this.categoryToValue.get(string);
        }
        return -1.0;
    }

    @Override
    public String show(double ivalue) {
        if (this.valueToCategory.containsKey(new Double(ivalue))) {
            return this.valueToCategory.get(new Double(ivalue));
        }
        return null;
    }
}

