/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.sax;

import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.labels.LabelAction;
import de.l3s.boilerpipe.sax.DefaultTagActionMap;
import de.l3s.boilerpipe.sax.TagAction;
import de.l3s.boilerpipe.sax.TagActionMap;
import de.l3s.boilerpipe.util.UnicodeTokenizer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoilerpipeHTMLContentHandler
implements ContentHandler {
    private final Map<String, TagAction> tagActions;
    private String title = null;
    static final String ANCHOR_TEXT_START = "$\ue00a<";
    static final String ANCHOR_TEXT_END = ">\ue00a$";
    StringBuilder tokenBuffer = new StringBuilder();
    StringBuilder textBuffer = new StringBuilder();
    int inBody = 0;
    int inAnchor = 0;
    int inIgnorableElement = 0;
    int tagLevel = 0;
    int blockTagLevel = -1;
    boolean sbLastWasWhitespace = false;
    private int textElementIdx = 0;
    private final List<TextBlock> textBlocks = new ArrayList<TextBlock>();
    private String lastStartTag = null;
    private String lastEndTag = null;
    private Event lastEvent = null;
    private int offsetBlocks = 0;
    private BitSet currentContainedTextElements = new BitSet();
    private boolean flush = false;
    boolean inAnchorText = false;
    LinkedList<LinkedList<LabelAction>> labelStacks = new LinkedList();
    LinkedList<Integer> fontSizeStack = new LinkedList();
    private static final Pattern PAT_VALID_WORD_CHARACTER = Pattern.compile("[\\p{L}\\p{Nd}\\p{Nl}\\p{No}]");

    public void recycle() {
        this.tokenBuffer.setLength(0);
        this.textBuffer.setLength(0);
        this.inBody = 0;
        this.inAnchor = 0;
        this.inIgnorableElement = 0;
        this.sbLastWasWhitespace = false;
        this.textElementIdx = 0;
        this.textBlocks.clear();
        this.lastStartTag = null;
        this.lastEndTag = null;
        this.lastEvent = null;
        this.offsetBlocks = 0;
        this.currentContainedTextElements.clear();
        this.flush = false;
        this.inAnchorText = false;
    }

    public BoilerpipeHTMLContentHandler() {
        this(DefaultTagActionMap.INSTANCE);
    }

    public BoilerpipeHTMLContentHandler(TagActionMap tagActions) {
        this.tagActions = tagActions;
    }

    @Override
    public void endDocument() throws SAXException {
        this.flushBlock();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.sbLastWasWhitespace) {
            this.textBuffer.append(' ');
            this.tokenBuffer.append(' ');
        }
        this.sbLastWasWhitespace = true;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.labelStacks.add(null);
        TagAction ta = this.tagActions.get(localName);
        if (ta != null) {
            if (ta.changesTagLevel()) {
                ++this.tagLevel;
            }
            this.flush = ta.start(this, localName, qName, atts) | this.flush;
        } else {
            ++this.tagLevel;
            this.flush = true;
        }
        this.lastEvent = Event.START_TAG;
        this.lastStartTag = localName;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        TagAction ta = this.tagActions.get(localName);
        this.flush = ta != null ? ta.end(this, localName, qName) | this.flush : true;
        if (ta == null || ta.changesTagLevel()) {
            --this.tagLevel;
        }
        if (this.flush) {
            this.flushBlock();
        }
        this.lastEvent = Event.END_TAG;
        this.lastEndTag = localName;
        this.labelStacks.removeLast();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        char c;
        ++this.textElementIdx;
        if (this.flush) {
            this.flushBlock();
            this.flush = false;
        }
        if (this.inIgnorableElement != 0) {
            return;
        }
        boolean startWhitespace = false;
        boolean endWhitespace = false;
        if (length == 0) {
            return;
        }
        int end = start + length;
        for (int i = start; i < end; ++i) {
            if (!Character.isWhitespace(ch[i])) continue;
            ch[i] = 32;
        }
        while (start < end && (c = ch[start]) == ' ') {
            startWhitespace = true;
            ++start;
            --length;
        }
        while (length > 0 && (c = ch[start + length - 1]) == ' ') {
            endWhitespace = true;
            --length;
        }
        if (length == 0) {
            if (startWhitespace || endWhitespace) {
                if (!this.sbLastWasWhitespace) {
                    this.textBuffer.append(' ');
                    this.tokenBuffer.append(' ');
                }
                this.sbLastWasWhitespace = true;
            } else {
                this.sbLastWasWhitespace = false;
            }
            this.lastEvent = Event.WHITESPACE;
            return;
        }
        if (startWhitespace && !this.sbLastWasWhitespace) {
            this.textBuffer.append(' ');
            this.tokenBuffer.append(' ');
        }
        if (this.blockTagLevel == -1) {
            this.blockTagLevel = this.tagLevel;
        }
        this.textBuffer.append(ch, start, length);
        this.tokenBuffer.append(ch, start, length);
        if (endWhitespace) {
            this.textBuffer.append(' ');
            this.tokenBuffer.append(' ');
        }
        this.sbLastWasWhitespace = endWhitespace;
        this.lastEvent = Event.CHARACTERS;
        this.currentContainedTextElements.set(this.textElementIdx);
    }

    List<TextBlock> getTextBlocks() {
        return this.textBlocks;
    }

    public void flushBlock() {
        int numWordsInWrappedLines;
        if (this.inBody == 0) {
            if ("TITLE".equalsIgnoreCase(this.lastStartTag) && this.inBody == 0) {
                this.setTitle(this.tokenBuffer.toString().trim());
            }
            this.textBuffer.setLength(0);
            this.tokenBuffer.setLength(0);
            return;
        }
        int length = this.tokenBuffer.length();
        switch (length) {
            case 0: {
                return;
            }
            case 1: {
                if (!this.sbLastWasWhitespace) break;
                this.textBuffer.setLength(0);
                this.tokenBuffer.setLength(0);
                return;
            }
        }
        String[] tokens = UnicodeTokenizer.tokenize(this.tokenBuffer);
        int numWords = 0;
        int numLinkedWords = 0;
        int numWrappedLines = 0;
        int currentLineLength = -1;
        int maxLineLength = 80;
        int numTokens = 0;
        int numWordsCurrentLine = 0;
        for (String token : tokens) {
            if (ANCHOR_TEXT_START.equals(token)) {
                this.inAnchorText = true;
                continue;
            }
            if (ANCHOR_TEXT_END.equals(token)) {
                this.inAnchorText = false;
                continue;
            }
            if (BoilerpipeHTMLContentHandler.isWord(token)) {
                int tokenLength;
                ++numTokens;
                ++numWords;
                ++numWordsCurrentLine;
                if (this.inAnchorText) {
                    ++numLinkedWords;
                }
                if ((currentLineLength += (tokenLength = token.length()) + 1) <= 80) continue;
                ++numWrappedLines;
                currentLineLength = tokenLength;
                numWordsCurrentLine = 1;
                continue;
            }
            ++numTokens;
        }
        if (numTokens == 0) {
            return;
        }
        if (numWrappedLines == 0) {
            numWordsInWrappedLines = numWords;
            numWrappedLines = 1;
        } else {
            numWordsInWrappedLines = numWords - numWordsCurrentLine;
        }
        TextBlock tb = new TextBlock(this.textBuffer.toString().trim(), this.currentContainedTextElements, numWords, numLinkedWords, numWordsInWrappedLines, numWrappedLines, this.offsetBlocks);
        this.currentContainedTextElements = new BitSet();
        ++this.offsetBlocks;
        this.textBuffer.setLength(0);
        this.tokenBuffer.setLength(0);
        tb.setTagLevel(this.blockTagLevel);
        this.addTextBlock(tb);
        this.blockTagLevel = -1;
    }

    protected void addTextBlock(TextBlock tb) {
        for (Integer n : this.fontSizeStack) {
            if (n == null) continue;
            tb.addLabel("font-" + n);
            break;
        }
        for (LinkedList linkedList : this.labelStacks) {
            if (linkedList == null) continue;
            for (LabelAction labels : linkedList) {
                if (labels == null) continue;
                labels.addTo(tb);
            }
        }
        this.textBlocks.add(tb);
    }

    private static boolean isWord(String token) {
        return PAT_VALID_WORD_CHARACTER.matcher(token).find();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        this.title = s;
    }

    public TextDocument toTextDocument() {
        this.flushBlock();
        return new TextDocument(this.getTitle(), this.getTextBlocks());
    }

    public void addWhitespaceIfNecessary() {
        if (!this.sbLastWasWhitespace) {
            this.tokenBuffer.append(' ');
            this.textBuffer.append(' ');
            this.sbLastWasWhitespace = true;
        }
    }

    public void addLabelAction(LabelAction la) throws IllegalStateException {
        LinkedList<LabelAction> labelStack = this.labelStacks.getLast();
        if (labelStack == null) {
            labelStack = new LinkedList();
            this.labelStacks.removeLast();
            this.labelStacks.add(labelStack);
        }
        labelStack.add(la);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Event {
        START_TAG,
        END_TAG,
        CHARACTERS,
        WHITESPACE;

    }
}

