## ----setup, include = FALSE---------------------------------------------------
library(clinical)  

## ----load-data, message=FALSE, warning=FALSE----------------------------------
data(prostate)
head(prostate)

## -----------------------------------------------------------------------------
# Summarize Age using mean and IQR
txtsummary(prostate$Age, f = "mean", digits = 2, range = "IQR")

## -----------------------------------------------------------------------------

# Non-parametric comparison using Wilcoxon test
result_wilcox <- continuous.test(
  name = "Age",
  x = prostate$Age,
  y = prostate$Hospital,
  center = "median",
  range = "IQR",
  method = "non-parametric"
)

print(result_wilcox)

## -----------------------------------------------------------------------------
# Non-parametric comparison using Wilcoxon test
result_wilcox <- continuous.test(
  name = "Age",
  x = prostate$Age,
  y = prostate$Hospital,
  center = "median",
  range = "IQR",
  method = "non-parametric"
)

print(result_wilcox)

## -----------------------------------------------------------------------------
# Compare Gender (unordered factor) across hospitals
categorical_test_result <- categorical.test(
  name = "Gender",
  x = prostate$Gender,
  y = prostate$Hospital
)

print(categorical_test_result)

## -----------------------------------------------------------------------------
# Compare Gleason score (ordered factor) across hospitals
categorical_test_result <- categorical.test(
  name = "Gleason",
  x = prostate$Gleason,
  y = prostate$Hospital
)

print(categorical_test_result)

## -----------------------------------------------------------------------------
correlation_result <- correlation.test(prostate$Age, prostate$BMI, method = "spearman", name = "Age vs BMI")
print(correlation_result)

## -----------------------------------------------------------------------------
multi_cont <- multi_analysis(prostate[, c("Age", "BMI")], prostate$Hospital, FUN = "continuous.test")
print(multi_cont)

## -----------------------------------------------------------------------------
multi_corr <- multi_analysis(prostate[, c("Age", "BMI")], prostate$BMI, FUN = "correlation.test")
print(multi_corr)

## -----------------------------------------------------------------------------
v1 <- c("A", "B", "C")
v2 <- c("B", "C", "D")
v3 <- c("C", "B", "E")

intersect(v1, v2, v3)

## -----------------------------------------------------------------------------
hosp=prostate[,"Hospital"]
gender=prostate[,"Gender"]
GS=prostate[,"Gleason score"]
BMI=prostate[,"BMI"]
age=prostate[,"Age"]

A=categorical.test("Gender",gender,hosp)
B=categorical.test("Gleason score",GS,hosp)

C=continuous.test("BMI",BMI,hosp,digits=2)
D=continuous.test("Age",age,hosp,digits=1)

# Analysis without matching
rbind(A,B,C,D)



# The order is important. Right is more important than left in the vector
# So, Ethnicity will be more important than Age
var=c("Age","BMI","Gleason score")
data.categorized=prostate[,var]

# Extract the Age vector
x <- data.categorized[["Age"]]

# Compute quantiles (0%, 25%, 50%, 75%, 100%) with NA handling
breaks <- quantile(x, probs = c(0, 0.25, 0.5, 0.75, 1), na.rm = TRUE)

# Apply the cut and update the Age column with labeled bins
data.categorized[["Age"]] <- cut(x, breaks = breaks, include.lowest = TRUE)

# Extract the Age vector
x <- data.categorized[["BMI"]]

# Compute quantiles (0%, 25%, 50%, 75%, 100%) with NA handling
breaks <- quantile(x, probs = c(0, 0.25, 0.5, 0.75, 1), na.rm = TRUE)

# Apply the cut and update the Age column with labeled bins
data.categorized[["BMI"]] <- cut(x, breaks = breaks, include.lowest = TRUE)

times=c(1,1)
names(times)=c("Hospital A","Hospital B")
t=frequency_matching(data.categorized,prostate[,"Hospital"],times=times)



newdata=prostate[t$selection,]

hosp.new=newdata[,"Hospital"]
gender.new=newdata[,"Gender"]
GS.new=newdata[,"Gleason score"]
BMI.new=newdata[,"BMI"]
age.new=newdata[,"Age"]

A=categorical.test("Gender",gender.new,hosp.new)
B=categorical.test("Gleason score",GS.new,hosp.new)

C=continuous.test("BMI",BMI.new,hosp.new,digits=2)
D=continuous.test("Age",age.new,hosp.new,digits=1)

# Analysis with matching
rbind(A,B,C,D)

