/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.io.BinaryGISModelWriter;
import opennlp.maxent.io.BinaryQNModelWriter;
import opennlp.maxent.io.PlainTextGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelWriter;
import opennlp.perceptron.BinaryPerceptronModelWriter;
import opennlp.perceptron.PlainTextPerceptronModelWriter;

public class GenericModelWriter
extends AbstractModelWriter {
    private AbstractModelWriter delegateWriter;

    public GenericModelWriter(AbstractModel model, File file) throws IOException {
        OutputStream os;
        String filename = file.getName();
        if (filename.endsWith(".gz")) {
            os = new GZIPOutputStream(new FileOutputStream(file));
            filename = filename.substring(0, filename.length() - 3);
        } else {
            os = new FileOutputStream(file);
        }
        if (filename.endsWith(".bin")) {
            this.init(model, new DataOutputStream(os));
        } else {
            this.init(model, new BufferedWriter(new OutputStreamWriter(os)));
        }
    }

    public GenericModelWriter(AbstractModel model, DataOutputStream dos) {
        this.init(model, dos);
    }

    private void init(AbstractModel model, DataOutputStream dos) {
        if (model.getModelType() == AbstractModel.ModelType.Perceptron) {
            this.delegateWriter = new BinaryPerceptronModelWriter(model, dos);
        } else if (model.getModelType() == AbstractModel.ModelType.Maxent) {
            this.delegateWriter = new BinaryGISModelWriter(model, dos);
        } else if (model.getModelType() == AbstractModel.ModelType.MaxentQn) {
            this.delegateWriter = new BinaryQNModelWriter(model, dos);
        }
    }

    private void init(AbstractModel model, BufferedWriter bw) {
        if (model.getModelType() == AbstractModel.ModelType.Perceptron) {
            this.delegateWriter = new PlainTextPerceptronModelWriter(model, bw);
        } else if (model.getModelType() == AbstractModel.ModelType.Maxent) {
            this.delegateWriter = new PlainTextGISModelWriter(model, bw);
        }
    }

    public void close() throws IOException {
        this.delegateWriter.close();
    }

    public void persist() throws IOException {
        this.delegateWriter.persist();
    }

    public void writeDouble(double d) throws IOException {
        this.delegateWriter.writeDouble(d);
    }

    public void writeInt(int i) throws IOException {
        this.delegateWriter.writeInt(i);
    }

    public void writeUTF(String s) throws IOException {
        this.delegateWriter.writeUTF(s);
    }
}

