/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import org.openscience.cdk.hash.stereo.PermutationParity;

final class BasicPermutationParity
extends PermutationParity {
    private final int[] indices;

    public BasicPermutationParity(int[] indices) {
        if (indices == null) {
            throw new NullPointerException("no indices[] provided");
        }
        if (indices.length < 2) {
            throw new IllegalArgumentException("at least 2 incides required,use PermutationParity.IDENTITY for single neighbors");
        }
        this.indices = indices;
    }

    @Override
    public int parity(long[] current) {
        int count = 0;
        int n = this.indices.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int cmp = BasicPermutationParity.compare(current[this.indices[i]], current[this.indices[j]]);
                if (cmp == 0) {
                    return 0;
                }
                if (cmp <= 0) continue;
                ++count;
            }
        }
        return Integer.lowestOneBit(count) == 1 ? -1 : 1;
    }

    private static int compare(long a, long b) {
        return a > b ? 1 : (a < b ? -1 : 0);
    }
}

