/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Explained
public class PropMaxBC
extends Propagator<IntVar> {
    private final IntVar BST;
    private final IntVar v1;
    private final IntVar v2;

    public PropMaxBC(IntVar X, IntVar Y, IntVar Z) {
        super((Variable[])new IntVar[]{X, Y, Z}, (Priority)PropagatorPriority.TERNARY, false);
        this.BST = ((IntVar[])this.vars)[0];
        this.v1 = ((IntVar[])this.vars)[1];
        this.v2 = ((IntVar[])this.vars)[2];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int bst;
        boolean change;
        do {
            change = ((IntVar[])this.vars)[0].updateLowerBound(Math.max(((IntVar[])this.vars)[1].getLB(), ((IntVar[])this.vars)[2].getLB()), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[1].getMinLit(), ((IntVar[])this.vars)[2].getMinLit()) : Reason.undef());
            change |= ((IntVar[])this.vars)[0].updateUpperBound(Math.max(((IntVar[])this.vars)[1].getUB(), ((IntVar[])this.vars)[2].getUB()), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[1].getMaxLit(), ((IntVar[])this.vars)[2].getMaxLit()) : Reason.undef());
            change |= ((IntVar[])this.vars)[1].updateUpperBound(((IntVar[])this.vars)[0].getUB(), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[0].getMaxLit()) : Reason.undef());
            change |= ((IntVar[])this.vars)[2].updateUpperBound(((IntVar[])this.vars)[0].getUB(), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[0].getMaxLit()) : Reason.undef());
            if (((IntVar[])this.vars)[2].getUB() < ((IntVar[])this.vars)[0].getLB()) {
                change |= ((IntVar[])this.vars)[1].updateLowerBound(((IntVar[])this.vars)[0].getLB(), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[0].getMinLit(), ((IntVar[])this.vars)[2].getMaxLit()) : Reason.undef());
            }
            if (((IntVar[])this.vars)[1].getUB() >= ((IntVar[])this.vars)[0].getLB()) continue;
            change |= ((IntVar[])this.vars)[2].updateLowerBound(((IntVar[])this.vars)[0].getLB(), this, this.lcg() ? Reason.r(((IntVar[])this.vars)[0].getMinLit(), ((IntVar[])this.vars)[1].getMaxLit()) : Reason.undef());
        } while (change);
        if (((IntVar[])this.vars)[0].isInstantiated() && (((IntVar[])this.vars)[1].isInstantiatedTo(bst = ((IntVar[])this.vars)[0].getValue()) || ((IntVar[])this.vars)[2].isInstantiatedTo(bst))) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        int ub = ((IntVar[])this.vars)[0].getUB();
        if (((IntVar[])this.vars)[1].getLB() > ub || ((IntVar[])this.vars)[2].getLB() > ub) {
            return ESat.FALSE;
        }
        if (Math.max(((IntVar[])this.vars)[1].getUB(), ((IntVar[])this.vars)[2].getUB()) < ((IntVar[])this.vars)[0].getLB()) {
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[1].getUB() > ub || ((IntVar[])this.vars)[2].getUB() > ub) {
            return ESat.UNDEFINED;
        }
        if (((IntVar[])this.vars)[0].isInstantiated() && (((IntVar[])this.vars)[1].isInstantiatedTo(ub) || ((IntVar[])this.vars)[2].isInstantiatedTo(ub))) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.BST.toString() + ".MAX(" + this.v1.toString() + "," + this.v2.toString() + ")";
    }
}

