/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.real;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.real.Ibex;
import org.chocosolver.solver.constraints.real.RealPropagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.VariableUtils;

public class IbexHandler {
    private static final Pattern p1 = Pattern.compile("\\{_");
    private Ibex ibex;
    private final TObjectIntHashMap<RealPropagator> ibexCtr = new TObjectIntHashMap(16, 0.5f, -1);
    private final TObjectIntHashMap<Variable> ibexVar = new TObjectIntHashMap(16, 0.5f, -1);
    private final List<Variable> vars = new ArrayList<Variable>();
    private final TDoubleList precisions = new TDoubleArrayList();
    private double[] domains;
    private boolean hasChanged = false;
    private byte startSolve = 0;
    private double contractionRatio = 0.01;
    private boolean preserveRounding = false;

    private static synchronized void build(Ibex ibex) {
        if (!ibex.build()) {
            throw new SolverException("Malformed Ibex function");
        }
    }

    public void declare(RealPropagator prop) {
        this.ibexCtr.put(prop, -1);
        this.hasChanged = true;
    }

    public void remove(RealPropagator prop) {
        this.ibexCtr.remove(prop);
        this.hasChanged = true;
    }

    void contract(RealPropagator prop) throws ContradictionException {
        boolean filter;
        Ibex mIbex = this.getIbexInstance();
        block6: do {
            filter = false;
            this.extractDomains();
            int reif = this.getReif(prop);
            int result = this.contractionRatio == 0.01 ? mIbex.contract(this.ibexCtr.get(prop), this.domains, reif) : mIbex.contract(this.ibexCtr.get(prop), this.domains, reif, this.contractionRatio);
            switch (result) {
                case 0: {
                    if (reif == 2) {
                        prop.reified.setToFalse(prop);
                        filter = true;
                        break;
                    }
                    if (reif != 1) continue block6;
                    prop.fails();
                    break;
                }
                case 2: {
                    assert (reif != 2);
                    this.injectDomains(prop);
                    filter = true;
                    break;
                }
                case 1: {
                    if (reif == 2) {
                        prop.reified.setToTrue(prop);
                        filter = true;
                        break;
                    }
                    if (reif == 0) {
                        prop.fails();
                        break;
                    }
                    this.injectDomains(prop);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new SolverException("Bad return " + result);
                }
            }
        } while (filter);
    }

    private void start_solve() {
        this.startSolve = 0;
        Ibex mIbex = this.getIbexInstance();
        this.extractDomains();
        int result = mIbex.start_solve(this.domains);
        switch (result) {
            case 0: {
                break;
            }
            case -3: 
            case -2: 
            case 1: {
                throw new IllegalStateException("Ibex cannot initialize the solving, error #" + result + " is thrown");
            }
        }
    }

    public boolean nextSolution(boolean reinit) {
        if (this.startSolve == 0 || this.startSolve == 2 && reinit) {
            this.start_solve();
            this.startSolve = 1;
        }
        if (this.startSolve == 1) {
            Ibex mIbex = this.getIbexInstance();
            int result = mIbex.next_solution(this.domains);
            switch (result) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: {
                    this.startSolve = (byte)2;
                    return false;
                }
                case -2: 
                case 3: {
                    throw new IllegalStateException("Ibex cannot terminate the solving, error #" + result + " is thrown");
                }
            }
        }
        return false;
    }

    public void injectDomain() throws ContradictionException {
        this.injectDomains(Cause.Null);
    }

    public double getContractionRatio() {
        return this.contractionRatio;
    }

    public void setContractionRatio(double ratio) {
        this.contractionRatio = ratio;
    }

    public boolean isPreserveRounding() {
        return this.preserveRounding;
    }

    public void setPreserveRounding(boolean preserveRounding) {
        this.preserveRounding = preserveRounding;
    }

    private Ibex getIbexInstance() {
        if (this.hasChanged && this.ibex != null) {
            this.ibex.release();
            this.ibex = null;
        }
        if (this.ibex == null) {
            this.createInstance();
        }
        return this.ibex;
    }

    private void extractDomains() {
        for (int i = 0; i < this.vars.size(); ++i) {
            if (VariableUtils.isReal(this.vars.get(i))) {
                RealVar rvar = (RealVar)this.vars.get(i);
                this.domains[2 * i] = rvar.getLB();
                this.domains[2 * i + 1] = rvar.getUB();
                continue;
            }
            IntVar ivar = (IntVar)this.vars.get(i);
            this.domains[2 * i] = ivar.getLB();
            this.domains[2 * i + 1] = ivar.getUB();
        }
    }

    private void injectDomains(ICause cause) throws ContradictionException {
        for (int i = 0; i < this.vars.size(); ++i) {
            if (VariableUtils.isReal(this.vars.get(i))) {
                RealVar rvar = (RealVar)this.vars.get(i);
                rvar.updateBounds(this.domains[2 * i], this.domains[2 * i + 1], cause);
                continue;
            }
            IntVar ivar = (IntVar)this.vars.get(i);
            ivar.updateBounds((int)Math.ceil(this.domains[2 * i]), (int)Math.floor(this.domains[2 * i + 1]), cause);
        }
    }

    private int getReif(RealPropagator prop) {
        if (prop.reified == null) {
            return 1;
        }
        if (prop.reified.isInstantiated()) {
            return prop.reified.isInstantiatedTo(1) ? 1 : 0;
        }
        return 2;
    }

    private synchronized void createInstance() {
        RealPropagator[] props = (RealPropagator[])this.ibexCtr.keySet().stream().sorted(Comparator.comparingInt(Propagator::getId)).toArray(RealPropagator[]::new);
        this.vars.clear();
        this.precisions.clear();
        this.ibexVar.clear();
        for (int i = 0; i < props.length; ++i) {
            for (int j = 0; j < props[i].getNbVars() - (props[i].reified != null ? 1 : 0); ++j) {
                Object var = props[i].getVar(j);
                if (this.ibexVar.contains(var)) continue;
                this.ibexVar.put((Variable)var, this.vars.size());
                this.vars.add((Variable)var);
                this.precisions.add(VariableUtils.isReal(var) ? ((RealVar)var).getPrecision() : -1.0);
            }
        }
        this.ibex = !this.preserveRounding ? new Ibex(this.precisions.toArray()) : new Ibex(this.precisions.toArray(), this.preserveRounding);
        int k = 0;
        for (int i = 0; i < props.length; ++i) {
            String fct = props[i].functions;
            for (int j = 0; j < props[i].getNbVars() - (props[i].reified != null ? 1 : 0); ++j) {
                fct = fct.replaceAll("\\{" + j + "\\}", "{_" + this.ibexVar.get(props[i].getVar(j)) + "}");
            }
            this.ibexCtr.put(props[i], k++);
            this.ibex.add_ctr(p1.matcher(fct).replaceAll("{"));
        }
        this.domains = new double[this.vars.size() * 2];
        this.hasChanged = false;
        IbexHandler.build(this.ibex);
    }

    protected void finalize() throws Throwable {
        if (this.ibex != null) {
            this.ibex.release();
        }
        super.finalize();
    }
}

