## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(weaana)

## ----read-weather-file--------------------------------------------------------
file <- system.file("extdata/WeatherRecordsDemo1.met", package = "weaana")
# Read weather file
met <- readWeatherRecords(file)
# Get records in data.frame
records <- getWeatherRecords(met)
# Calculate month from weather records
month <- as.numeric(format(records$date, '%m'))
   

## ----month-changes------------------------------------------------------------
set.seed(1)
# maximum and minimum temperature changes are absolute values
tasmax <- (runif(12) - 0.5) * 2
tasmin <- (runif(12) - 0.5) * 2
# rain changes are a ratio
pr <- (runif(12) - 0.5) / 10

## ----modify-weather-file------------------------------------------------------
new_maxt <- records$maxt + tasmax[month]
new_mint <- records$mint + tasmin[month]
new_rain <- records$rain * pr[month]
changeWeatherRecords(met, maxt = new_maxt)
changeWeatherRecords(met, mint = new_mint)
changeWeatherRecords(met, rain = new_rain)

## ----save-file, eval=FALSE----------------------------------------------------
# writeWeatherRecords(met, "new-file.met")

