/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check;

import java.util.ArrayList;
import java.util.List;
import org.ohdsi.circe.check.Check;
import org.ohdsi.circe.check.Warning;
import org.ohdsi.circe.check.checkers.AttributeCheck;
import org.ohdsi.circe.check.checkers.ConceptCheck;
import org.ohdsi.circe.check.checkers.ConceptSetCriteriaCheck;
import org.ohdsi.circe.check.checkers.ConceptSetSelectionCheck;
import org.ohdsi.circe.check.checkers.CriteriaContradictionsCheck;
import org.ohdsi.circe.check.checkers.DeathTimeWindowCheck;
import org.ohdsi.circe.check.checkers.DomainTypeCheck;
import org.ohdsi.circe.check.checkers.DrugDomainCheck;
import org.ohdsi.circe.check.checkers.DrugEraCheck;
import org.ohdsi.circe.check.checkers.DuplicatesConceptSetCheck;
import org.ohdsi.circe.check.checkers.DuplicatesCriteriaCheck;
import org.ohdsi.circe.check.checkers.EmptyConceptSetCheck;
import org.ohdsi.circe.check.checkers.EventsProgressionCheck;
import org.ohdsi.circe.check.checkers.ExitCriteriaCheck;
import org.ohdsi.circe.check.checkers.ExitCriteriaDaysOffsetCheck;
import org.ohdsi.circe.check.checkers.IncompleteRuleCheck;
import org.ohdsi.circe.check.checkers.InitialEventCheck;
import org.ohdsi.circe.check.checkers.NoExitCriteriaCheck;
import org.ohdsi.circe.check.checkers.OcurrenceCheck;
import org.ohdsi.circe.check.checkers.RangeCheck;
import org.ohdsi.circe.check.checkers.TextCheck;
import org.ohdsi.circe.check.checkers.TimePatternCheck;
import org.ohdsi.circe.check.checkers.TimeWindowCheck;
import org.ohdsi.circe.check.checkers.UnusedConceptsCheck;
import org.ohdsi.circe.cohortdefinition.CohortExpression;

public class Checker
implements Check {
    private List<Check> getChecks() {
        ArrayList<Check> checks = new ArrayList<Check>();
        checks.add(new UnusedConceptsCheck());
        checks.add(new ExitCriteriaCheck());
        checks.add(new ExitCriteriaDaysOffsetCheck());
        checks.add(new RangeCheck());
        checks.add(new ConceptCheck());
        checks.add(new ConceptSetSelectionCheck());
        checks.add(new AttributeCheck());
        checks.add(new TextCheck());
        checks.add(new IncompleteRuleCheck());
        checks.add(new InitialEventCheck());
        checks.add(new NoExitCriteriaCheck());
        checks.add(new ConceptSetCriteriaCheck());
        checks.add(new DrugEraCheck());
        checks.add(new OcurrenceCheck());
        checks.add(new DuplicatesCriteriaCheck());
        checks.add(new DuplicatesConceptSetCheck());
        checks.add(new DrugDomainCheck());
        checks.add(new EmptyConceptSetCheck());
        checks.add(new EventsProgressionCheck());
        checks.add(new TimeWindowCheck());
        checks.add(new TimePatternCheck());
        checks.add(new DomainTypeCheck());
        checks.add(new CriteriaContradictionsCheck());
        checks.add(new DeathTimeWindowCheck());
        return checks;
    }

    @Override
    public List<Warning> check(CohortExpression expression) {
        ArrayList<Warning> result = new ArrayList<Warning>();
        for (Check check : this.getChecks()) {
            result.addAll(check.check(expression));
        }
        return result;
    }
}

