/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.SparseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import java.util.Random;

public class TestSparseDoubleLUDecomposition {
    public static void main(String[] stringArray) {
        int n;
        int n2 = 180;
        Random random = new Random(0L);
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = new SparseRCDoubleMatrix2D(n2, n2);
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D2 = new SparseRCDoubleMatrix2D(n2, n2);
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(n2);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(n2);
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                ((DoubleMatrix2D)sparseRCDoubleMatrix2D).setQuick(n, i, 0.5 - random.nextDouble());
                ((DoubleMatrix2D)sparseRCDoubleMatrix2D2).setQuick(n, i, ((DoubleMatrix2D)sparseRCDoubleMatrix2D).getQuick(n, i));
            }
        }
        for (n = 0; n < n2; ++n) {
            ((DoubleMatrix1D)denseDoubleMatrix1D).setQuick(n, 0.5 - random.nextDouble());
            ((DoubleMatrix1D)denseDoubleMatrix1D2).setQuick(n, ((DoubleMatrix1D)denseDoubleMatrix1D).getQuick(n));
        }
        TestSparseDoubleLUDecomposition.testLU(sparseRCDoubleMatrix2D, sparseRCDoubleMatrix2D2, denseDoubleMatrix1D, denseDoubleMatrix1D2);
    }

    private static void testLU(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        double d = 1.0E-10;
        SparseDoubleLUDecomposition sparseDoubleLUDecomposition = new SparseDoubleLUDecomposition(doubleMatrix2D2, 0, true);
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D2.copy();
        sparseDoubleLUDecomposition.solve(doubleMatrix1D3);
        System.out.print("\n");
        System.out.print("------ SparseDoubleLUFactorization tests-------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n, n2));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int n3 = TestSparseDoubleLUDecomposition.checkSolution(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D3, d);
        if (n3 == 0) {
            System.out.print("***************************************************\n");
            System.out.print(" ---- SparseDoubleLUFactorization tests... PASSED !\n");
            System.out.print("***************************************************\n");
        } else {
            System.out.print("***************************************************\n");
            System.out.print(" ---- SparseDoubleLUFactorization tests... FAILED !\n");
            System.out.print("***************************************************\n");
        }
    }

    private static int checkSolution(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d) {
        int n;
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D2);
        int n2 = doubleMatrix2D.rows();
        double d2 = 1.0;
        double d3 = -1.0;
        double d4 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix1D2);
        double d5 = SparseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D);
        double d6 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix1D);
        doubleMatrix2D.zMult(doubleMatrix1D2, doubleMatrix1D, d2, d3, false);
        double d7 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix1D);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps) = %e \n", d7 / ((d5 * d4 + d6) * (double)n2 * d)));
        if (d7 / ((d5 * d4 + d6) * (double)n2 * d) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            n = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            n = 0;
        }
        return n;
    }
}

