/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Sorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.algo.IntMatrix1DComparator;
import cern.colt.matrix.tint.algo.IntMatrix2DComparator;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;

public class IntSorting
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final IntSorting quickSort = new IntSorting();
    public static final IntSorting mergeSort = new IntSorting(){
        private static final long serialVersionUID = 1L;

        protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
            Sorting.mergeSort(nArray, n, n2, intComparator);
        }

        protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
            GenericSorting.mergeSort(n, n2, intComparator, swapper);
        }
    };

    protected IntSorting() {
    }

    protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
        Sorting.parallelQuickSort(nArray, n, n2, intComparator);
    }

    protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
        GenericSorting.quickSort(n, n2, intComparator, swapper);
    }

    public IntMatrix1D sort(IntMatrix1D intMatrix1D) {
        return intMatrix1D.viewSelection(this.sortIndex(intMatrix1D));
    }

    public int[] sortIndex(final IntMatrix1D intMatrix1D) {
        int[] nArray = new int[(int)intMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        IntComparator intComparator = null;
        if (intMatrix1D instanceof DenseIntMatrix1D) {
            final int[] nArray2 = (int[])intMatrix1D.elements();
            final int n2 = (int)intMatrix1D.index(0);
            final int n3 = intMatrix1D.stride();
            intComparator = new IntComparator(){

                public int compare(int n, int n22) {
                    int n32 = n2 + n * n3;
                    int n4 = nArray2[n32];
                    int n5 = n2 + n22 * n3;
                    int n6 = nArray2[n5];
                    return n4 < n6 ? -1 : (n4 == n6 ? 0 : 1);
                }
            };
        } else {
            intComparator = new IntComparator(){

                public int compare(int n, int n2) {
                    int n3;
                    int n4 = intMatrix1D.getQuick(n);
                    return n4 < (n3 = intMatrix1D.getQuick(n2)) ? -1 : (n4 == n3 ? 0 : 1);
                }
            };
        }
        this.runSort(nArray, 0, nArray.length, intComparator);
        return nArray;
    }

    public IntMatrix1D sort(IntMatrix1D intMatrix1D, IntComparator intComparator) {
        return intMatrix1D.viewSelection(this.sortIndex(intMatrix1D, intComparator));
    }

    public int[] sortIndex(final IntMatrix1D intMatrix1D, final IntComparator intComparator) {
        int[] nArray = new int[(int)intMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        IntComparator intComparator2 = null;
        if (intMatrix1D instanceof DenseIntMatrix1D) {
            final int[] nArray2 = (int[])intMatrix1D.elements();
            final int n2 = (int)intMatrix1D.index(0);
            final int n3 = intMatrix1D.stride();
            intComparator2 = new IntComparator(){

                public int compare(int n, int n22) {
                    int n32 = n2 + n * n3;
                    int n4 = n2 + n22 * n3;
                    return intComparator.compare(nArray2[n32], nArray2[n4]);
                }
            };
        } else {
            intComparator2 = new IntComparator(){

                public int compare(int n, int n2) {
                    return intComparator.compare(intMatrix1D.getQuick(n), intMatrix1D.getQuick(n2));
                }
            };
        }
        this.runSort(nArray, 0, nArray.length, intComparator2);
        return nArray;
    }

    public IntMatrix2D sort(IntMatrix2D intMatrix2D, final int[] nArray) {
        int n = intMatrix2D.rows();
        if (nArray.length != n) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] nArray2 = new int[n];
        int n2 = n;
        while (--n2 >= 0) {
            nArray2[n2] = n2;
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                int n3 = nArray[n];
                int n4 = nArray[n2];
                return n3 < n4 ? -1 : (n3 == n4 ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray2[n];
                nArray2[n] = nArray2[n2];
                nArray2[n2] = n3;
                int n4 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n4;
            }
        };
        this.runSort(0, n, intComparator, swapper);
        return intMatrix2D.viewSelection(nArray2, null);
    }

    public IntMatrix2D sort(IntMatrix2D intMatrix2D, int n) {
        if (n < 0 || n >= intMatrix2D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n + ", matrix=" + AbstractFormatter.shape(intMatrix2D));
        }
        int[] nArray = new int[intMatrix2D.rows()];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray[n2] = n2;
        }
        final IntMatrix1D intMatrix1D = intMatrix2D.viewColumn(n);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                int n3;
                int n4 = intMatrix1D.getQuick(n);
                return n4 < (n3 = intMatrix1D.getQuick(n2)) ? -1 : (n4 == n3 ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return intMatrix2D.viewSelection(nArray, null);
    }

    public IntMatrix2D sort(IntMatrix2D intMatrix2D, final IntMatrix1DComparator intMatrix1DComparator) {
        int[] nArray = new int[intMatrix2D.rows()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final IntMatrix1D[] intMatrix1DArray = new IntMatrix1D[intMatrix2D.rows()];
        int n2 = intMatrix1DArray.length;
        while (--n2 >= 0) {
            intMatrix1DArray[n2] = intMatrix2D.viewRow(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return intMatrix1DComparator.compare(intMatrix1DArray[n], intMatrix1DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return intMatrix2D.viewSelection(nArray, null);
    }

    public IntMatrix3D sort(IntMatrix3D intMatrix3D, int n, int n2) {
        if (n < 0 || n >= intMatrix3D.rows()) {
            throw new IndexOutOfBoundsException("row=" + n + ", matrix=" + AbstractFormatter.shape(intMatrix3D));
        }
        if (n2 < 0 || n2 >= intMatrix3D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n2 + ", matrix=" + AbstractFormatter.shape(intMatrix3D));
        }
        int[] nArray = new int[intMatrix3D.slices()];
        int n3 = nArray.length;
        while (--n3 >= 0) {
            nArray[n3] = n3;
        }
        final IntMatrix1D intMatrix1D = intMatrix3D.viewRow(n).viewColumn(n2);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                int n3;
                int n4 = intMatrix1D.getQuick(n);
                return n4 < (n3 = intMatrix1D.getQuick(n2)) ? -1 : (n4 == n3 ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return intMatrix3D.viewSelection(nArray, null, null);
    }

    public IntMatrix3D sort(IntMatrix3D intMatrix3D, final IntMatrix2DComparator intMatrix2DComparator) {
        int[] nArray = new int[intMatrix3D.slices()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final IntMatrix2D[] intMatrix2DArray = new IntMatrix2D[intMatrix3D.slices()];
        int n2 = intMatrix2DArray.length;
        while (--n2 >= 0) {
            intMatrix2DArray[n2] = intMatrix3D.viewSlice(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return intMatrix2DComparator.compare(intMatrix2DArray[n], intMatrix2DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return intMatrix3D.viewSelection(nArray, null, null);
    }
}

