/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class InverseGaussianDist
extends ContinuousDistribution {
    protected double mu;
    protected double lambda;

    public InverseGaussianDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return InverseGaussianDist.density(this.mu, this.lambda, d);
    }

    public double cdf(double d) {
        return InverseGaussianDist.cdf(this.mu, this.lambda, d);
    }

    public double barF(double d) {
        return InverseGaussianDist.barF(this.mu, this.lambda, d);
    }

    public double getMean() {
        return InverseGaussianDist.getMean(this.mu, this.lambda);
    }

    public double getVariance() {
        return InverseGaussianDist.getVariance(this.mu, this.lambda);
    }

    public double getStandardDeviation() {
        return InverseGaussianDist.getStandardDeviation(this.mu, this.lambda);
    }

    public static double density(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d4 = Math.sqrt(d3);
        return Math.sqrt(d2 / (Math.PI * 2)) / (d4 * d4 * d4) * Math.exp(-d2 * (d3 - 2.0 * d + d * d / d3) / (2.0 * d * d));
    }

    public static double cdf(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d4 = Math.sqrt(d2 / d3);
        double d5 = d4 * (d3 / d - 1.0);
        double d6 = d4 * (d3 / d + 1.0);
        return NormalDist.cdf01(d5) + Math.exp(2.0 * d2 / d) * NormalDist.cdf01(-d6);
    }

    public static double barF(double d, double d2, double d3) {
        return 1.0 - InverseGaussianDist.cdf(d, d2, d3);
    }

    public static double inverseF(double d, double d2, double d3) {
        throw new UnsupportedOperationException("Inversion of the inverse gaussian distribution");
    }

    public static double[] getMLE(double[] dArray, int n) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray2 = new double[2];
        double d = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            d += dArray[n2];
        }
        dArray2[0] = d / (double)n;
        d = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            d += 1.0 / dArray[n2] - 1.0 / dArray2[0];
        }
        dArray2[1] = (double)n / d;
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return InverseGaussianDist.getMLE(dArray, n);
    }

    public static InverseGaussianDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = InverseGaussianDist.getMaximumLikelihoodEstimate(dArray, n);
        return new InverseGaussianDist(dArray2[0], dArray2[1]);
    }

    public static double getMean(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d;
    }

    public static double getVariance(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d * d * d / d2;
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(InverseGaussianDist.getVariance(d, d2));
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getMu() {
        return this.mu;
    }

    public void setParams(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.mu = d;
        this.lambda = d2;
        this.supportA = 0.0;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.mu, this.lambda};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : mu = " + this.mu + ", lambda = " + this.lambda;
    }
}

