/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.impl.IRIExamples;
import com.hp.hpl.jena.iri.impl.Specification;

public class ViolationCodeInfo
extends IRIExamples {
    private final int force;
    private final String name;
    private final int code;
    private final String description;
    private final String descriptionHtml;
    private final boolean unimplemented;
    private final InSpec[] specifications;
    public static final ViolationCodeInfo[] all = new ViolationCodeInfo[64];

    public ViolationCodeInfo(int code, String name, String desc, String descHtml, int force, InSpec[] specs, String[] badExamples, String[] goodExamples, boolean unimplemented) {
        super(badExamples, goodExamples);
        if (force == 0) {
            force = 16;
        }
        this.force = force;
        this.name = name;
        this.code = code;
        this.description = desc;
        this.descriptionHtml = descHtml;
        this.unimplemented = unimplemented;
        this.specifications = specs;
        this.init();
    }

    public ViolationCodeInfo(int code, String name, String[] badExamples, String[] goodExamples, boolean internal) {
        super(badExamples, goodExamples);
        this.force = 0;
        this.name = name;
        this.code = code;
        this.description = name;
        this.descriptionHtml = "<p>name</p>";
        this.unimplemented = !internal;
        this.specifications = new InSpec[0];
        this.init();
    }

    private void init() {
        if (all[this.code] != null) {
            throw new IllegalArgumentException("Duplicate code: " + this.code + " (" + this.name + ", " + ViolationCodeInfo.all[this.code].name + ")");
        }
        ViolationCodeInfo.all[this.code] = this;
        int i = 0;
        while (i < this.specifications.length) {
            this.specifications[i].add(this);
            ++i;
        }
    }

    public int getCode() {
        return this.code;
    }

    public int getForce() {
        return this.force;
    }

    public String getCodeName() {
        return this.name;
    }

    public boolean appliesTo(Specification specification) {
        int i = 0;
        while (i < this.specifications.length) {
            if (this.specifications[i].spec == specification) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isImplemented() {
        return !this.unimplemented;
    }

    public static abstract class InSpec {
        private final Specification spec;
        private final String uri;

        public InSpec(String name, String uri) {
            this.spec = Specification.get(name);
            this.uri = uri.equals(this.spec.getUri()) ? null : uri;
        }

        public void add(ViolationCodeInfo info) {
            this.spec.add(this, info);
        }
    }

    public static abstract class FromSpec
    extends InSpec {
        private final int component;
        private final String definition;
        private final String definitionHtml;

        public FromSpec(String name, int component, String uri, String defn, String defnHtml) {
            super(name, uri);
            this.component = component;
            this.definition = defn;
            this.definitionHtml = defnHtml;
        }
    }

    public static class FromSpec_other
    extends FromSpec {
        public FromSpec_other(String name, int component, String uri, String defn, String defnHtml) {
            super(name, component, uri, defn, defnHtml);
        }
    }

    public static class FromSpec_scheme
    extends FromSpec {
        public FromSpec_scheme(String name, int component, String uri, String defn, String defnHtml) {
            super(name, component, uri, defn, defnHtml);
        }

        public FromSpec_scheme(String name, int component, String uri) {
            this(name, component, uri, null, null);
        }
    }

    public static class FromSpec_iri
    extends FromSpec {
        public FromSpec_iri(String name, int component, String uri, String defn, String defnHtml) {
            super(name, component, uri, defn, defnHtml);
        }
    }

    public static class FromAlso
    extends InSpec {
        public FromAlso(String spec, String uri) {
            super(spec, uri);
        }
    }
}

