/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.selector;

import java.util.Comparator;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IFitness;
import net.sf.jclec.IIndividual;
import net.sf.jclec.ISystem;
import net.sf.jclec.selector.StochasticSelector;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TournamentSelector<I extends IIndividual>
extends StochasticSelector<I>
implements IConfigure {
    private static final long serialVersionUID = -8077322230229976289L;
    protected int tournamentSize;
    protected transient Comparator<I> individualsComparator = new Comparator<I>(){

        @Override
        public int compare(I ind0, I ind1) {
            return TournamentSelector.this.fitnessComparator.compare(ind0.getFitness(), ind1.getFitness());
        }
    };
    protected transient Comparator<IFitness> fitnessComparator;

    public TournamentSelector() {
    }

    public TournamentSelector(ISystem<I> context) {
        super(context);
    }

    public final int getTournamentSize() {
        return this.tournamentSize;
    }

    public final void setTournamentSize(int tournamentSize) {
        this.tournamentSize = tournamentSize;
    }

    @Override
    public void configure(Configuration settings) {
        int tournamentSize = settings.getInt("tournament-size", 2);
        this.setTournamentSize(tournamentSize);
    }

    public boolean equals(Object other) {
        if (other instanceof TournamentSelector) {
            TournamentSelector o = (TournamentSelector)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.tournamentSize, o.tournamentSize);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void prepareSelection() {
        this.fitnessComparator = this.context.getEvaluator().getComparator();
    }

    @Override
    protected I selectNext() {
        IIndividual winner = (IIndividual)this.actsrc.get(this.randgen.choose(0, this.actsrcsz));
        int j = 1;
        while (j < this.tournamentSize) {
            IIndividual opponent = (IIndividual)this.actsrc.get(this.randgen.choose(0, this.actsrcsz));
            if (this.individualsComparator.compare(winner, opponent) == -1) {
                winner = opponent;
            }
            ++j;
        }
        return (I)winner;
    }
}

