/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.jamesframework.core.problems.Problem;
import org.jamesframework.core.problems.constraints.validations.Validation;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.search.LocalSearch;
import org.jamesframework.core.search.cache.EvaluatedMoveCache;
import org.jamesframework.core.search.cache.SingleEvaluatedMoveCache;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.core.search.status.SearchStatus;

public abstract class NeighbourhoodSearch<SolutionType extends Solution>
extends LocalSearch<SolutionType> {
    private long numAcceptedMoves = -1L;
    private long numRejectedMoves = -1L;
    private EvaluatedMoveCache cache = new SingleEvaluatedMoveCache();

    public NeighbourhoodSearch(Problem<SolutionType> problem) {
        this(null, problem);
    }

    public NeighbourhoodSearch(String name, Problem<SolutionType> problem) {
        super(name != null ? name : "NeighbourhoodSearch", problem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvaluatedMoveCache(EvaluatedMoveCache cache) {
        Object object = this.getStatusLock();
        synchronized (object) {
            this.assertIdle("Cannot set custom evaluated move cache in neighbourhood search.");
            this.cache = cache;
        }
    }

    @Override
    public void init() {
        super.init();
        this.numAcceptedMoves = 0L;
        this.numRejectedMoves = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumAcceptedMoves() {
        Object object = this.getStatusLock();
        synchronized (object) {
            if (this.getStatus() == SearchStatus.INITIALIZING) {
                return -1L;
            }
            return this.numAcceptedMoves;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumRejectedMoves() {
        Object object = this.getStatusLock();
        synchronized (object) {
            if (this.getStatus() == SearchStatus.INITIALIZING) {
                return -1L;
            }
            return this.numRejectedMoves;
        }
    }

    @Override
    protected void updateCurrentSolution(SolutionType solution, Evaluation evaluation, Validation validation) {
        super.updateCurrentSolution(solution, evaluation, validation);
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    protected Evaluation evaluate(Move<? super SolutionType> move) {
        Evaluation eval = null;
        if (this.cache != null) {
            eval = this.cache.getCachedMoveEvaluation(move);
        }
        if (eval != null) {
            return eval;
        }
        eval = this.getProblem().evaluate(move, (SolutionType)this.getCurrentSolution(), this.getCurrentSolutionEvaluation());
        if (this.cache != null) {
            this.cache.cacheMoveEvaluation(move, eval);
        }
        return eval;
    }

    protected Validation validate(Move<? super SolutionType> move) {
        Validation val = null;
        if (this.cache != null) {
            val = this.cache.getCachedMoveValidation(move);
        }
        if (val != null) {
            return val;
        }
        val = this.getProblem().validate(move, (SolutionType)this.getCurrentSolution(), this.getCurrentSolutionValidation());
        if (this.cache != null) {
            this.cache.cacheMoveValidation(move, val);
        }
        return val;
    }

    protected boolean isImprovement(Move<? super SolutionType> move) {
        return move != null && this.validate(move).passed() && (!this.getCurrentSolutionValidation().passed() || this.computeDelta(this.evaluate(move), this.getCurrentSolutionEvaluation()) > 0.0);
    }

    @SafeVarargs
    protected final Move<? super SolutionType> getBestMove(Collection<? extends Move<? super SolutionType>> moves, boolean requireImprovement, Predicate<? super Move<? super SolutionType>> ... filters) {
        Move<SolutionType> bestMove = null;
        double bestMoveDelta = -1.7976931348623157E308;
        Evaluation bestMoveEvaluation = null;
        Validation bestMoveValidation = null;
        for (Move<SolutionType> move : moves) {
            Evaluation curMoveEvaluation;
            double curMoveDelta;
            Validation curMoveValidation;
            if (!Arrays.stream(filters).allMatch(filter -> filter.test(move)) || !(curMoveValidation = this.validate(move)).passed() || !((curMoveDelta = this.computeDelta(curMoveEvaluation = this.evaluate(move), this.getCurrentSolutionEvaluation())) > bestMoveDelta) || requireImprovement && !(curMoveDelta > 0.0) && this.getCurrentSolutionValidation().passed()) continue;
            bestMove = move;
            bestMoveDelta = curMoveDelta;
            bestMoveEvaluation = curMoveEvaluation;
        }
        if (bestMove != null && this.cache != null) {
            this.cache.cacheMoveEvaluation(bestMove, bestMoveEvaluation);
            this.cache.cacheMoveValidation(bestMove, bestMoveValidation);
        }
        return bestMove;
    }

    protected boolean accept(Move<? super SolutionType> move) {
        Validation newValidation = this.validate(move);
        if (newValidation.passed()) {
            Evaluation newEvaluation = this.evaluate(move);
            move.apply(this.getCurrentSolution());
            this.updateCurrentAndBestSolution(this.getCurrentSolution(), newEvaluation, newValidation);
            this.incNumAcceptedMoves(1L);
            return true;
        }
        return false;
    }

    protected void incNumAcceptedMoves(long inc) {
        this.numAcceptedMoves += inc;
    }

    protected void reject(Move<? super SolutionType> move) {
        this.incNumRejectedMoves(1L);
    }

    protected void incNumRejectedMoves(long inc) {
        this.numRejectedMoves += inc;
    }
}

