/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.evaluate;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.evaluate.ClusteringEvaluator;

public class AccuracyEvaluator
extends ClusteringEvaluator {
    int correctTotal = 0;
    int comparisonsTotal = 0;

    @Override
    public String evaluate(Clustering truth, Clustering predicted) {
        return "accuracy=" + String.valueOf(this.getEvaluationScores(truth, predicted)[0]);
    }

    @Override
    public String evaluateTotals() {
        return "accuracy=" + (double)this.correctTotal / (double)this.comparisonsTotal;
    }

    @Override
    public double[] getEvaluationScores(Clustering truth, Clustering predicted) {
        int correct = 0;
        int comparisons = 0;
        for (int i = 0; i < truth.getNumInstances(); ++i) {
            for (int j = i + 1; j < truth.getNumInstances(); ++j) {
                if (truth.getLabel(i) == truth.getLabel(j) == (predicted.getLabel(i) == predicted.getLabel(j))) {
                    ++correct;
                }
                ++comparisons;
            }
        }
        this.correctTotal += correct;
        this.comparisonsTotal += comparisons;
        return new double[]{(double)correct / (double)comparisons};
    }
}

