/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.gmwcs.solver.preprocessing;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import ru.itmo.ctlab.gmwcs.solver.preprocessing.ConnectedComponent;
import ru.itmo.ctlab.gmwcs.solver.preprocessing.Dijkstra;
import ru.itmo.ctlab.gmwcs.solver.preprocessing.MST;
import ru.itmo.ctlab.gmwcs.solver.preprocessing.Preprocessor;
import ru.itmo.ctlab.gmwcs.solver.preprocessing.PreprocessorKt;
import ru.itmo.ctlab.gmwcs.solver.preprocessing.ReductionSequence;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.gmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.gmwcs.graph.Elem;
import ru.itmo.ctlab.virgo.gmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a,\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\b\u0002\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\"j\u0002`#\u001a2\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020\b2\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\"j\u0002`#2\u0006\u0010'\u001a\u00020\u0010H\u0002\u001a2\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010*\u001a\u00020\b2\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\"j\u0002`#2\u0006\u0010'\u001a\u00020\u0010H\u0002\u001a\u0018\u0010+\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0016H\u0002\u001aH\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020\b2\u0006\u0010/\u001a\u00020 2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0010012\u001a\b\u0002\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b030\u0001H\u0002\u001a\u000e\u00104\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 \u001a,\u00105\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\b\u0002\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\"j\u0002`#\u001a,\u00106\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\b\u0002\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\"j\u0002`#\u001a\"\u00107\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0010\u00108\u001a\f\u0012\u0004\u0012\u00020\u00160\u001dj\u0002`9H\u0002\u001a\"\u0010:\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0010\u0010;\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001eH\u0002\u001a\"\u0010<\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0010\u00108\u001a\f\u0012\u0004\u0012\u00020\u00160\u001dj\u0002`9H\u0002\u001a\"\u0010=\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0010\u0010;\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001eH\u0002\u001a \u0010>\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\bH\u0002\u001a(\u0010>\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020\u00162\u0006\u00106\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bH\u0002\u001a,\u0010?\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\b\u0002\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\"j\u0002`#\u001a,\u0010@\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\b\u0002\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\"j\u0002`#\u001a,\u0010A\u001a\f\u0012\u0004\u0012\u00020\u00160\u001dj\u0002`92\u0006\u0010\u001f\u001a\u00020 2\u0012\b\u0002\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00160\"j\u0002`B\u001a2\u0010C\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001e2\u0006\u0010D\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\"j\u0002`#\u001a,\u0010C\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\b\u0002\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\"j\u0002`#\u001a*\u0010E\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010F\u001a\u00020G2\u0010\u0010H\u001a\f\u0012\u0004\u0012\u00020\b0\u001dj\u0002`\u001eH\u0002\u001a\u0016\u0010I\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020\b\u001a>\u0010J\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0\u001d0\u001d\"\u0004\b\u0000\u0010K2\f\u0010L\u001a\b\u0012\u0004\u0012\u0002HK0M2\u0014\b\u0002\u0010N\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0\u001d0\u001dH\u0002\u001a\u000e\u0010O\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 \u001a\u000e\u0010P\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0010\u001a\u000e\u0010Q\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0010\u001a\u0018\u0010R\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020\bH\u0002\u001a.\u0010S\u001a\u001e\u0012\f\u0012\n T*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n T*\u0004\u0018\u00010\b0\b03*\u00020 2\u0006\u0010,\u001a\u00020\u0016\"#\u0010\u0000\u001a\u0014\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\"\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\"\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\n\"\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\n\"\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\n\"\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000*\u0016\u0010U\"\b\u0012\u0004\u0012\u00020\u00160\u001d2\b\u0012\u0004\u0012\u00020\u00160\u001d*\u0016\u0010V\"\b\u0012\u0004\u0012\u00020\u00160\"2\b\u0012\u0004\u0012\u00020\u00160\"*\u0016\u0010W\"\b\u0012\u0004\u0012\u00020\b0\"2\b\u0012\u0004\u0012\u00020\b0\"*\u0016\u0010X\"\b\u0012\u0004\u0012\u00020\b0\u001d2\b\u0012\u0004\u0012\u00020\b0\u001d*@\u0010Y\u001a\u0004\b\u0000\u0010K\"\u001a\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0\u001d\u0012\u0004\u0012\u00020\u00100Z2\u001a\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0\u001d\u0012\u0004\u0012\u00020\u00100Z*&\u0010[\"\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u00012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001*L\u0010\\\u001a\u0004\b\u0000\u0010K\" \u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0\u001d0Z2 \u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0\u001d0Z\u00a8\u0006]"}, d2={"allSteps", "", "Lru/itmo/ctlab/gmwcs/solver/preprocessing/ReductionSequence;", "Lru/itmo/ctlab/virgo/gmwcs/graph/Elem;", "Lru/itmo/ctlab/gmwcs/solver/preprocessing/Reductions;", "getAllSteps", "()Ljava/util/List;", "cns", "Lru/itmo/ctlab/virgo/gmwcs/graph/Node;", "getCns", "()Lru/itmo/ctlab/gmwcs/solver/preprocessing/ReductionSequence;", "isolated", "getIsolated", "leaves", "getLeaves", "logLevel", "", "mergeNeg", "getMergeNeg", "mergePos", "getMergePos", "negE", "Lru/itmo/ctlab/virgo/gmwcs/graph/Edge;", "getNegE", "negV", "getNegV", "nvk", "getNvk", "threads", "", "Lru/itmo/ctlab/gmwcs/solver/preprocessing/NodeSet;", "graph", "Lru/itmo/ctlab/virgo/gmwcs/graph/Graph;", "toRemove", "", "Lru/itmo/ctlab/gmwcs/solver/preprocessing/MutableNodeSet;", "cnsTest", "", "v", "r", "constructW", "Lru/itmo/ctlab/gmwcs/solver/preprocessing/ConnectedComponent;", "n", "contract", "e", "dfsC", "", "g", "visited", "", "p", "Lkotlin/Pair;", "findPosCycles", "isolatedVertices", "l", "logAndRemoveEdges", "edges", "Lru/itmo/ctlab/gmwcs/solver/preprocessing/EdgeSet;", "logAndRemoveNodes", "nodes", "logEdges", "logNodes", "merge", "mergeNegative", "mergePositive", "negativeEdges", "Lru/itmo/ctlab/gmwcs/solver/preprocessing/MutableEdgeSet;", "negativeVertices", "k", "nvkPredicate", "weight", "", "delta", "nvkTest", "powerset", "T", "left", "", "acc", "preprocess", "setLogLevel", "setThreads", "vertexTest", "getAdjacent", "kotlin.jvm.PlatformType", "EdgeSet", "MutableEdgeSet", "MutableNodeSet", "NodeSet", "Reduction", "Lkotlin/Function2;", "Reductions", "Step", "virgo-solver"})
public final class PreprocessorKt {
    private static int logLevel;
    private static int threads;
    @NotNull
    private static final ReductionSequence<Node> mergeNeg;
    @NotNull
    private static final ReductionSequence<Node> mergePos;
    @NotNull
    private static final ReductionSequence<Node> negV;
    @NotNull
    private static final ReductionSequence<Edge> negE;
    @NotNull
    private static final ReductionSequence<Node> cns;
    @NotNull
    private static final ReductionSequence<Node> nvk;
    @NotNull
    private static final ReductionSequence<Node> isolated;
    @NotNull
    private static final ReductionSequence<Node> leaves;
    @NotNull
    private static final List<ReductionSequence<? extends Elem>> allSteps;

    public static final void setLogLevel(int n) {
        logLevel = n;
    }

    public static final void setThreads(int n) {
        if (n <= 0) {
            throw (Throwable)new SolverException("Preprocessor num threads < 0");
        }
        threads = n;
    }

    @NotNull
    public static final Pair<Node, Node> getAdjacent(@NotNull Graph $this$getAdjacent, @NotNull Edge e) {
        Intrinsics.checkParameterIsNotNull($this$getAdjacent, "$this$getAdjacent");
        Intrinsics.checkParameterIsNotNull(e, "e");
        return new Pair<Node, Node>($this$getAdjacent.getEdgeSource(e), $this$getAdjacent.getEdgeTarget(e));
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> Set<Set<T>> powerset(Collection<? extends T> left, Set<? extends Set<? extends T>> acc) {
        Set<Set<T>> set;
        if (left.isEmpty()) {
            set = acc;
        } else {
            Collection collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = acc;
            Set<Set<T>> set2 = acc;
            Collection collection2 = CollectionsKt.drop((Iterable)left, 1);
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Set set3 = (Set)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Set set4 = SetsKt.plus(it, CollectionsKt.first((Iterable)left));
                collection.add(set4);
            }
            collection = (List)destination$iv$iv;
            set = PreprocessorKt.powerset(collection2, SetsKt.plus(set2, collection));
        }
        return set;
    }

    static /* synthetic */ Set powerset$default(Collection collection, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.setOf(SetsKt.emptySet());
        }
        return PreprocessorKt.powerset(collection, set);
    }

    @NotNull
    public static final ReductionSequence<Node> getMergeNeg() {
        return mergeNeg;
    }

    @NotNull
    public static final ReductionSequence<Node> getMergePos() {
        return mergePos;
    }

    @NotNull
    public static final ReductionSequence<Node> getNegV() {
        return negV;
    }

    @NotNull
    public static final ReductionSequence<Edge> getNegE() {
        return negE;
    }

    @NotNull
    public static final ReductionSequence<Node> getCns() {
        return cns;
    }

    @NotNull
    public static final ReductionSequence<Node> getNvk() {
        return nvk;
    }

    @NotNull
    public static final ReductionSequence<Node> getIsolated() {
        return isolated;
    }

    @NotNull
    public static final ReductionSequence<Node> getLeaves() {
        return leaves;
    }

    @NotNull
    public static final List<ReductionSequence<? extends Elem>> getAllSteps() {
        return allSteps;
    }

    @NotNull
    public static final Set<Node> isolatedVertices(@NotNull Graph graph, @NotNull Set<Node> toRemove) {
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Intrinsics.checkParameterIsNotNull(toRemove, "toRemove");
        Set<Node> set = graph.vertexSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.vertexSet()");
        Iterable $this$filterTo$iv = set;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            Node node = it;
            Intrinsics.checkExpressionValueIsNotNull(node, "it");
            if (!(node.getWeight() <= 0.0 && graph.degreeOf(it) == 0)) continue;
            ((Collection)toRemove).add(element$iv);
        }
        return (Set)((Collection)toRemove);
    }

    public static /* synthetic */ Set isolatedVertices$default(Graph graph, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return PreprocessorKt.isolatedVertices(graph, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Node> l(@NotNull Graph graph, @NotNull Set<Node> toRemove) {
        void $this$filterTo$iv$iv;
        Object v1;
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Intrinsics.checkParameterIsNotNull(toRemove, "toRemove");
        Set<Node> set = graph.vertexSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.vertexSet()");
        Iterable $this$maxBy$iv = set;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                Node it = (Node)maxElem$iv;
                boolean bl = false;
                Node node = it;
                Intrinsics.checkExpressionValueIsNotNull(node, "it");
                double maxValue$iv = node.getWeight();
                do {
                    Object e$iv = iterator$iv.next();
                    Node it2 = (Node)e$iv;
                    $i$a$-maxBy-PreprocessorKt$l$prim$1 = false;
                    Node node2 = it2;
                    Intrinsics.checkExpressionValueIsNotNull(node2, "it");
                    double v$iv = node2.getWeight();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        Node prim = v1;
        Set<Node> set2 = graph.vertexSet();
        Intrinsics.checkExpressionValueIsNotNull(set2, "graph.vertexSet()");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        Iterable maxValue$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Node it = (Node)element$iv$iv;
            boolean bl = false;
            if (!(graph.degreeOf(it) == 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        while (iterator2.hasNext()) {
            Node n;
            Node node = n = (Node)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(node, "n");
            double d = node.getWeight();
            Node node3 = prim;
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            if (d >= node3.getWeight() || graph.edgesOf(n).size() > 1) continue;
            Edge e = graph.edgesOf(n).iterator().next();
            Node opposite = graph.opposite(n, e);
            double d2 = n.getWeight();
            Edge edge = e;
            Intrinsics.checkExpressionValueIsNotNull(edge, "e");
            if (d2 + edge.getWeight() > 0.0) {
                opposite.absorb(n);
                opposite.absorb(e);
                toRemove.add(n);
                continue;
            }
            if (!(n.getWeight() + e.getWeight() < 0.0)) continue;
            toRemove.add(n);
        }
        return toRemove;
    }

    public static /* synthetic */ Set l$default(Graph graph, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return PreprocessorKt.l(graph, set);
    }

    @NotNull
    public static final Set<Node> mergeNegative(@NotNull Graph graph, @NotNull Set<Node> toRemove) {
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Intrinsics.checkParameterIsNotNull(toRemove, "toRemove");
        Set<Node> set = graph.vertexSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.vertexSet()");
        Iterator iterator2 = CollectionsKt.toList((Iterable)set).iterator();
        while (iterator2.hasNext()) {
            Edge[] edges;
            Node v;
            Node node = v = (Node)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(node, "v");
            if (node.getWeight() > 0.0 || graph.degreeOf(v) != 2) continue;
            Set<Edge> set2 = graph.edgesOf(v);
            Intrinsics.checkExpressionValueIsNotNull(set2, "graph.edgesOf(v)");
            Collection $this$toTypedArray$iv = set2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new Edge[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Edge edge = edges[0];
            Intrinsics.checkExpressionValueIsNotNull(edge, "edges[0]");
            if (edge.getWeight() > 0.0) continue;
            Edge edge2 = edges[1];
            Intrinsics.checkExpressionValueIsNotNull(edge2, "edges[1]");
            if (edge2.getWeight() > 0.0) continue;
            Node l = graph.opposite(v, edges[0]);
            Node r = graph.opposite(v, edges[1]);
            toRemove.add(v);
            graph.removeVertex(v);
            if (!(Intrinsics.areEqual(l, r) ^ true)) continue;
            edges[0].absorb(v);
            edges[0].absorb(edges[1]);
            graph.addEdge(l, r, edges[0]);
            List<Edge> list = graph.getAllEdges(l, r);
            Intrinsics.checkExpressionValueIsNotNull(list, "graph.getAllEdges(l, r)");
            List es = CollectionsKt.sorted((Iterable)list);
            Edge maxE = (Edge)es.get(es.size() - 1);
            Iterator iterator3 = es.subList(0, es.size() - 1).iterator();
            while (iterator3.hasNext()) {
                Edge e;
                Edge edge3 = e = (Edge)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull(edge3, "e");
                if (edge3.getWeight() >= 0.0) {
                    maxE.absorb(e);
                }
                graph.removeEdge(e);
            }
        }
        return toRemove;
    }

    public static /* synthetic */ Set mergeNegative$default(Graph graph, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return PreprocessorKt.mergeNegative(graph, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Node> mergePositive(@NotNull Graph graph, @NotNull Set<Node> toRemove) {
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Intrinsics.checkParameterIsNotNull(toRemove, "toRemove");
        Set<Edge> set = graph.edgeSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.edgeSet()");
        for (Edge edge : CollectionsKt.toList((Iterable)set)) {
            void from;
            if (!graph.containsEdge(edge)) continue;
            Edge edge2 = edge;
            Intrinsics.checkExpressionValueIsNotNull(edge2, "edge");
            Pair<Node, Node> pair = PreprocessorKt.getAdjacent(graph, edge2);
            Node node = pair.component1();
            Node to = pair.component2();
            double ew = edge.getWeight();
            if (Intrinsics.areEqual(from, to)) {
                void v2 = from;
                Intrinsics.checkExpressionValueIsNotNull(v2, "from");
                PreprocessorKt.merge(graph, edge, (Node)v2);
                continue;
            }
            if (!(ew >= 0.0)) continue;
            void v3 = from;
            Intrinsics.checkExpressionValueIsNotNull(v3, "from");
            if (!(ew + v3.getWeight() >= 0.0)) continue;
            Node node2 = to;
            Intrinsics.checkExpressionValueIsNotNull(node2, "to");
            if (!(ew + node2.getWeight() >= 0.0)) continue;
            PreprocessorKt.merge(graph, edge, (Node)from, to);
        }
        return toRemove;
    }

    public static /* synthetic */ Set mergePositive$default(Graph graph, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return PreprocessorKt.mergePositive(graph, set);
    }

    private static final void merge(Graph graph, Edge e, Node n) {
        if (e.getWeight() > 0.0) {
            n.absorb(e);
        }
        graph.removeEdge(e);
    }

    private static final void merge(Graph graph, Edge e, Node l, Node r) {
        if (!CollectionsKt.listOf(l, r).containsAll((Collection)TuplesKt.toList(PreprocessorKt.getAdjacent(graph, e)))) {
            throw (Throwable)new IllegalArgumentException();
        }
        boolean bl = Intrinsics.areEqual(l, r) ^ true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        PreprocessorKt.contract(graph, e);
    }

    /*
     * WARNING - void declaration
     */
    private static final void contract(Graph graph, Edge e) {
        void main;
        Pair<Node, Node> pair = PreprocessorKt.getAdjacent(graph, e);
        Node node = pair.component1();
        Node aux = pair.component2();
        Set<Edge> auxEdges = graph.edgesOf(aux);
        auxEdges.remove(e);
        for (Edge edge : auxEdges) {
            Node opposite = graph.opposite(aux, edge);
            Edge m = graph.getEdge((Node)main, opposite);
            graph.removeEdge(edge);
            if (m == null) {
                if (Intrinsics.areEqual(opposite, main)) {
                    Edge edge2 = edge;
                    Intrinsics.checkExpressionValueIsNotNull(edge2, "edge");
                    if (!(edge2.getWeight() >= 0.0)) continue;
                    main.absorb(edge);
                    continue;
                }
                graph.addEdge((Node)main, opposite, edge);
                continue;
            }
            Edge edge3 = edge;
            Intrinsics.checkExpressionValueIsNotNull(edge3, "edge");
            if (edge3.getWeight() >= 0.0 && m.getWeight() >= 0.0) {
                m.absorb(edge);
                continue;
            }
            if (!(m.getWeight() <= edge.getWeight())) continue;
            boolean bl = Intrinsics.areEqual(m, edge) ^ true;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            graph.removeEdge(m);
            graph.addEdge((Node)main, opposite, edge);
        }
        graph.removeVertex(aux);
        main.absorb(aux);
        main.absorb(e);
    }

    @NotNull
    public static final Set<Node> negativeVertices(@NotNull Graph graph, @NotNull Set<Node> toRemove) {
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Intrinsics.checkParameterIsNotNull(toRemove, "toRemove");
        Set<Node> set = graph.vertexSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.vertexSet()");
        Iterable $this$filterTo$iv = set;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            Node node = it;
            Intrinsics.checkExpressionValueIsNotNull(node, "it");
            if (!PreprocessorKt.vertexTest(graph, node)) continue;
            ((Collection)toRemove).add(element$iv);
        }
        return toRemove;
    }

    public static /* synthetic */ Set negativeVertices$default(Graph graph, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return PreprocessorKt.negativeVertices(graph, set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean vertexTest(Graph graph, Node v) {
        boolean bl;
        if (!(v.getWeight() < 0.0)) return false;
        if (graph.neighborListOf(v).size() != 2) return false;
        Set<Edge> set = graph.edgesOf(v);
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.edgesOf(v)");
        Iterable $this$all$iv = set;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                Edge it = (Edge)element$iv;
                boolean bl2 = false;
                Edge edge = it;
                Intrinsics.checkExpressionValueIsNotNull(edge, "it");
                if (!(edge.getWeight() <= 0.0)) return false;
                boolean bl3 = true;
                if (bl3) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        List<Node> neighbors = graph.neighborListOf(v);
        Node n1 = neighbors.get(0);
        Node n2 = neighbors.get(1);
        Node node = n1;
        Intrinsics.checkExpressionValueIsNotNull(node, "n1");
        Dijkstra dijkstra = new Dijkstra(graph, node);
        Node node2 = n2;
        Intrinsics.checkExpressionValueIsNotNull(node2, "n2");
        boolean bl4 = dijkstra.negativeVertex(node2, v);
        return bl4;
    }

    @NotNull
    public static final Set<Node> cns(@NotNull Graph graph, @NotNull Set<Node> toRemove) {
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Intrinsics.checkParameterIsNotNull(toRemove, "toRemove");
        Set<Node> set = graph.vertexSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.vertexSet()");
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)set);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            Node node = it;
            Intrinsics.checkExpressionValueIsNotNull(node, "it");
            if (node.getWeight() >= 0.0 && !toRemove.contains(it)) {
                PreprocessorKt.cnsTest(graph, it, toRemove, 1);
            }
            PreprocessorKt.cnsTest(graph, it, toRemove, 2);
        }
        return toRemove;
    }

    public static /* synthetic */ Set cns$default(Graph graph, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return PreprocessorKt.cns(graph, set);
    }

    /*
     * WARNING - void declaration
     */
    private static final void cnsTest(Graph graph, Node v, Set<Node> toRemove, int r) {
        ConnectedComponent connectedComponent = PreprocessorKt.constructW(graph, v, toRemove, r);
        Set<Node> set = connectedComponent.component1();
        double d = connectedComponent.component2();
        Set<Node> wNeighbors = connectedComponent.component3();
        for (Node u : wNeighbors) {
            void w;
            List<Node> list = graph.neighborListOf(u);
            Intrinsics.checkExpressionValueIsNotNull(list, "graph.neighborListOf(u)");
            Iterator iterator2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)list), (Function1)new Function1<Node, Boolean>((Set)w){
                final /* synthetic */ Set $w;

                public final boolean invoke(Node it) {
                    return !this.$w.contains(it);
                }
                {
                    this.$w = set;
                    super(1);
                }
            }).iterator();
            while (iterator2.hasNext()) {
                void wSum;
                void $this$filterTo$iv$iv;
                double d2;
                void $this$sumByDouble$iv;
                Node cand;
                Node node = cand = (Node)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(node, "cand");
                double d3 = node.getWeight();
                Set<Edge> set2 = graph.edgesOf(cand);
                Intrinsics.checkExpressionValueIsNotNull(set2, "graph.edgesOf(cand)");
                Iterable iterable = set2;
                double d4 = d3;
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (Object element$iv : $this$sumByDouble$iv) {
                    void it;
                    Edge edge = (Edge)element$iv;
                    d2 = sum$iv;
                    boolean bl = false;
                    void v4 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v4, "it");
                    double d5 = RangesKt.coerceAtLeast(v4.getWeight(), 0.0);
                    sum$iv = d2 + d5;
                }
                d2 = sum$iv;
                double bestSum = d4 + d2;
                if (bestSum >= 0.0) continue;
                List<Node> list2 = graph.neighborListOf(cand);
                Intrinsics.checkExpressionValueIsNotNull(list2, "graph.neighborListOf(cand)");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Node it = (Node)element$iv$iv;
                    boolean bl = false;
                    if (!(!w.contains(it) && !toRemove.contains(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List candN = (List)destination$iv$iv;
                if (!wNeighbors.containsAll(candN) || !(bestSum < wSum)) continue;
                toRemove.add(cand);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final ConnectedComponent constructW(Graph graph, Node n, Set<Node> toRemove, int r) {
        double d;
        double d2;
        double d3 = n.getWeight();
        double d4 = 0.0;
        int n2 = 0;
        double wSum = Math.min(d3, d4);
        Set<Node> w = SetsKt.mutableSetOf(n);
        int n3 = 1;
        int n4 = r;
        if (n3 <= n4) {
            while (true) {
                void i;
                Node[] nodeArray;
                Collection $this$toTypedArray$iv = w;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new Node[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                for (Node v : nodeArray) {
                    void $this$filterTo$iv$iv;
                    List<Node> list = graph.neighborListOf(v);
                    Intrinsics.checkExpressionValueIsNotNull(list, "graph.neighborListOf(v)");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Node it = (Node)element$iv$iv;
                        boolean bl = false;
                        if (!(!toRemove.contains(it) && !w.contains(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    for (Node u : (List)destination$iv$iv) {
                        Edge edge;
                        Edge edge2 = edge = graph.getEdge(u, v);
                        Intrinsics.checkExpressionValueIsNotNull(edge2, "edge");
                        double d5 = edge2.getWeight();
                        Node node = u;
                        Intrinsics.checkExpressionValueIsNotNull(node, "u");
                        double weightSum = d5 + node.getWeight();
                        if (!(weightSum >= 0.0)) continue;
                        double d6 = edge.getWeight();
                        double d7 = 0.0;
                        d2 = wSum;
                        boolean bl = false;
                        d = Math.min(d6, d7);
                        d6 = u.getWeight();
                        d7 = 0.0;
                        bl = false;
                        double d8 = Math.min(d6, d7);
                        wSum = d2 + (d + d8);
                        w.add(u);
                    }
                }
                if (i == n4) break;
                ++i;
            }
        }
        n4 = 0;
        Set wNeighbors = new LinkedHashSet();
        for (Node u : w) {
            List<Node> nbs = graph.neighborListOf(u);
            for (Node nb : nbs) {
                if (w.contains(nb) || toRemove.contains(nb)) continue;
                Node node = nb;
                Intrinsics.checkExpressionValueIsNotNull(node, "nb");
                wNeighbors.add(node);
                Edge edge = graph.getEdge(nb, u);
                Intrinsics.checkExpressionValueIsNotNull(edge, "graph.getEdge(nb, u)");
                double d9 = edge.getWeight();
                double d10 = 0.0;
                d2 = wSum;
                boolean bl = false;
                d = Math.min(d9, d10);
                wSum = d2 + d;
            }
        }
        return new ConnectedComponent(w, wSum, wNeighbors);
    }

    @NotNull
    public static final Set<Edge> negativeEdges(@NotNull Graph graph, @NotNull Set<Edge> toRemove) {
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Intrinsics.checkParameterIsNotNull(toRemove, "toRemove");
        ExecutorService executor = threads == 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(threads);
        graph.subgraph(graph.vertexSet());
        ConcurrentSkipListSet acu = new ConcurrentSkipListSet();
        Set<Node> set = graph.vertexSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.vertexSet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node n = (Node)element$iv;
            boolean bl = false;
            executor.submit(new Runnable(n, executor, graph, acu){
                final /* synthetic */ Node $n;
                final /* synthetic */ ExecutorService $executor$inlined;
                final /* synthetic */ Graph $graph$inlined;
                final /* synthetic */ ConcurrentSkipListSet $acu$inlined;
                {
                    this.$n = node;
                    this.$executor$inlined = executorService;
                    this.$graph$inlined = graph;
                    this.$acu$inlined = concurrentSkipListSet;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    Set<T> set;
                    void $this$mapTo$iv$iv;
                    Edge it;
                    Iterable $this$filterTo$iv$iv;
                    Set<Edge> set2 = this.$graph$inlined.edgesOf(this.$n);
                    Intrinsics.checkExpressionValueIsNotNull(set2, "graph.edgesOf(n)");
                    Iterable $this$filter$iv = set2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Edge)element$iv$iv;
                        boolean bl = false;
                        Edge edge = it;
                        Intrinsics.checkExpressionValueIsNotNull(edge, "it");
                        int n = edge.getNum();
                        Node node = this.$n;
                        Intrinsics.checkExpressionValueIsNotNull(node, "n");
                        if (!(n < node.getNum() && it.getWeight() <= 0.0 && !this.$acu$inlined.contains(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Edge)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Node node = this.$graph$inlined.opposite(this.$n, it);
                        collection.add(node);
                    }
                    Set<T> neighs = CollectionsKt.toSet((List)destination$iv$iv);
                    if (!neighs.isEmpty()) {
                        Node node = this.$n;
                        Intrinsics.checkExpressionValueIsNotNull(node, "n");
                        set = CollectionsKt.toSet((Iterable)new Dijkstra(this.$graph$inlined, node).negativeEdges(neighs));
                    } else {
                        set = SetsKt.emptySet();
                    }
                    Set<T> res = set;
                    this.$acu$inlined.addAll((Collection)res);
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        toRemove.addAll(acu);
        return toRemove;
    }

    public static /* synthetic */ Set negativeEdges$default(Graph graph, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return PreprocessorKt.negativeEdges(graph, set);
    }

    @NotNull
    public static final Set<Node> negativeVertices(int k, @NotNull Graph graph, @NotNull Set<Node> toRemove) {
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Intrinsics.checkParameterIsNotNull(toRemove, "toRemove");
        if (k < 2) {
            throw (Throwable)new IllegalArgumentException("k must be >= 2");
        }
        if (k == 2) {
            return PreprocessorKt.negativeVertices(graph, toRemove);
        }
        Set<Node> set = graph.vertexSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.vertexSet()");
        Iterable $this$filterTo$iv = CollectionsKt.toSet((Iterable)set);
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            Node node = it;
            Intrinsics.checkExpressionValueIsNotNull(node, "it");
            if (!(node.getWeight() <= 0.0 && 3 <= graph.degreeOf(it) && graph.degreeOf(it) <= k && PreprocessorKt.nvkTest(graph, it))) continue;
            ((Collection)toRemove).add(element$iv);
        }
        return toRemove;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean nvkTest(@NotNull Graph graph, @NotNull Node v) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Intrinsics.checkParameterIsNotNull(v, "v");
        Set<Edge> set = graph.edgesOf(v);
        Intrinsics.checkExpressionValueIsNotNull(set, "graph.edgesOf(v)");
        Sequence edgesWs2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)set), nvkTest.edgesWs.1.INSTANCE);
        Object r = SequencesKt.max(edgesWs2);
        if (r == null) {
            Intrinsics.throwNpe();
        }
        double maxW = (Double)r;
        double d = 0.0;
        double d2 = v.getWeight() + SequencesKt.sumOfDouble(SequencesKt.map(edgesWs2, nvkTest.weight.1.INSTANCE));
        boolean bl2 = false;
        double d3 = Math.min(maxW, d);
        double weight2 = d2 + d3;
        if (weight2 >= 0.0) {
            bl = false;
        } else {
            Node it;
            void $this$mapTo$iv$iv;
            List<Node> list = graph.neighborListOf(v);
            Intrinsics.checkExpressionValueIsNotNull(list, "graph.neighborListOf(v)");
            Set delta = CollectionsKt.toSet((Iterable)list);
            Iterable $this$map$iv = delta;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Node node = (Node)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Pair<void, List<Edge>> pair = new Pair<void, List<Edge>>((void)it, graph.getAllEdges(v, it));
                collection.add(pair);
            }
            List edges = (List)destination$iv$iv;
            graph.removeVertex(v);
            boolean delete = PreprocessorKt.nvkPredicate(graph, weight2, delta);
            graph.addVertex(v);
            Iterable $this$forEach$iv = edges;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List es;
                Pair $dstr$n$es = (Pair)element$iv;
                boolean bl4 = false;
                it = (Node)$dstr$n$es.component1();
                List list2 = es = (List)$dstr$n$es.component2();
                Intrinsics.checkExpressionValueIsNotNull(list2, "es");
                Iterable $this$forEach$iv2 = list2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void n;
                    Edge it2 = (Edge)element$iv2;
                    boolean bl5 = false;
                    graph.addEdge((Node)n, v, it2);
                }
            }
            bl = delete;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean nvkPredicate(Graph graph, double weight2, Set<? extends Node> delta) {
        boolean bl;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = delta;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Node node = (Node)item$iv$iv;
            collection = collection2;
            boolean bl2 = false;
            object = new Pair<void, Map<Node, Double>>(it, new Dijkstra(graph, (Node)it).negativeDistances(delta));
            collection.add(object);
        }
        Set ds = CollectionsKt.toSet((List)collection2);
        Iterable $this$map$iv2 = PreprocessorKt.powerset$default(ds, null, 2, null);
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : iterable2) {
            void it;
            Set bl2 = (Set)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            object = MapsKt.toMap((Iterable)it);
            collection.add(object);
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map2 = false;
        Iterable iterable3 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : iterable3) {
            void $this$mapValuesTo$iv$iv;
            Map it = (Map)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            Map $this$mapValues$iv = it;
            boolean $i$f$mapValues = false;
            Map map = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map v;
                void $dstr$_u24__u24$v;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv2;
                boolean bl5 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map3 = map2;
                boolean bl6 = false;
                void var32_44 = $dstr$_u24__u24$v;
                boolean bl7 = false;
                Map $this$filterKeys$iv = v = (Map)var32_44.getValue();
                boolean $i$f$filterKeys = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                Map map4 = $this$filterKeys$iv;
                boolean bl8 = false;
                for (Map.Entry entry$iv : map4.entrySet()) {
                    Node k3 = (Node)entry$iv.getKey();
                    boolean bl9 = false;
                    if (!it.containsKey(k3)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map map5 = result$iv;
                map3.put(k2, map5);
            }
            object = destination$iv$iv2;
            collection.add(object);
        }
        List powerset = (List)destination$iv$iv;
        Iterable $this$all$iv = powerset;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Map it = (Map)element$iv;
            boolean bl10 = false;
            if (it.size() >= 2) {
                MST mST = new MST(it);
                if (!(mST.solve() > weight2)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean dfsC(Node v, Graph g, Map<Node, Integer> visited, List<? extends Pair<? extends Edge, ? extends Node>> p) {
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        Edge it;
        Iterable $this$filterTo$iv$iv;
        if (((Number)visited.getOrDefault(v, 0)).intValue() == 2) {
            return false;
        }
        visited.put(v, 1);
        Set<Edge> set = g.edgesOf(v);
        Intrinsics.checkExpressionValueIsNotNull(set, "g.edgesOf(v)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Edge)element$iv$iv;
            boolean bl = false;
            Edge edge = it;
            Intrinsics.checkExpressionValueIsNotNull(edge, "it");
            if (!(edge.getWeight() >= 0.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Edge)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = new Pair<Edge, Node>(it, g.opposite(v, it));
            object2.add(object);
        }
        for (Pair pair : (List)destination$iv$iv) {
            void e;
            $this$map$iv = (Edge)pair.component1();
            Node u = (Node)pair.component2();
            Pair<void, Node> ev = new Pair<void, Node>(e, v);
            if (!p.isEmpty() && Intrinsics.areEqual(CollectionsKt.last(p).getSecond(), u) ^ true) {
                Node node = u;
                Intrinsics.checkExpressionValueIsNotNull(node, "u");
                if (((Number)visited.getOrDefault(node, 0)).intValue() == 1) {
                    void $this$dropWhile$iv;
                    destination$iv$iv = CollectionsKt.plus((Collection)p, ev);
                    object2 = System.err;
                    boolean $i$f$dropWhile = false;
                    boolean yielding$iv = false;
                    ArrayList list$iv = new ArrayList();
                    for (Object item$iv : $this$dropWhile$iv) {
                        if (yielding$iv) {
                            list$iv.add(item$iv);
                            continue;
                        }
                        Pair it2 = (Pair)item$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Node)it2.getSecond(), u) ^ true) continue;
                        list$iv.add(item$iv);
                        yielding$iv = true;
                    }
                    object = list$iv;
                    ((PrintStream)object2).println(CollectionsKt.joinToString$default((Iterable)object, "-", null, null, 0, null, dfsC.4.INSTANCE, 30, null));
                    return true;
                }
            }
            Map<Node, Integer> map = visited;
            boolean bl = false;
            Map<Node, Integer> map2 = map;
            boolean bl2 = false;
            if (map2.containsKey(u)) continue;
            Node node = u;
            Intrinsics.checkExpressionValueIsNotNull(node, "u");
            if (!PreprocessorKt.dfsC(node, g, visited, CollectionsKt.plus((Collection)p, ev))) continue;
            return true;
        }
        visited.put(v, 2);
        return false;
    }

    static /* synthetic */ boolean dfsC$default(Node node, Graph graph, Map map, List list, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return PreprocessorKt.dfsC(node, graph, map, list);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean findPosCycles(@NotNull Graph graph) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        Graph g = graph.subgraph(graph.vertexSet());
        boolean bl = false;
        Map vis = new LinkedHashMap();
        int res = 0;
        Set<Node> set = g.vertexSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "g.vertexSet()");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Node it = (Node)element$iv$iv;
            boolean bl2 = false;
            Node node = it;
            Intrinsics.checkExpressionValueIsNotNull(node, "it");
            if (!(node.getWeight() >= 0.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        while (iterator2.hasNext()) {
            Node v;
            Node node = v = (Node)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(node, "v");
            res += PreprocessorKt.dfsC$default(node, graph, vis, null, 8, null) ? 1 : 0;
            vis.replaceAll(findPosCycles.2.INSTANCE);
        }
        System.err.println("\nfound " + res + " cycles");
        return res > 0;
    }

    private static final int logEdges(Graph graph, Set<? extends Edge> edges) {
        if (logLevel > 0) {
            String string = edges.size() + " edges to remove";
            boolean bl = false;
            System.out.println((Object)string);
        }
        return edges.size();
    }

    private static final int logNodes(Graph graph, Set<? extends Node> nodes) {
        if (logLevel > 0) {
            String string = nodes.size() + " nodes to remove";
            boolean bl = false;
            System.out.println((Object)string);
        }
        return nodes.size();
    }

    private static final int logAndRemoveEdges(Graph graph, Set<? extends Edge> edges) {
        PreprocessorKt.logEdges(graph, edges);
        Iterable $this$forEach$iv = edges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Edge it = (Edge)element$iv;
            boolean bl = false;
            graph.removeEdge(it);
        }
        return edges.size();
    }

    private static final int logAndRemoveNodes(Graph graph, Set<? extends Node> nodes) {
        PreprocessorKt.logNodes(graph, nodes);
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            graph.removeVertex(it);
        }
        return nodes.size();
    }

    public static final void preprocess(@NotNull Graph graph) {
        Intrinsics.checkParameterIsNotNull(graph, "graph");
        new Preprocessor(graph, null, 2, null).preprocess();
    }

    static {
        threads = 1;
        mergeNeg = new ReductionSequence(mergeNeg.1.INSTANCE, mergeNeg.2.INSTANCE, "mergeNeg");
        mergePos = new ReductionSequence(mergePos.1.INSTANCE, mergePos.2.INSTANCE, "mergePos");
        negV = new ReductionSequence(negV.1.INSTANCE, negV.2.INSTANCE, "negV");
        negE = new ReductionSequence(negE.1.INSTANCE, negE.2.INSTANCE, "negE");
        cns = new ReductionSequence(cns.1.INSTANCE, cns.2.INSTANCE, "cns");
        nvk = new ReductionSequence(nvk.1.INSTANCE, nvk.2.INSTANCE, "nvk");
        isolated = new ReductionSequence(isolated.1.INSTANCE, isolated.2.INSTANCE, "isol");
        leaves = new ReductionSequence(leaves.1.INSTANCE, leaves.2.INSTANCE, "leaves");
        allSteps = CollectionsKt.listOf(isolated, mergeNeg, mergePos, leaves, cns, negE, negV, nvk);
    }

    public static final /* synthetic */ int access$getLogLevel$p() {
        return logLevel;
    }

    public static final /* synthetic */ void access$setLogLevel$p(int n) {
        logLevel = n;
    }

    public static final /* synthetic */ int access$logNodes(Graph graph, Set nodes) {
        return PreprocessorKt.logNodes(graph, nodes);
    }

    public static final /* synthetic */ int access$logAndRemoveNodes(Graph graph, Set nodes) {
        return PreprocessorKt.logAndRemoveNodes(graph, nodes);
    }

    public static final /* synthetic */ int access$logAndRemoveEdges(Graph graph, Set edges) {
        return PreprocessorKt.logAndRemoveEdges(graph, edges);
    }
}

