## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## -----------------------------------------------------------------------------
library(noisysbmGGM)



## -----------------------------------------------------------------------------
theta <- list(pi=NULL, w=NULL, nu0=NULL, nu=NULL)

## -----------------------------------------------------------------------------
 Q <- 2

## -----------------------------------------------------------------------------
theta$pi <- c(2,1)/3

## -----------------------------------------------------------------------------
theta$w <-c(.8,.1,.9)

## -----------------------------------------------------------------------------
theta$nu0 <- c(0,1)

## -----------------------------------------------------------------------------
theta$nu <- array(0, dim = c(Q*(Q+1)/2, 2))
theta$nu[,1] <- c(4,4,4)
theta$nu[,2]<-c(1,1,1)
theta$nu

## -----------------------------------------------------------------------------
p=10
obs <- rnsbm(p, theta)

## -----------------------------------------------------------------------------
round(obs$dataMatrix, digits = 2)

## -----------------------------------------------------------------------------
obs$latentAdj

## -----------------------------------------------------------------------------
obs$latentZ

## -----------------------------------------------------------------------------
library(igraph)
G=igraph::graph_from_adjacency_matrix(obs$latentAdj)
igraph::plot.igraph(G, vertex.size=5, vertex.dist=4, vertex.label=NA, vertex.color=obs$latentZ, edge.arrow.mode=0) 

## -----------------------------------------------------------------------------
plotGraphs(obs$dataMatrix, binaryTruth=obs$latentAdj)

## -----------------------------------------------------------------------------
p=30
obs <- rnsbm(p, theta)
X=obs$dataMatrix

## -----------------------------------------------------------------------------
res1 <- main_noisySBM(X, Qup=10, alpha=0.1,nbCores=1)

## -----------------------------------------------------------------------------
res1$theta

## -----------------------------------------------------------------------------
res1$Z
res1$Q

## -----------------------------------------------------------------------------
res1$A

## -----------------------------------------------------------------------------
plotGraphs(dataMatrix= X, binaryTruth=obs$latentAdj, inferredGraph= res1$A)

## -----------------------------------------------------------------------------
ARI(res1$Z, obs$latentZ)

## -----------------------------------------------------------------------------
res2 <- main_noisySBM(X,NIG=TRUE, Qup=10, alpha=0.1,nbCores=1)

## -----------------------------------------------------------------------------
res2$Q
res2$Z

## -----------------------------------------------------------------------------
res2$theta

## -----------------------------------------------------------------------------
ARI(res2$Z, obs$latentZ)

## -----------------------------------------------------------------------------
plotGraphs(dataMatrix= X, binaryTruth=obs$latentAdj, inferredGraph= res2$A)

## -----------------------------------------------------------------------------
c("Ren","Jankova_NW","Jankova_GL","Liu_SL","Liu_L","zTransform")

## -----------------------------------------------------------------------------
X=GGMtest$dataMatrix

## -----------------------------------------------------------------------------
resGGM <- main_noisySBM_GGM(X,Meth="Ren",NIG=FALSE, Qup=10, alpha=0.1,nbCores=1)

## -----------------------------------------------------------------------------
resGGM$A

## -----------------------------------------------------------------------------
Gggm=igraph::graph_from_adjacency_matrix(resGGM$A)
igraph::plot.igraph(Gggm, vertex.size=5, vertex.dist=4, vertex.label=NA, edge.arrow.mode=0) 

