## ----include = FALSE----------------------------------------------------------
source("common.R")

## -----------------------------------------------------------------------------
library(orderly)

## ----include = FALSE----------------------------------------------------------
path <- tempfile()
orderly_init(path)

fs::dir_create(file.path(path, "src", "data"))
write.csv(data.frame(x = 1:10, y = 1:10 + rnorm(10)),
          file.path(path, "src", "data", "data.csv"),
          row.names = FALSE)
writeLines(c(
  'd <- read.csv("data.csv")',
  "d$z <- resid(lm(y ~ x, d))",
  'saveRDS(d, "data.rds")'),
  file.path(path, "src", "data", "data.R"))
orderly_run("data", root = path)

fs::dir_create(file.path(path, "src", "analysis"))
writeLines(c(
  'orderly_dependency("data", "latest()", "data.rds")',
  'd <- readRDS("data.rds")',
  'png("analysis.png")',
  "plot(y ~ x, d)",
  "dev.off()"),
  file.path(path, "src", "analysis", "analysis.R"))

## ----echo = FALSE-------------------------------------------------------------
dir_tree(file.path(path), "src")

## ----echo = FALSE, results = "asis"-------------------------------------------
r_output(readLines(file.path(path, "src/analysis/analysis.R")))

## ----orderly_root = path------------------------------------------------------
id1 <- orderly_run("data")
id2 <- orderly_run("analysis")

## ----orderly_root = path------------------------------------------------------
orderly_metadata(id2)$depends

## ----include = FALSE----------------------------------------------------------
path <- tempfile()
orderly_init(path)

fs::dir_create(file.path(path, "src", "data"))
writeLines(c(
  "pars <- orderly_parameters(cyl = NULL)",
  "d <- mtcars[mtcars$cyl == pars$cyl, ]",
  'saveRDS(d, "data.rds")'),
  file.path(path, "src", "data", "data.R"))

fs::dir_create(file.path(path, "src", "analysis"))
writeLines(c(
  "pars <- orderly_parameters(cyl = NULL)",
  "orderly_dependency(",
  '  "data",',
  '  "latest(parameter:cyl == this:cyl)",',
  '  "data.rds")',
  'd <- readRDS("data.rds")',
  'png("analysis.png")',
  "plot(mpg ~ disp, d)",
  "dev.off()"),
  file.path(path, "src", "analysis", "analysis.R"))

## ----echo = FALSE-------------------------------------------------------------
dir_tree(file.path(path), "src")

## ----echo = FALSE, results = "asis"-------------------------------------------
r_output(readLines(file.path(path, "src/data/data.R")))

## ----orderly_root = path------------------------------------------------------
orderly_run("data", list(cyl = 4))
orderly_run("data", list(cyl = 6))
orderly_run("data", list(cyl = 8))

## ----echo = FALSE, results = "asis"-------------------------------------------
r_output(readLines(file.path(path, "src/analysis/analysis.R")))

## ----orderly_root = path------------------------------------------------------
orderly_run("analysis", list(cyl = 4))

## -----------------------------------------------------------------------------
rlang::last_error()$explanation

## ----orderly_root = path------------------------------------------------------
orderly_query_explain(
  quote(latest(parameter:cyl == 9000)), name = "data")

## ----orderly_root = path------------------------------------------------------
explanation <- orderly_query_explain(
  quote(latest(parameter:cyl == 9000)), name = "data")
explanation$parts$B

## ----orderly_root = path------------------------------------------------------
orderly_metadata_extract(
  name = "data",
  extract = c(cyl = "parameters.cyl is number"))

