/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util;

import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;

public final class ObjectUID
implements Serializable {
    private static final long serialVersionUID = -1843127436096725989L;
    private long time = -1L;
    private double random = -1.0;

    public static ObjectUID getNewObjectUID() {
        ObjectUID objectUID = new ObjectUID();
        objectUID.time = new Date().getTime();
        objectUID.random = Math.random();
        return objectUID;
    }

    public Object clone() {
        ObjectUID objectUID = new ObjectUID();
        objectUID.time = this.time;
        objectUID.random = this.random;
        return objectUID;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object.getClass().equals(ObjectUID.class)) {
            ObjectUID objectUID = (ObjectUID)object;
            bl = objectUID.time == this.time && objectUID.random == this.random;
        }
        return bl;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.random);
        return (int)(l ^ l >> 32);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Long.toHexString(this.time));
        stringBuffer.append("_");
        stringBuffer.append(Long.toHexString(Double.doubleToLongBits(this.random)));
        return stringBuffer.toString();
    }

    public static ObjectUID fromStringToObjectUID(String string) {
        ObjectUID objectUID = new ObjectUID();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_", false);
        objectUID.time = Long.parseLong(stringTokenizer.nextToken(), 16);
        objectUID.random = Double.longBitsToDouble(Long.parseLong(stringTokenizer.nextToken(), 16));
        return objectUID;
    }

    public static ObjectUID fromLongStringToObjectUID(String string) {
        ObjectUID objectUID = new ObjectUID();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_", false);
        objectUID.time = Long.parseLong(stringTokenizer.nextToken(), 10);
        objectUID.random = Long.parseLong(stringTokenizer.nextToken(), 10);
        return objectUID;
    }

    public double getRandom() {
        return this.random;
    }

    public long getTime() {
        return this.time;
    }

    public void setRandom(double d) {
        this.random = d;
    }

    public void setTime(long l) {
        this.time = l;
    }
}

