/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.resources.IconUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;

public class ChoiceButton
extends JButton {
    private AbstractAction[] mSubActions;
    private AbstractAction mDefaultAction;
    private boolean mChoiceRolledOver = false;
    private int mArrowWidth;
    private Icon mIcon;
    private Icon mRolledIcon;

    public ChoiceButton(Icon icon, String string, AbstractAction[] abstractActionArray, AbstractAction abstractAction) {
        super(string, icon);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.mSubActions = abstractActionArray;
        this.mDefaultAction = abstractAction;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.mIcon = this.getMergedIcons(icon, string, "resources/util/images/arrow_right.gif");
        this.mRolledIcon = this.getMergedIcons(icon, string, "resources/util/images/arrow_rolled.gif");
        this.setIcon(this.mIcon);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Graphics graphics;
                boolean bl = ChoiceButton.this.isArrowRolledOver(mouseEvent);
                if (ChoiceButton.this.mChoiceRolledOver != bl && (graphics = ChoiceButton.this.getGraphics()) != null) {
                    ChoiceButton.this.setIcon(bl ? ChoiceButton.this.mRolledIcon : ChoiceButton.this.mIcon);
                    ChoiceButton.this.mChoiceRolledOver = bl;
                    ChoiceButton.this.paintComponent(graphics);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Graphics graphics = ChoiceButton.this.getGraphics();
                if (graphics != null) {
                    ChoiceButton.this.mChoiceRolledOver = false;
                    ChoiceButton.this.setIcon(ChoiceButton.this.mIcon);
                    ChoiceButton.this.paintComponent(graphics);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (ChoiceButton.this.mDefaultAction.isEnabled()) {
                    Dimension dimension = ChoiceButton.this.getSize();
                    if (ChoiceButton.this.isArrowRolledOver(mouseEvent) && ChoiceButton.this.mSubActions != null) {
                        mouseEvent.setSource(ChoiceButton.this);
                        int n = ChoiceButton.this.getPreferredSize().width;
                        ChoiceButton.this.showPopup(ChoiceButton.this.getPopupMenu(), mouseEvent, n, 0);
                    } else {
                        ActionEvent actionEvent = new ActionEvent(ChoiceButton.this, 0, "");
                        ChoiceButton.this.mDefaultAction.actionPerformed(actionEvent);
                    }
                } else {
                    mouseEvent.setSource(ChoiceButton.this);
                    int n = ChoiceButton.this.getPreferredSize().width;
                    ChoiceButton.this.showPopup(ChoiceButton.this.getPopupMenu(), mouseEvent, n, 0);
                }
            }
        });
        for (int i = 0; i < abstractActionArray.length; ++i) {
            abstractActionArray[i].addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ChoiceButton.this.updateDefaultButton();
                }
            });
        }
    }

    private void showPopup(JPopupMenu jPopupMenu, MouseEvent mouseEvent, int n, int n2) {
        Component component = mouseEvent.getComponent();
        Dimension dimension = jPopupMenu.getPreferredSize();
        dimension.width = Math.max(dimension.width, n);
        jPopupMenu.setPreferredSize(dimension);
        jPopupMenu.show(component, n2, component.getSize().height);
    }

    private boolean isArrowRolledOver(MouseEvent mouseEvent) {
        boolean bl = false;
        Icon icon = this.getIcon();
        int n = icon.getIconWidth();
        Dimension dimension = this.getSize();
        int n2 = (dimension.width - n) / 2;
        bl = mouseEvent.getX() > dimension.width - n2 - this.mArrowWidth && this.isEnabled();
        return bl;
    }

    private Icon getMergedIcons(Icon icon, String string, String string2) {
        ImageIcon imageIcon = new ImageIcon(IconUtilities.getImage(string2));
        this.mArrowWidth = imageIcon.getIconWidth();
        int n = Math.max(this.getFontMetrics(this.getFont()).stringWidth(string), icon.getIconWidth());
        int n2 = n + this.mArrowWidth;
        int n3 = (n - icon.getIconWidth()) / 2;
        int n4 = Math.max(icon.getIconHeight(), imageIcon.getIconHeight());
        BufferedImage bufferedImage = new BufferedImage(n2, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(this, graphics2D, n3, (n4 - icon.getIconHeight()) / 2);
        imageIcon.paintIcon(this, graphics2D, n2 - imageIcon.getIconWidth(), (n4 - imageIcon.getIconHeight()) / 2);
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
        return imageIcon2;
    }

    private void updateDefaultButton() {
        boolean bl = true;
        for (int i = 0; bl && i < this.mSubActions.length; ++i) {
            if (!this.mSubActions[i].isEnabled()) continue;
            bl = false;
        }
        this.setEnabled(!bl);
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu(this.getText());
        jPopupMenu.setLightWeightPopupEnabled(false);
        if (this.mSubActions != null) {
            for (int i = 0; i < this.mSubActions.length; ++i) {
                jPopupMenu.add(this.mSubActions[i]);
            }
        }
        return jPopupMenu;
    }

    public JButton getMainButton() {
        return this;
    }

    public AbstractAction[] getSubActions() {
        return this.mSubActions;
    }
}

