/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcgregor;

import java.util.List;
import java.util.Objects;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcgregor.McGregorChecks;

@Deprecated
public class TargetProcessor {
    private final List<String> cTab1Copy;
    private final List<String> cTab2Copy;
    private final String[] signArray;
    private int neighborBondNumB;
    private int setBondNumB;
    private final List<Integer> iBondNeighborsB;
    private final List<String> cBondNeighborsB;
    private final int newNeighborNumA;
    private final List<Integer> newINeighborsA;
    private final List<String> newCNeighborsA;

    protected TargetProcessor(List<String> cTab1Copy, List<String> cTab2Copy, String[] signArray, int neighborBondnumB, int setBondnumB, List<Integer> iBondNeighborsB, List<String> cBondNeighborsB, int newNeighborNumA, List<Integer> newINeighborsA, List<String> newCNeighborsA) {
        this.cTab1Copy = cTab1Copy;
        this.cTab2Copy = cTab2Copy;
        this.signArray = signArray;
        this.neighborBondNumB = neighborBondnumB;
        this.setBondNumB = setBondnumB;
        this.iBondNeighborsB = iBondNeighborsB;
        this.cBondNeighborsB = cBondNeighborsB;
        this.newNeighborNumA = newNeighborNumA;
        this.newCNeighborsA = newCNeighborsA;
        this.newINeighborsA = newINeighborsA;
    }

    protected void process(IAtomContainer target, List<Integer> unmappedAtomsMolB, int mappingSize, List<Integer> iBondSetB, List<String> cBondSetB, List<Integer> mappedAtoms, int counter) {
        int unmappedNumB = unmappedAtomsMolB.size();
        boolean bondConsidered = false;
        boolean normalBond = true;
        for (int atomIndex = 0; atomIndex < target.getBondCount(); ++atomIndex) {
            Integer indexI = target.indexOf(target.getBond(atomIndex).getBegin());
            Integer indexJ = target.indexOf(target.getBond(atomIndex).getEnd());
            Integer order = target.getBond(atomIndex).getOrder().numeric();
            for (Integer integer : unmappedAtomsMolB) {
                if (integer.equals(indexI)) {
                    normalBond = this.unMappedAtomsEqualsIndexI(target, mappingSize, atomIndex, counter, mappedAtoms, indexI, indexJ, order);
                    bondConsidered = true;
                } else if (Objects.equals(integer, indexJ)) {
                    normalBond = this.unMappedAtomsEqualsIndexJ(target, mappingSize, atomIndex, counter, mappedAtoms, indexI, indexJ, order);
                    bondConsidered = true;
                }
                if (!normalBond || !bondConsidered) continue;
                this.markNormalBonds(atomIndex, iBondSetB, cBondSetB, indexI, indexJ, order);
                normalBond = true;
                break;
            }
            bondConsidered = false;
        }
    }

    protected void process(int setNumB, List<Integer> unmappedAtomsMolB, int newMappingSize, List<Integer> iBondSetB, List<String> cBondSetB, List<Integer> newMapping, int counter, List<Integer> newIBondSetB, List<String> newCBondSetB) {
        boolean bondConsidered = false;
        boolean normalBond = true;
        for (int atomIndex = 0; atomIndex < setNumB; ++atomIndex) {
            Integer indexI = iBondSetB.get(atomIndex * 3 + 0);
            Integer indexJ = iBondSetB.get(atomIndex * 3 + 1);
            Integer order = iBondSetB.get(atomIndex * 3 + 2);
            for (Integer unMappedAtomIndex : unmappedAtomsMolB) {
                if (unMappedAtomIndex.equals(indexI)) {
                    normalBond = this.unMappedAtomsEqualsIndexI(setNumB, iBondSetB, newMappingSize, atomIndex, counter, newMapping, indexI, indexJ, order);
                    bondConsidered = true;
                } else if (unMappedAtomIndex.equals(indexJ)) {
                    normalBond = this.unMappedAtomsEqualsIndexJ(setNumB, iBondSetB, newMappingSize, atomIndex, counter, newMapping, indexI, indexJ, order);
                    bondConsidered = true;
                }
                if (!normalBond || !bondConsidered) continue;
                this.markNormalBonds(atomIndex, newIBondSetB, newCBondSetB, indexI, indexJ, order);
                normalBond = true;
                break;
            }
            bondConsidered = false;
        }
    }

    private boolean unMappedAtomsEqualsIndexI(IAtomContainer target, int mappingSize, int atomIndex, int counter, List<Integer> mappedAtoms, Integer indexI, Integer indexJ, Integer order) {
        boolean normalBond = true;
        for (int c = 0; c < mappingSize; ++c) {
            if (!mappedAtoms.get(c * 2 + 1).equals(indexJ)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab2Copy.get(atomIndex * 4 + 3).compareToIgnoreCase("X") == 0) {
                this.step1(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexJ, this.signArray[counter], target.getBondCount(), target, this.cTab2Copy);
                int corAtom = McGregorChecks.searchCorrespondingAtom(mappingSize, indexJ, 2, mappedAtoms);
                McGregorChecks.changeCharBonds(corAtom, this.signArray[counter], this.newNeighborNumA, this.newINeighborsA, this.newCNeighborsA);
                ++counter;
            } else {
                this.step2(atomIndex);
            }
            normalBond = false;
            ++this.neighborBondNumB;
        }
        return normalBond;
    }

    private boolean unMappedAtomsEqualsIndexJ(IAtomContainer target, int mappingSize, int atomIndex, int counter, List<Integer> mappedAtoms, Integer indexI, Integer indexJ, Integer order) {
        boolean normalBond = true;
        for (int c = 0; c < mappingSize; ++c) {
            if (!mappedAtoms.get(c * 2 + 1).equals(indexI)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab2Copy.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                this.step3(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexI, this.signArray[counter], target.getBondCount(), target, this.cTab2Copy);
                int corAtom = McGregorChecks.searchCorrespondingAtom(mappingSize, indexI, 2, mappedAtoms);
                McGregorChecks.changeCharBonds(corAtom, this.signArray[counter], this.newNeighborNumA, this.newINeighborsA, this.newCNeighborsA);
                ++counter;
            } else {
                this.step4(atomIndex);
            }
            normalBond = false;
            ++this.neighborBondNumB;
        }
        return normalBond;
    }

    private boolean unMappedAtomsEqualsIndexI(int setNumB, List<Integer> iBondSetB, int newMappingSize, int atomIndex, int counter, List<Integer> newMapping, Integer indexI, Integer indexJ, Integer order) {
        boolean normalBond = true;
        for (int c = 0; c < newMappingSize; ++c) {
            if (!newMapping.get(c * 2 + 1).equals(indexJ)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab2Copy.get(atomIndex * 4 + 3).compareToIgnoreCase("X") == 0) {
                this.step1(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexJ, this.signArray[counter], setNumB, iBondSetB, this.cTab2Copy);
                int corAtom = McGregorChecks.searchCorrespondingAtom(newMappingSize, indexJ, 2, newMapping);
                McGregorChecks.changeCharBonds(corAtom, this.signArray[counter], this.newNeighborNumA, this.newINeighborsA, this.newCNeighborsA);
                ++counter;
            } else {
                this.step2(atomIndex);
            }
            normalBond = false;
            ++this.neighborBondNumB;
        }
        return normalBond;
    }

    private boolean unMappedAtomsEqualsIndexJ(int setNumB, List<Integer> iBondSetB, int newMappingSize, int atomIndex, int counter, List<Integer> newMapping, Integer indexI, Integer indexJ, Integer order) {
        boolean normalBond = true;
        for (int c = 0; c < newMappingSize; ++c) {
            if (!newMapping.get(c * 2 + 1).equals(indexI)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab2Copy.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                this.step3(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexI, this.signArray[counter], setNumB, iBondSetB, this.cTab2Copy);
                int corAtom = McGregorChecks.searchCorrespondingAtom(newMappingSize, indexI, 2, newMapping);
                McGregorChecks.changeCharBonds(corAtom, this.signArray[counter], this.newNeighborNumA, this.newINeighborsA, this.newCNeighborsA);
                ++counter;
            } else {
                this.step4(atomIndex);
            }
            normalBond = false;
            ++this.neighborBondNumB;
        }
        return normalBond;
    }

    private void markNormalBonds(int atomIndex, List<Integer> iBondSetB, List<String> cBondSetB, Integer indexI, Integer indexJ, Integer order) {
        iBondSetB.add(indexI);
        iBondSetB.add(indexJ);
        iBondSetB.add(order);
        cBondSetB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        cBondSetB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
        cBondSetB.add("X");
        cBondSetB.add("X");
        ++this.setBondNumB;
    }

    private void setBondNeighbors(Integer indexI, Integer indexJ, Integer order) {
        this.iBondNeighborsB.add(indexI);
        this.iBondNeighborsB.add(indexJ);
        this.iBondNeighborsB.add(order);
    }

    private void step1(int atomIndex, int counter) {
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsB.add(this.signArray[counter]);
        this.cBondNeighborsB.add("X");
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
    }

    private void step2(int atomIndex) {
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsB.add("X");
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 3));
    }

    private void step3(int atomIndex, int counter) {
        this.cBondNeighborsB.add(this.signArray[counter]);
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsB.add("X");
    }

    private void step4(int atomIndex) {
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsB.add(this.cTab2Copy.get(atomIndex * 4 + 2));
        this.cBondNeighborsB.add("X");
    }

    protected List<String> getCTab1() {
        return this.cTab1Copy;
    }

    protected List<String> getCTab2() {
        return this.cTab2Copy;
    }

    protected int getNeighborBondNumB() {
        return this.neighborBondNumB;
    }

    protected int getBondNumB() {
        return this.setBondNumB;
    }

    List<Integer> getIBondNeighboursB() {
        return this.iBondNeighborsB;
    }

    List<String> getCBondNeighborsB() {
        return this.cBondNeighborsB;
    }
}

