/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.silent.AtomContainerSet;
import org.openscience.cdk.silent.Ring;

public class RingSet
extends AtomContainerSet
implements Serializable,
IRingSet,
Cloneable {
    private static final long serialVersionUID = 7168431521057961434L;
    public static final int LARGE_FIRST = 1;
    public static final int SMALL_FIRST = 2;

    public IRingSet getRings(IBond bond) {
        IRingSet rings = (IRingSet)bond.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (int i = 0; i < this.getAtomContainerCount(); ++i) {
            Ring ring = (Ring)this.getAtomContainer(i);
            if (!ring.contains(bond)) continue;
            rings.addAtomContainer((IAtomContainer)ring);
        }
        return rings;
    }

    public IRingSet getRings(IAtom atom) {
        RingSet rings = new RingSet();
        for (int i = 0; i < this.getAtomContainerCount(); ++i) {
            Ring ring = (Ring)this.getAtomContainer(i);
            if (!ring.contains(atom)) continue;
            rings.addAtomContainer(ring);
        }
        return rings;
    }

    public IRingSet getConnectedRings(IRing ring) {
        IRingSet connectedRings = (IRingSet)ring.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (int i = 0; i < ring.getAtomCount(); ++i) {
            IAtom atom = ring.getAtom(i);
            for (int j = 0; j < this.getAtomContainerCount(); ++j) {
                IRing tempRing = (IRing)this.getAtomContainer(j);
                if (tempRing == ring || connectedRings.contains((IAtomContainer)tempRing) || !tempRing.contains(atom)) continue;
                connectedRings.addAtomContainer((IAtomContainer)tempRing);
            }
        }
        return connectedRings;
    }

    public void add(IRingSet ringSet) {
        for (int f = 0; f < ringSet.getAtomContainerCount(); ++f) {
            if (this.contains(ringSet.getAtomContainer(f))) continue;
            this.addAtomContainer(ringSet.getAtomContainer(f));
        }
    }

    public boolean contains(IAtom atom) {
        for (int i = 0; i < this.getAtomContainerCount(); ++i) {
            if (!this.getAtomContainer(i).contains(atom)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IAtomContainer ring) {
        for (int i = 0; i < this.getAtomContainerCount(); ++i) {
            if (ring != this.getAtomContainer(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append("RingSet(");
        buffer.append(this.hashCode());
        if (this.getAtomContainerCount() > 0) {
            buffer.append(", R=").append(this.getAtomContainerCount()).append(", ");
            for (int i = 0; i < this.atomContainerCount; ++i) {
                IRing possibleRing = (IRing)this.atomContainers[i];
                buffer.append(possibleRing.toString());
                if (i + 1 >= this.atomContainerCount) continue;
                buffer.append(", ");
            }
        }
        buffer.append(')');
        return buffer.toString();
    }
}

