/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.hybrid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.extension.hybrid.ISupportable;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class HybridTuples {
    protected final List<ISupportable[]> hybridTuples = new ArrayList<ISupportable[]>();
    private int arity;

    public void add(ISupportable ... tuple) {
        if (this.hybridTuples.size() == 0) {
            this.arity = tuple.length;
        } else if (this.arity != tuple.length) {
            throw new SolverException("The given tuple does not match the arity: " + this.arity);
        }
        this.hybridTuples.add(this.convert(tuple));
    }

    private ISupportable[] convert(ISupportable[] tuple) {
        int i;
        ArrayList[] t = new ArrayList[tuple.length];
        for (i = 0; i < tuple.length; ++i) {
            t[i] = new ArrayList();
        }
        for (i = 0; i < tuple.length; ++i) {
            ISupportable.Nary h;
            t[i].add(tuple[i]);
            if (!(tuple[i] instanceof ISupportable.UnCol)) continue;
            ISupportable.UnCol col = (ISupportable.UnCol)tuple[i];
            switch (col.op) {
                case EQ: {
                    h = new ISupportable.NaEqXYC(i, col.anInt, col.inc);
                    break;
                }
                case NQ: {
                    h = new ISupportable.NaNqXYC(i, col.anInt, col.inc);
                    break;
                }
                case LE: {
                    h = new ISupportable.NaLqXYC(i, col.anInt, col.inc);
                    break;
                }
                case GE: {
                    h = new ISupportable.NaGqXYC(i, col.anInt, col.inc);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            t[i].remove(t[i].size() - 1);
            t[i].add(h);
            t[col.anInt].add(h);
        }
        for (i = 0; i < t.length; ++i) {
            if (t[i].size() <= 1) continue;
            ISupportable.Many m = ISupportable.Many.merge((ISupportable)t[i].get(0), (ISupportable)t[i].get(1));
            for (int j = 2; j < t[i].size(); ++j) {
                m = ISupportable.Many.merge(m, (ISupportable)t[i].get(j));
            }
            t[i].clear();
            t[i].add(m);
        }
        return (ISupportable[])Arrays.stream(t).map(l -> (ISupportable)l.get(0)).toArray(ISupportable[]::new);
    }

    public void add(ISupportable[] ... tuples) {
        for (ISupportable[] tuple : tuples) {
            this.add(tuple);
        }
    }

    public ISupportable[][] toArray() {
        return (ISupportable[][])this.hybridTuples.toArray((T[])new ISupportable[0][0]);
    }

    public int arity() {
        return this.hybridTuples.get(0).length;
    }

    public int nbTuples() {
        return this.hybridTuples.size();
    }

    public static ISupportable any() {
        return new ISupportable.UnAny();
    }

    public static ISupportable.UnCol col(int idx) {
        return new ISupportable.UnCol(idx, 0, Operator.EQ);
    }

    public static ISupportable eq(int val) {
        return new ISupportable.UnEqXC(val);
    }

    public static ISupportable ne(int val) {
        return new ISupportable.UnNqXC(val);
    }

    public static ISupportable ge(int val) {
        return new ISupportable.UnGqXC(val);
    }

    public static ISupportable gt(int val) {
        return new ISupportable.UnGqXC(val + 1);
    }

    public static ISupportable le(int val) {
        return new ISupportable.UnLqXC(val);
    }

    public static ISupportable lt(int val) {
        return new ISupportable.UnLqXC(val - 1);
    }

    public static ISupportable in(int ... values) {
        IntIterableRangeSet set = new IntIterableRangeSet(values);
        return new ISupportable.UnXInS(set);
    }

    public static ISupportable nin(int ... values) {
        IntIterableRangeSet set = new IntIterableRangeSet(values);
        set.flip();
        return new ISupportable.UnXInS(set);
    }

    public static ISupportable eq(ISupportable.UnCol col, int inc) {
        ISupportable.UnCol copy = col.copy();
        copy.op(Operator.EQ);
        copy.add(inc);
        return copy;
    }

    public static ISupportable ne(ISupportable.UnCol col) {
        return HybridTuples.ne(col, 0);
    }

    public static ISupportable ne(ISupportable.UnCol col, int inc) {
        ISupportable.UnCol copy = col.copy();
        copy.op(Operator.NQ);
        copy.add(inc);
        return copy;
    }

    public static ISupportable ge(ISupportable.UnCol col) {
        return HybridTuples.ge(col, 0);
    }

    public static ISupportable ge(ISupportable.UnCol col, int inc) {
        ISupportable.UnCol copy = col.copy();
        copy.op(Operator.GE);
        copy.add(inc);
        return copy;
    }

    public static ISupportable gt(ISupportable.UnCol col) {
        return HybridTuples.ge(col, 1);
    }

    public static ISupportable gt(ISupportable.UnCol col, int inc) {
        return HybridTuples.ge(col, inc + 1);
    }

    public static ISupportable le(ISupportable.UnCol col) {
        return HybridTuples.le(col, 0);
    }

    public static ISupportable le(ISupportable.UnCol col, int inc) {
        ISupportable.UnCol copy = col.copy();
        copy.op(Operator.LE);
        copy.add(inc);
        return copy;
    }

    public static ISupportable lt(ISupportable.UnCol col) {
        return HybridTuples.le(col, -1);
    }

    public static ISupportable lt(ISupportable.UnCol col, int inc) {
        return HybridTuples.le(col, inc - 1);
    }
}

