/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import java.io.Serializable;

public class Range
implements Serializable {
    private int start = 0;
    private int end = 0;
    private int upperLimit = 0;
    private final String rangeText;

    public Range(String range) {
        this.rangeText = range;
    }

    public void setRange(String range) {
        String single = range.trim();
        int hyphenIndex = range.indexOf(45);
        if (hyphenIndex > 0) {
            this.start = this.rangeSingle(range.substring(0, hyphenIndex));
            this.end = this.rangeSingle(range.substring(hyphenIndex + 1));
        } else {
            int number = this.rangeSingle(range);
            if (number >= 0) {
                this.start = 0;
                this.end = number;
            } else {
                this.start = this.upperLimit + number > 0 ? this.upperLimit + number : 0;
                this.end = this.upperLimit - 1;
            }
        }
    }

    protected int rangeSingle(String singleSelection) {
        String single = singleSelection.trim();
        if (single.toLowerCase().equals("first")) {
            return 0;
        }
        if (single.toLowerCase().equals("last") || single.toLowerCase().equals("-1")) {
            return -1;
        }
        int index = Integer.parseInt(single);
        if (index >= 1) {
            --index;
        }
        return index;
    }

    boolean isInRange(int value) {
        boolean ret = false;
        if (value >= this.start && value <= this.end) {
            ret = true;
        }
        return ret;
    }

    int getSelectionLength() {
        return this.end - this.start + 1;
    }

    public void setUpper(int attributeNumber) {
        this.upperLimit = attributeNumber;
        this.setRange(this.rangeText);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }
}

