/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import moa.cluster.SphereCluster;
import moa.clusterers.outliers.MyBaseOutlierDetector;
import moa.gui.visualization.ClusterPanel;
import moa.gui.visualization.DataPoint;
import moa.gui.visualization.OutlierEvent;
import moa.gui.visualization.OutlierPanel;
import moa.gui.visualization.RunOutlierVisualizer;
import moa.gui.visualization.StreamPanel;

public class StreamOutlierPanel
extends JPanel
implements ComponentListener {
    private OutlierPanel highlighted_outlier = null;
    private double zoom_factor = 0.2;
    private int zoom = 1;
    private int width_org;
    private int height_org;
    private int activeXDim = 0;
    private int activeYDim = 1;
    private JPanel layerOutliers;
    private LabelAlgorithmPanel layerAlgorithmTitle;
    private RunOutlierVisualizer m_visualizer = null;
    private MyBaseOutlierDetector m_outlierDetector = null;
    private BufferedImage pointImg;
    private BufferedImage canvasImg;
    private ImgPanel layerCanvas;
    private boolean bAntiAlias = false;
    private int EVENTSIZE = 10;

    public StreamOutlierPanel(Color colorAlgorithmTitle) {
        this.initComponents();
        this.layerAlgorithmTitle = new LabelAlgorithmPanel();
        this.layerAlgorithmTitle.color = colorAlgorithmTitle;
        this.add(this.layerAlgorithmTitle);
        this.layerOutliers = this.getNewLayer();
        this.add(this.layerOutliers);
        this.layerCanvas = new ImgPanel();
        this.add(this.layerCanvas);
        this.addComponentListener(this);
    }

    private JPanel getNewLayer() {
        JPanel layer = new JPanel();
        layer.setOpaque(false);
        layer.setLayout(null);
        return layer;
    }

    public void drawOutliers(Vector<MyBaseOutlierDetector.Outlier> outliers, Color color) {
        this.drawOutliers(this.layerOutliers, outliers, color);
    }

    public void repaintOutliers() {
        this.layerOutliers.repaint();
    }

    public void setOutliersVisibility(boolean visibility) {
        this.layerOutliers.setVisible(visibility);
        this.layerOutliers.repaint();
    }

    public void setPointsVisibility(boolean visibility) {
        this.layerCanvas.setVisible(visibility);
        this.layerCanvas.repaint();
    }

    public void clearPoints() {
        Graphics2D imageGraphics = this.pointImg.createGraphics();
        imageGraphics.setColor(Color.WHITE);
        imageGraphics.setPaint(Color.WHITE);
        imageGraphics.fill(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        this.ApplyToCanvas(this.pointImg);
        this.RedrawPointLayer();
    }

    public void clearEvents() {
        this.ApplyToCanvas(this.pointImg);
    }

    public void ApplyToCanvas(BufferedImage img) {
        Graphics2D g = this.canvasImg.createGraphics();
        g.drawImage((Image)img, 0, 0, this);
    }

    public void RedrawPointLayer() {
        this.layerCanvas.setImage(this.canvasImg);
        this.layerCanvas.repaint();
    }

    private void drawPoint(DataPoint point, boolean bShowDecay, Color c, boolean bFill, boolean bRedrawPointImg) {
        Graphics2D imageGraphics = this.pointImg.createGraphics();
        if (this.bAntiAlias) {
            imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int size = Math.min(this.getWidth(), this.getHeight());
        int x = (int)Math.round(point.value(this.getActiveXDim()) * (double)size);
        int y = (int)Math.round(point.value(this.getActiveYDim()) * (double)size);
        if (c == null) {
            c = Color.GRAY;
        }
        if (bShowDecay) {
            int minValue = 40;
            double w = point.weight();
            int alpha = (int)(255.0 * w + (double)minValue);
            if (alpha > 255) {
                alpha = 255;
            }
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        imageGraphics.setColor(c);
        int psize = 4;
        int poffset = 2;
        imageGraphics.drawOval(x - poffset, y - poffset, psize, psize);
        if (bFill) {
            imageGraphics.fillOval(x - poffset, y - poffset, psize, psize);
        }
        if (bRedrawPointImg) {
            this.ApplyToCanvas(this.pointImg);
            this.RedrawPointLayer();
        }
    }

    public void drawPoint(DataPoint point, boolean bShowDecay, boolean bRedrawPointImg) {
        this.drawPoint(point, bShowDecay, null, true, bRedrawPointImg);
    }

    public void drawEvent(OutlierEvent outlierEvent, boolean bRedrawPointImg) {
        Graphics2D imageGraphics = this.canvasImg.createGraphics();
        if (this.bAntiAlias) {
            imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int size = Math.min(this.getWidth(), this.getHeight());
        int x = (int)Math.round(outlierEvent.point.value(this.getActiveXDim()) * (double)size);
        int y = (int)Math.round(outlierEvent.point.value(this.getActiveYDim()) * (double)size);
        Color c = outlierEvent.outlier ? Color.RED : Color.BLACK;
        imageGraphics.setColor(c);
        int psize = this.EVENTSIZE;
        int poffset = this.EVENTSIZE / 2;
        imageGraphics.drawOval(x - poffset, y - poffset, psize, psize);
        if (bRedrawPointImg) {
            this.RedrawPointLayer();
        }
    }

    public void applyDrawDecay(float factor, boolean bRedrawPointImg) {
        int v = Color.GRAY.getRed();
        RescaleOp brightenOp = new RescaleOp(1.0f, (float)(255 - v) * factor, null);
        this.pointImg = brightenOp.filter(this.pointImg, null);
        if (bRedrawPointImg) {
            this.ApplyToCanvas(this.pointImg);
            this.RedrawPointLayer();
        }
    }

    private void drawOutliers(JPanel layer, Vector<MyBaseOutlierDetector.Outlier> outliers, Color color) {
        layer.removeAll();
        for (MyBaseOutlierDetector.Outlier outlier : outliers) {
            int length = outlier.inst.numValues() - 1;
            double[] center = new double[length];
            for (int i = 0; i < length; ++i) {
                center[i] = outlier.inst.value(i);
            }
            SphereCluster cluster = new SphereCluster(center, 0.0);
            OutlierPanel outlierpanel = new OutlierPanel(this.m_outlierDetector, outlier, cluster, color, this);
            layer.add(outlierpanel);
            outlierpanel.updateLocation();
        }
        layer.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void screenshot(String filename, boolean svg, boolean png) {
        if (this.layerOutliers.getComponentCount() == 0) {
            return;
        }
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        if (png) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Graphics g = image.getGraphics();
                this.paintAll(g);
                try {
                    ImageIO.write((RenderedImage)image, "png", new File(filename + ".png"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (svg) {
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename + ".svg")));
                int width = 500;
                out.write("<?xml version=\"1.0\"?>\n");
                out.write("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
                out.write("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + width + "\" height=\"" + width + "\">\n");
                if (this.layerOutliers.isVisible()) {
                    for (Component comp : this.layerOutliers.getComponents()) {
                        if (!(comp instanceof ClusterPanel)) continue;
                        out.write(((ClusterPanel)comp).getSVGString(width));
                    }
                }
                out.write("</svg>");
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StreamPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public OutlierPanel getHighlightedOutlierPanel() {
        return this.highlighted_outlier;
    }

    public void setHighlightedOutlierPanel(OutlierPanel outlierpanel) {
        if (this.highlighted_outlier != null) {
            this.highlighted_outlier.highlight(false);
        }
        this.highlighted_outlier = outlierpanel;
        if (this.highlighted_outlier != null) {
            this.highlighted_outlier.highlight(true);
        }
        this.repaint();
    }

    public void setZoom(int x, int y, int zoom_delta, JScrollPane scrollPane) {
        if (this.zoom == 1) {
            this.width_org = this.getWidth();
            this.height_org = this.getHeight();
        }
        this.zoom += zoom_delta;
        if (this.zoom < 1) {
            this.zoom = 1;
        } else {
            int size = (int)((double)Math.min(this.width_org, this.height_org) * this.zoom_factor * (double)this.zoom);
            this.setSize(new Dimension(size * this.zoom, size * this.zoom));
            this.setPreferredSize(new Dimension(size * this.zoom, size * this.zoom));
            scrollPane.getViewport().setViewPosition(new Point((int)((double)x * this.zoom_factor * (double)this.zoom + (double)x), (int)((double)y * this.zoom_factor * (double)this.zoom + (double)y)));
        }
    }

    public int getActiveXDim() {
        return this.activeXDim;
    }

    public void setActiveXDim(int activeXDim) {
        this.activeXDim = activeXDim;
    }

    public int getActiveYDim() {
        return this.activeYDim;
    }

    public void setActiveYDim(int activeYDim) {
        this.activeYDim = activeYDim;
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StreamOutlierPanel.this.formMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMouseClicked(MouseEvent evt) {
        if (this.highlighted_outlier != null) {
            this.highlighted_outlier.highlight(false);
            this.highlighted_outlier = null;
        }
    }

    public void setVisualizer(RunOutlierVisualizer v) {
        this.m_visualizer = v;
    }

    public void setOutlierDetector(MyBaseOutlierDetector outlierDetector) {
        this.m_outlierDetector = outlierDetector;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int heightAlgorithmTitle = 2;
        int size = Math.min(this.getWidth(), this.getHeight() - heightAlgorithmTitle);
        this.layerOutliers.setBounds(0, heightAlgorithmTitle, size, size);
        this.layerAlgorithmTitle.setBounds(0, 0, this.getWidth(), heightAlgorithmTitle);
        this.pointImg = new BufferedImage(size, size, 1);
        this.canvasImg = new BufferedImage(size, size, 1);
        this.layerCanvas.setBounds(0, heightAlgorithmTitle, size, size);
        Graphics2D imageGraphics = (Graphics2D)this.pointImg.getGraphics();
        imageGraphics.setColor(Color.white);
        imageGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        imageGraphics.dispose();
        this.ApplyToCanvas(this.pointImg);
        this.RedrawPointLayer();
        if (this.m_visualizer != null) {
            this.m_visualizer.redrawOnResize();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    class LabelAlgorithmPanel
    extends JPanel {
        public Color color;

        public LabelAlgorithmPanel() {
            this.setOpaque(true);
            this.setLayout(null);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.color);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    class ImgPanel
    extends JPanel {
        public BufferedImage image = null;

        ImgPanel() {
        }

        public void setImage(BufferedImage image) {
            this.setSize(image.getWidth(), image.getWidth());
            this.image = image;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.image != null) {
                g2.drawImage(this.image, null, 0, 0);
            }
        }
    }
}

