/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.DrawSimpleShape;
import org.apache.poi.sl.draw.DrawTextParagraph;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.usermodel.Insets2D;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.TextShape;
import org.apache.poi.util.JvmBugs;

public class DrawTextShape
extends DrawSimpleShape {
    public DrawTextShape(TextShape<?, ?> shape) {
        super((SimpleShape<?, ?>)shape);
    }

    @Override
    public void drawContent(Graphics2D graphics) {
        DrawTextShape.fixFonts(graphics);
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.getShape());
        Insets2D insets = this.getShape().getInsets();
        double x = anchor.getX() + insets.left;
        double y = anchor.getY();
        AffineTransform tx = graphics.getTransform();
        if (this.getShape().getFlipVertical()) {
            graphics.translate(anchor.getX(), anchor.getY() + anchor.getHeight());
            graphics.scale(1.0, -1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            graphics.translate(centerX, centerY);
            graphics.rotate(Math.toRadians(180.0));
            graphics.translate(-centerX, -centerY);
        }
        if (this.getShape().getFlipHorizontal()) {
            graphics.translate(anchor.getX() + anchor.getWidth(), anchor.getY());
            graphics.scale(-1.0, 1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
        }
        double textHeight = this.getShape().getTextHeight();
        switch (this.getShape().getVerticalAlignment()) {
            case TOP: {
                y += insets.top;
                break;
            }
            case BOTTOM: {
                y += anchor.getHeight() - textHeight - insets.bottom;
                break;
            }
            default: {
                double delta = anchor.getHeight() - textHeight - insets.top - insets.bottom;
                y += insets.top + delta / 2.0;
            }
        }
        this.drawParagraphs(graphics, x, y);
        graphics.setTransform(tx);
    }

    public double drawParagraphs(Graphics2D graphics, double x, double y) {
        DrawFactory fact = DrawFactory.getInstance(graphics);
        double y0 = y;
        Iterator paragraphs = this.getShape().iterator();
        boolean isFirstLine = true;
        int autoNbrIdx = 0;
        while (paragraphs.hasNext()) {
            TextParagraph p = (TextParagraph)paragraphs.next();
            DrawTextParagraph dp = fact.getDrawable(p);
            TextParagraph.BulletStyle bs = p.getBulletStyle();
            if (bs == null || bs.getAutoNumberingScheme() == null) {
                autoNbrIdx = -1;
            } else {
                Integer startAt = bs.getAutoNumberingStartAt();
                if (startAt == null) {
                    startAt = 1;
                }
                if (startAt > autoNbrIdx) {
                    autoNbrIdx = startAt;
                }
            }
            dp.setAutoNumberingIdx(autoNbrIdx);
            dp.breakText(graphics);
            if (!isFirstLine) {
                Double spaceBefore = p.getSpaceBefore();
                if (spaceBefore == null) {
                    spaceBefore = 0.0;
                }
                y = spaceBefore > 0.0 ? (y += spaceBefore * 0.01 * (double)dp.getFirstLineHeight()) : (y += -spaceBefore.doubleValue());
            }
            isFirstLine = false;
            dp.setPosition(x, y);
            dp.draw(graphics);
            y += dp.getY();
            if (paragraphs.hasNext()) {
                Double spaceAfter = p.getSpaceAfter();
                if (spaceAfter == null) {
                    spaceAfter = 0.0;
                }
                y = spaceAfter > 0.0 ? (y += spaceAfter * 0.01 * (double)dp.getLastLineHeight()) : (y += -spaceAfter.doubleValue());
            }
            ++autoNbrIdx;
        }
        return y - y0;
    }

    public double getTextHeight() {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D graphics = img.createGraphics();
        DrawTextShape.fixFonts(graphics);
        return this.drawParagraphs(graphics, 0.0, 0.0);
    }

    private static void fixFonts(Graphics2D graphics) {
        if (!JvmBugs.hasLineBreakMeasurerBug()) {
            return;
        }
        HashMap<String, String> fontMap = (HashMap<String, String>)graphics.getRenderingHint(Drawable.FONT_MAP);
        if (fontMap == null) {
            fontMap = new HashMap<String, String>();
            graphics.setRenderingHint(Drawable.FONT_MAP, fontMap);
        }
        if (!fontMap.containsKey("Calibri")) {
            fontMap.put("Calibri", "Lucida Sans");
        }
        if (!fontMap.containsKey("Cambria")) {
            fontMap.put("Cambria", "Lucida Bright");
        }
    }

    @Override
    protected TextShape<?, ?> getShape() {
        return (TextShape)this.shape;
    }
}

