/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.parsers;

import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.MulSpeciesBindings;
import dr.evomodel.tree.TreeModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class MulSpeciesBindingsParser
extends AbstractXMLObjectParser {
    public static final String MUL_SPECIES = "mulSpecies";
    public static final String GENE_TREES = "geneTrees";
    public static final String GTREE = "gtree";
    public static final String POPFACTOR = "popfactor";
    ElementRule treeWithPopFactors = new ElementRule("gtree", new XMLSyntaxRule[]{AttributeRule.newDoubleRule("popfactor"), new ElementRule(TreeModel.class)}, 0, Integer.MAX_VALUE);

    @Override
    public String getParserName() {
        return MUL_SPECIES;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        ArrayList<AlloppSpeciesBindings.ApSpInfo> arrayList = new ArrayList<AlloppSpeciesBindings.ApSpInfo>();
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            Object object = xMLObject.getChild(i);
            if (!(object instanceof AlloppSpeciesBindings.ApSpInfo)) continue;
            arrayList.add((AlloppSpeciesBindings.ApSpInfo)object);
        }
        XMLObject xMLObject2 = xMLObject.getChild(GENE_TREES);
        int n = xMLObject2.getChildCount();
        TreeModel[] treeModelArray = new TreeModel[n];
        double[] dArray = new double[n];
        for (int i = 0; i < treeModelArray.length; ++i) {
            Object object = xMLObject2.getChild(i);
            if (!(object instanceof TreeModel)) {
                assert (object instanceof XMLObject);
                dArray[i] = ((XMLObject)object).getDoubleAttribute(POPFACTOR);
                object = ((XMLObject)object).getChild(TreeModel.class);
            } else {
                dArray[i] = -1.0;
            }
            treeModelArray[i] = (TreeModel)object;
        }
        try {
            return new MulSpeciesBindings(arrayList.toArray(new AlloppSpeciesBindings.ApSpInfo[arrayList.size()]), treeModelArray, dArray);
        }
        catch (Error error) {
            throw new XMLParseException(error.getMessage());
        }
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{new ElementRule(AlloppSpeciesBindings.ApSpInfo.class, 2, Integer.MAX_VALUE), new ElementRule(GENE_TREES, new XMLSyntaxRule[]{new ElementRule(TreeModel.class, 0, Integer.MAX_VALUE), this.treeWithPopFactors})};
    }

    @Override
    public String getParserDescription() {
        return "Binds taxa to gene trees with information about possibly allopolyploid species.";
    }

    @Override
    public Class getReturnType() {
        return MulSpeciesBindings.class;
    }
}

