## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.dim = c(6, 4)
)

## ----setup--------------------------------------------------------------------
library(EZbakR)

## -----------------------------------------------------------------------------
# Simulate data
simdata <- EZSimulate(nfeatures = 300, nreps = 2)

# Create an `EZbakRData` object
ezbdo <- EZbakRData(simdata$cB, simdata$metadf)

# Estimate fractions
ezbdo <- EstimateFractions(ezbdo)

# Estimate synthesis and degradation rate constants
ezbdo <- EstimateKinetics(ezbdo,
                          strategy = "standard")

## -----------------------------------------------------------------------------
# Create another fractions table
ezbdo2 <- EstimateFractions(ezbdo, overwrite = FALSE)

# Estimate synthesis and degradation rate constants
  # Use the 1st identical fractions table you created
ezbdo2 <- EstimateKinetics(ezbdo2,
                          repeatID = 1,
                          strategy = "standard")

## -----------------------------------------------------------------------------
# Estimate synthesis and degradation rate constants
ezbdo <- EstimateKinetics(ezbdo,
                          strategy = "shortfeed")

## -----------------------------------------------------------------------------
metadf <- data.frame(
  sample = c('sampleA',
             'sampleB',
             'sampleC'),
  tl = c(0, 2, 2),
  group = c("a", 
            "b", 
            "c"),
  reference = c("a",
                "a",
                "c")
)

## -----------------------------------------------------------------------------
# new metadf
metadf <- data.frame(sample = paste0('sample', 1:6),
                 tl = c(2, 2, 2, 2, 0, 0),
                 group = c('b', 'b',
                           'c', 'c',
                           'a', 'b'),
                 ref = c('a', 'a',
                         'b', 'b',
                         'a', 'a'))

# Create an `EZbakRData` object
ezbdo <- EZbakRData(simdata$cB, metadf)

# Estimate fractions
ezbdo <- EstimateFractions(ezbdo)

# Estimate synthesis and degradation rate constants
ezbdo <- EstimateKinetics(ezbdo,
                          strategy = "NSS",
                          grouping_factor = "group",
                          reference_factor = "ref")

