/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique;

import javalain.algorithmegenetique.Chromosome;
import javalain.algorithmegenetique.DomaineEntier;
import javalain.algorithmegenetique.Gene;
import javalain.algorithmegenetique.GeneComplexe;
import javalain.math.PseudoRandomNumbers;

public class ChromosomeVariable
extends Chromosome {
    private static final int PLUS = 2;
    public static final int GENE = 1;
    public static final int MELANGE = 16;
    public static final int CARACTERE = 257;
    private static final int SIMPLE = 17;
    private static final int COMPLEXE = 273;
    private int type;
    private Gene[] tabGene;
    private int nbGene;
    protected int modeCroisement;
    protected int modeMutation;
    public DomaineEntier lg;

    public ChromosomeVariable(Gene g, int mode_crois, DomaineEntier de) {
        this.lg = de;
        this.nbGene = (int)(PseudoRandomNumbers.random() * (double)de.getTaille()) + de.getMin();
        this.tabGene = new Gene[this.nbGene];
        for (int i = 0; i < this.nbGene; ++i) {
            this.tabGene[i] = g.creer();
        }
        this.type = g instanceof GeneComplexe ? 273 : 17;
        this.modeCroisement = mode_crois;
    }

    public void addGene(Gene ge) {
        if (this.nbGene != 0 && !this.tabGene[0].getClass().isInstance(ge)) {
            throw new IllegalArgumentException("ChromosomeVariable, addGene (Gene ge) : tous les genes doivent etre de meme type.");
        }
        int taille = this.tabGene.length;
        if (this.nbGene == taille) {
            int n_taille = taille * 3 / 2 + 1;
            Gene[] tab = this.tabGene;
            this.tabGene = new Gene[n_taille];
            System.arraycopy(tab, 0, this.tabGene, 0, taille);
        }
        this.tabGene[this.nbGene++] = ge;
    }

    public void addGene(int i, Gene ge) {
        int j;
        if (i >= this.nbGene || i < 0) {
            throw new IndexOutOfBoundsException("ChromosomeVariable, addGene (int i, Gene g) : indice 'i' hors des limites.");
        }
        if (this.nbGene != 0 && !this.tabGene[0].getClass().isInstance(ge)) {
            throw new IllegalArgumentException("ChromosomeVariable, addGene (int i, Gene g) : tous les genes doivent etre de meme type.");
        }
        int taille = this.tabGene.length;
        if (this.nbGene == taille) {
            int n_taille = taille * 3 / 2 + 1;
            Gene[] tab = this.tabGene;
            this.tabGene = new Gene[n_taille];
            for (j = 0; j < taille; ++j) {
                this.tabGene[j] = tab[j];
            }
        }
        for (j = this.nbGene; j > i; --j) {
            this.tabGene[j] = this.tabGene[j - 1];
        }
        this.tabGene[i] = ge;
        ++this.nbGene;
    }

    public Gene getGene(int i) {
        if (i >= this.nbGene || i < 0) {
            throw new IndexOutOfBoundsException("ChromosomeVariable, getGene (int i) : indice 'i' hors des limites.");
        }
        return this.tabGene[i];
    }

    public Gene removeGene(int i) {
        if (i >= this.nbGene || i < 0) {
            throw new IndexOutOfBoundsException("ChromosomeVariable, removeGene (int i) : indice 'i' hors des limites.");
        }
        Gene g = this.tabGene[i];
        --this.nbGene;
        for (int j = i; j < this.nbGene; ++j) {
            this.tabGene[j] = this.tabGene[j + 1];
        }
        this.tabGene[this.nbGene] = null;
        return g;
    }

    public Gene setGene(int i, Gene ge) {
        if (i >= this.nbGene || i < 0) {
            throw new IndexOutOfBoundsException("ChromosomeVariable, setGene (int i, Gene ge) : indice 'i' hors des limites.");
        }
        if (this.nbGene != 0 && !this.tabGene[0].getClass().isInstance(ge)) {
            throw new IllegalArgumentException("ChromosomeVariable, setGene (int i, Gene ge) : tous les genes doivent etre de meme type.");
        }
        Gene g = this.tabGene[i];
        this.tabGene[i] = ge;
        return g;
    }

    public int size() {
        return this.nbGene;
    }

    @Override
    public Chromosome[] croisement(Chromosome parent) {
        ChromosomeVariable cv1;
        ChromosomeVariable cv0;
        ChromosomeVariable cv_parent = (ChromosomeVariable)parent;
        try {
            cv0 = (ChromosomeVariable)this.clone();
            cv1 = (ChromosomeVariable)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        switch (this.modeCroisement & this.type) {
            case 1: {
                int i;
                int point2;
                int point1;
                do {
                    point1 = (int)(PseudoRandomNumbers.random() * (double)(this.nbGene + 1));
                    point2 = (int)(PseudoRandomNumbers.random() * (double)(cv_parent.nbGene + 1));
                } while (point1 == 0 && point2 == cv_parent.nbGene || point1 == this.nbGene && point2 == 0);
                cv0.nbGene = 0;
                cv0.tabGene = new Gene[point1 + cv_parent.nbGene - point2 + 2];
                cv1.nbGene = 0;
                cv1.tabGene = new Gene[this.nbGene - point1 + point2 + 2];
                for (i = 0; i < point1; ++i) {
                    cv0.tabGene[cv0.nbGene++] = this.tabGene[i].copier();
                }
                for (i = point2; i < cv_parent.nbGene; ++i) {
                    cv0.tabGene[cv0.nbGene++] = cv_parent.tabGene[i].copier();
                }
                for (i = 0; i < point2; ++i) {
                    cv1.tabGene[cv1.nbGene++] = cv_parent.tabGene[i].copier();
                }
                for (i = point1; i < this.nbGene; ++i) {
                    cv1.tabGene[cv1.nbGene++] = this.tabGene[i].copier();
                }
                break;
            }
            case 257: {
                int i;
                int point1 = (int)(PseudoRandomNumbers.random() * (double)this.nbGene);
                int point2 = (int)(PseudoRandomNumbers.random() * (double)cv_parent.nbGene);
                cv0.nbGene = 0;
                cv0.tabGene = new Gene[point1 + cv_parent.nbGene - point2 + 2];
                cv1.nbGene = 0;
                cv1.tabGene = new Gene[this.nbGene - point1 + point2 + 2];
                for (i = 0; i < point1; ++i) {
                    cv0.tabGene[cv0.nbGene++] = this.tabGene[i].copier();
                }
                for (i = 0; i < point2; ++i) {
                    cv1.tabGene[cv1.nbGene++] = cv_parent.tabGene[i].copier();
                }
                GeneComplexe[] gc = ((GeneComplexe)this.tabGene[point1]).croisement((GeneComplexe)cv_parent.tabGene[point2]);
                cv0.tabGene[cv0.nbGene++] = gc[0];
                cv1.tabGene[cv1.nbGene++] = gc[1];
                for (i = point2 + 1; i < cv_parent.nbGene; ++i) {
                    cv0.tabGene[cv0.nbGene++] = cv_parent.tabGene[i].copier();
                }
                for (i = point1 + 1; i < this.nbGene; ++i) {
                    cv1.tabGene[cv1.nbGene++] = this.tabGene[i].copier();
                }
                break;
            }
            case 16: {
                int i;
                int lg_segment = this.nbGene < cv_parent.nbGene ? (int)(PseudoRandomNumbers.random() * (double)(this.nbGene / 2)) + 1 : (int)(PseudoRandomNumbers.random() * (double)(cv_parent.nbGene / 2)) + 1;
                int point1 = (int)(PseudoRandomNumbers.random() * (double)(this.nbGene - lg_segment + 1));
                int point2 = (int)(PseudoRandomNumbers.random() * (double)(cv_parent.nbGene - lg_segment + 1));
                int choix1 = (int)(PseudoRandomNumbers.random() * 2.0);
                int choix2 = (int)(PseudoRandomNumbers.random() * 2.0);
                if (choix1 == 0) {
                    cv0.nbGene = point1 + 2;
                    cv1.nbGene = point2 + 2;
                } else {
                    cv0.nbGene = point2 + 2;
                    cv1.nbGene = point1 + 2;
                }
                if (choix2 == 0) {
                    cv0.nbGene += this.nbGene - point1;
                    cv1.nbGene += cv_parent.nbGene - point2;
                } else {
                    cv0.nbGene += cv_parent.nbGene - point2;
                    cv1.nbGene += this.nbGene - point1;
                }
                cv0.tabGene = new Gene[cv0.nbGene];
                cv0.nbGene = 0;
                cv1.tabGene = new Gene[cv1.nbGene];
                cv1.nbGene = 0;
                if (choix1 == 0) {
                    for (i = 0; i < point1; ++i) {
                        cv0.tabGene[cv0.nbGene++] = this.tabGene[i].copier();
                    }
                    for (i = 0; i < point2; ++i) {
                        cv1.tabGene[cv1.nbGene++] = cv_parent.tabGene[i].copier();
                    }
                } else {
                    for (i = 0; i < point1; ++i) {
                        cv1.tabGene[cv1.nbGene++] = this.tabGene[i].copier();
                    }
                    for (i = 0; i < point2; ++i) {
                        cv0.tabGene[cv0.nbGene++] = cv_parent.tabGene[i].copier();
                    }
                }
                for (i = 0; i < lg_segment; ++i) {
                    Gene g = this.tabGene[point1 + i].melanger(cv_parent.tabGene[point2 + i]);
                    cv0.tabGene[cv0.nbGene++] = g;
                    cv1.tabGene[cv1.nbGene++] = g.copier();
                }
                if (choix2 == 0) {
                    for (i = point1 + lg_segment; i < this.nbGene; ++i) {
                        cv0.tabGene[cv0.nbGene++] = this.tabGene[i].copier();
                    }
                    for (i = point2 + lg_segment; i < cv_parent.nbGene; ++i) {
                        cv1.tabGene[cv1.nbGene++] = cv_parent.tabGene[i].copier();
                    }
                } else {
                    for (i = point1 + lg_segment; i < this.nbGene; ++i) {
                        cv1.tabGene[cv1.nbGene++] = this.tabGene[i].copier();
                    }
                    for (i = point2 + lg_segment; i < cv_parent.nbGene; ++i) {
                        cv0.tabGene[cv0.nbGene++] = cv_parent.tabGene[i].copier();
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("ChromosomeVariable, croisement (Chromosome parent, int mode) : mode de croisement incorrect.");
            }
        }
        Chromosome[] cv = new ChromosomeVariable[]{cv0, cv1};
        return cv;
    }

    @Override
    public boolean mutation(double Pm) {
        if (PseudoRandomNumbers.random() <= Pm) {
            int i = (int)(PseudoRandomNumbers.random() * (double)this.nbGene);
            switch ((int)(PseudoRandomNumbers.random() * 4.0)) {
                case 0: {
                    this.tabGene[i].mutation();
                    break;
                }
                case 1: {
                    this.addGene(i, this.tabGene[0].creer());
                    break;
                }
                case 2: {
                    if (this.nbGene <= 1) break;
                    this.removeGene(i);
                    break;
                }
                default: {
                    int j;
                    if (this.nbGene <= 1) break;
                    while (i == (j = (int)(PseudoRandomNumbers.random() * (double)this.nbGene))) {
                    }
                    Gene g = this.tabGene[i];
                    this.tabGene[i] = this.tabGene[j];
                    this.tabGene[j] = g;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Chromosome copier() {
        try {
            ChromosomeVariable cv = (ChromosomeVariable)this.clone();
            cv.tabGene = new Gene[this.tabGene.length];
            for (int i = 0; i < this.nbGene; ++i) {
                cv.tabGene[i] = this.tabGene[i].copier();
            }
            return cv;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public Chromosome creer() {
        try {
            ChromosomeVariable cv = (ChromosomeVariable)this.clone();
            int taille = (int)(PseudoRandomNumbers.random() * (double)this.lg.getTaille()) + this.lg.getMin();
            cv.tabGene = new Gene[taille + 2];
            cv.nbGene = taille;
            Gene g = this.tabGene[0];
            for (int i = 0; i < taille; ++i) {
                cv.tabGene[i] = g.creer();
            }
            return cv;
        }
        catch (CloneNotSupportedException x) {
            return null;
        }
    }

    @Override
    public boolean estEgalA(Chromosome c) {
        ChromosomeVariable cv = (ChromosomeVariable)c;
        if (this.nbGene == cv.nbGene) {
            for (int i = 0; i < this.nbGene; ++i) {
                if (this.tabGene[i].estEgalA(cv.tabGene[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public StringBuilder afficher() {
        int taille = this.nbGene - 1;
        StringBuilder sb = new StringBuilder("<debut<");
        for (int i = 0; i < taille; ++i) {
            sb.append((CharSequence)this.tabGene[i].afficher());
            sb.append(" ");
        }
        sb.append((CharSequence)this.tabGene[taille].afficher());
        sb.append(">fin>");
        return sb;
    }

    @Override
    public boolean estPlusGeneralQue(Chromosome c) {
        ChromosomeVariable cv = (ChromosomeVariable)c;
        if (this.nbGene == cv.nbGene) {
            for (int i = 0; i < this.nbGene; ++i) {
                if (this.tabGene[i].estPlusGeneralQue(cv.tabGene[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

