/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stemmers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.stemmers.Stemmer;

public class Stemming {
    protected static String makeOptionsString(Stemmer stemmer) {
        Enumeration enumeration;
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("\tDisplays this help.", "h", 0, "-h"));
        vector.add(new Option("\tThe file to process.", "i", 1, "-i <input-file>"));
        vector.add(new Option("\tThe file to output the processed data to (default stdout).", "o", 1, "-o <output-file>"));
        vector.add(new Option("\tUses lowercase strings.", "l", 0, "-l"));
        if (stemmer instanceof OptionHandler) {
            enumeration = ((OptionHandler)((Object)stemmer)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.add((Option)enumeration.nextElement());
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nStemmer options:\n\n");
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            stringBuffer.append(option.synopsis() + "\n");
            stringBuffer.append(option.description() + "\n");
        }
        return stringBuffer.toString();
    }

    public static void useStemmer(Stemmer stemmer, String[] stringArray) throws Exception {
        int n;
        if (Utils.getFlag('h', stringArray)) {
            System.out.println(Stemming.makeOptionsString(stemmer));
            return;
        }
        String string = Utils.getOption('i', stringArray);
        if (string.length() == 0) {
            throw new IllegalArgumentException("No input file defined!" + Stemming.makeOptionsString(stemmer));
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        StringBuffer stringBuffer = new StringBuffer();
        string = Utils.getOption('o', stringArray);
        BufferedWriter bufferedWriter = string.length() == 0 ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string)));
        boolean bl = Utils.getFlag('l', stringArray);
        if (stemmer instanceof OptionHandler) {
            ((OptionHandler)((Object)stemmer)).setOptions(stringArray);
        }
        try {
            Utils.checkForRemainingOptions(stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println(Stemming.makeOptionsString(stemmer));
            return;
        }
        while ((n = ((Reader)bufferedReader).read()) != -1) {
            char c = (char)n;
            if (Character.isWhitespace(c)) {
                if (stringBuffer.length() > 0) {
                    bufferedWriter.write(stemmer.stem(stringBuffer.toString()));
                    stringBuffer = new StringBuffer();
                }
                ((Writer)bufferedWriter).write(c);
                continue;
            }
            if (bl) {
                stringBuffer.append(Character.toLowerCase(c));
                continue;
            }
            stringBuffer.append(c);
        }
        ((Writer)bufferedWriter).flush();
    }
}

