/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.iri.impl.AbsIRIImpl;
import com.hp.hpl.jena.iri.impl.PatternCompiler;

public class ViolationImpl
extends Violation {
    private static final long serialVersionUID = 2281176551632614471L;
    private final int code;
    private final int slot;
    private final AbsIRIImpl iri;

    public ViolationImpl(IRI iri, int slot, int code) {
        this.iri = (AbsIRIImpl)iri;
        this.code = code;
        this.slot = slot;
    }

    public int getViolationCode() {
        return this.code;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public int getComponent() {
        return this.slot;
    }

    public String codeName() {
        return PatternCompiler.errorCodeName(this.code);
    }

    public boolean isError() {
        return (this.iri.getSchemeSpec().getMask(false) & 1L << this.code) != 0L;
    }

    public String getShortMessage() {
        return "Error: " + this.code + "/" + this.codeName() + " in slot " + this.slot;
    }

    public String getLongMessage() {
        return "Error: " + this.code + "/" + this.codeName() + " in slot " + this.slot;
    }

    public String getSpecificationURL() {
        return null;
    }
}

