/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Missing_Values.ignore_missing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class ignore_missing {
    double[] mean = null;
    double[] std_dev = null;
    double tempData = 0.0;
    String[][] X = null;
    int ndatos = 0;
    int nentradas = 0;
    int tipo = 0;
    int direccion = 0;
    int nvariables = 0;
    int nsalidas = 0;
    InstanceSet IS;
    String input_train_name = new String();
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");

    public ignore_missing(String fileParam) {
        this.config_read(fileParam);
        this.IS = new InstanceSet();
    }

    public void process() {
        Instance inst;
        int i;
        PrintWriter pw;
        FileWriter file_write;
        boolean[] isMissed;
        boolean out;
        try {
            this.IS.readSet(this.input_train_name, true);
            boolean in = false;
            out = false;
            this.ndatos = this.IS.getNumInstances();
            this.nvariables = Attributes.getNumAttributes();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nsalidas = Attributes.getOutputNumAttributes();
            this.X = new String[this.ndatos][this.nvariables];
            isMissed = new boolean[this.ndatos];
            try {
                file_write = new FileWriter(this.output_train_name);
                file_write.write(this.IS.getHeader());
                file_write.write("@data\n");
                pw = new PrintWriter(file_write);
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IS.getInstance(i);
                    if (inst.existsAnyMissingValue()) continue;
                    inst.printAsOriginal(pw);
                    file_write.write("\n");
                }
                pw.close();
                file_write.close();
            }
            catch (IOException e) {
                System.out.println("IO exception = " + e);
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.out.println("Dataset exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        if (this.input_train_name.compareTo(this.input_test_name) != 0) {
            try {
                this.IS.readSet(this.input_test_name, false);
                boolean in = false;
                out = false;
                this.ndatos = this.IS.getNumInstances();
                this.nvariables = Attributes.getNumAttributes();
                this.nentradas = Attributes.getInputNumAttributes();
                this.nsalidas = Attributes.getOutputNumAttributes();
                this.X = new String[this.ndatos][this.nvariables];
                isMissed = new boolean[this.ndatos];
                try {
                    file_write = new FileWriter(this.output_test_name);
                    file_write.write(this.IS.getHeader());
                    file_write.write("@data\n");
                    pw = new PrintWriter(file_write);
                    for (i = 0; i < this.ndatos; ++i) {
                        inst = this.IS.getInstance(i);
                        if (inst.existsAnyMissingValue()) continue;
                        inst.printAsOriginal(pw);
                        file_write.write("\n");
                    }
                    pw.close();
                    file_write.close();
                }
                catch (IOException e) {
                    System.out.println("IO exception = " + e);
                    System.exit(-1);
                }
            }
            catch (Exception e) {
                System.out.println("Dataset exception = " + e);
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            file_reader.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    private void write_results() {
        try {
            FileWriter file_write = new FileWriter(this.output_train_name);
            file_write.write(this.IS.getHeader());
            file_write.write("@data\n");
            for (int i = 0; i < this.ndatos; ++i) {
                file_write.write(this.X[i][0]);
                for (int j = 1; j < this.nvariables; ++j) {
                    file_write.write("," + this.X[i][j]);
                }
                file_write.write("\n");
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }
}

