//=================================================================================================
/*!
//  \file blaze/math/LAPACK.h
//  \brief Header file for the LAPACK functionality
//
//  Copyright (C) 2012-2020 Klaus Iglberger - All Rights Reserved
//
//  This file is part of the Blaze library. You can redistribute it and/or modify it under
//  the terms of the New (Revised) BSD License. Redistribution and use in source and binary
//  forms, with or without modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright notice, this list of
//     conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//     of conditions and the following disclaimer in the documentation and/or other materials
//     provided with the distribution.
//  3. Neither the names of the Blaze development group nor the names of its contributors
//     may be used to endorse or promote products derived from this software without specific
//     prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
//  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
//  SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
//  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
//  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
*/
//=================================================================================================

#ifndef _BLAZE_MATH_LAPACK_H_
#define _BLAZE_MATH_LAPACK_H_


//*************************************************************************************************
// Includes
//*************************************************************************************************

#include <blaze/math/lapack/geev.h>
#include <blaze/math/lapack/gelqf.h>
#include <blaze/math/lapack/geqlf.h>
#include <blaze/math/lapack/geqp3.h>
#include <blaze/math/lapack/geqrf.h>
#include <blaze/math/lapack/gerqf.h>
#include <blaze/math/lapack/gesdd.h>
#include <blaze/math/lapack/gesv.h>
#include <blaze/math/lapack/gesvd.h>
#include <blaze/math/lapack/gesvdx.h>
#include <blaze/math/lapack/getrf.h>
#include <blaze/math/lapack/getri.h>
#include <blaze/math/lapack/getrs.h>
#include <blaze/math/lapack/gges.h>
#include <blaze/math/lapack/heev.h>
#include <blaze/math/lapack/heevd.h>
#include <blaze/math/lapack/heevx.h>
#include <blaze/math/lapack/hesv.h>
#include <blaze/math/lapack/hetrf.h>
#include <blaze/math/lapack/hetri.h>
#include <blaze/math/lapack/hetrs.h>
#include <blaze/math/lapack/org2l.h>
#include <blaze/math/lapack/org2r.h>
#include <blaze/math/lapack/orgl2.h>
#include <blaze/math/lapack/orglq.h>
#include <blaze/math/lapack/orgql.h>
#include <blaze/math/lapack/orgqr.h>
#include <blaze/math/lapack/orgr2.h>
#include <blaze/math/lapack/orgrq.h>
#include <blaze/math/lapack/ormlq.h>
#include <blaze/math/lapack/ormql.h>
#include <blaze/math/lapack/ormqr.h>
#include <blaze/math/lapack/ormrq.h>
#include <blaze/math/lapack/posv.h>
#include <blaze/math/lapack/potrf.h>
#include <blaze/math/lapack/potri.h>
#include <blaze/math/lapack/potrs.h>
#include <blaze/math/lapack/syev.h>
#include <blaze/math/lapack/syevd.h>
#include <blaze/math/lapack/syevx.h>
#include <blaze/math/lapack/sysv.h>
#include <blaze/math/lapack/sytrf.h>
#include <blaze/math/lapack/sytri.h>
#include <blaze/math/lapack/sytrs.h>
#include <blaze/math/lapack/trsv.h>
#include <blaze/math/lapack/trtri.h>
#include <blaze/math/lapack/trtrs.h>
#include <blaze/math/lapack/ung2l.h>
#include <blaze/math/lapack/ung2r.h>
#include <blaze/math/lapack/ungl2.h>
#include <blaze/math/lapack/unglq.h>
#include <blaze/math/lapack/ungql.h>
#include <blaze/math/lapack/ungqr.h>
#include <blaze/math/lapack/ungr2.h>
#include <blaze/math/lapack/ungrq.h>
#include <blaze/math/lapack/unmlq.h>
#include <blaze/math/lapack/unmql.h>
#include <blaze/math/lapack/unmqr.h>
#include <blaze/math/lapack/unmrq.h>

#endif
