## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  eval = TRUE,
  echo = TRUE,
  comment = "#>",
  dpi = 150,
  fig.align = "center",
  out.width = "80%",
  fig.height = 4,
  fig.width = 7
)

## ----setup--------------------------------------------------------------------
library(forcis)
library(ggplot2)

## ----'download-db', eval=FALSE------------------------------------------------
# # Create a data/ folder ----
# dir.create("data")
# 
# # Download latest version of the database ----
# download_forcis_db(path = "data", version = NULL)

## ----'load-data', echo=FALSE--------------------------------------------------
file_name <- system.file(
  file.path("extdata", "FORCIS_net_sample.csv"),
  package = "forcis"
)
net_data <- read.csv(file_name)

## ----'load-data-user', eval=FALSE---------------------------------------------
# # Import net data ----
# net_data <- read_plankton_nets_data(path = "data")

## ----'geom-basemap'-----------------------------------------------------------
# World basemap ----
ggplot() +
  geom_basemap()

## ----'ggmap-raw-data'---------------------------------------------------------
# Map raw net data ----
ggmap_data(net_data)

## ----'ggmap-raw-data-2'-------------------------------------------------------
# Customize map ----
ggmap_data(net_data, col = "#ff0000", fill = NA, shape = 21, size = 3)

## ----'ggmap-filtered-data', echo=TRUE, eval=FALSE-----------------------------
# # Filter net data ----
# net_data_indian <- filter_by_ocean(net_data, ocean = "Indian Ocean")
# 
# # Map filtered data ----
# ggmap_data(net_data_indian)

## ----'ggmap-filtered-data-pipe', eval=FALSE-----------------------------------
# # Same as before, but w/ the pipe ----
# net_data |>
#   filter_by_ocean(ocean = "Indian Ocean") |>
#   ggmap_data()

## ----'ggmap-save', eval=FALSE-------------------------------------------------
# # Map filtered data ----
# net_data_indian_map <- net_data |>
#   filter_by_ocean(ocean = "Indian Ocean") |>
#   ggmap_data() +
#   ggtitle("FORCIS net data - Indian Ocean")
# 
# # Save as PNG ----
# ggsave(
#   net_data_indian_map,
#   filename = "net_data_indian_map.png",
#   width = 20,
#   height = 11,
#   units = "cm",
#   dpi = 300,
#   scale = 1.5,
#   bg = "white"
# )

## ----'plot-record-by-year'----------------------------------------------------
# Plot number of records by year ----
plot_record_by_year(net_data)

## ----'plot-record-by-month'---------------------------------------------------
# Plot number of records by month ----
plot_record_by_month(net_data)

## ----'plot-record-by-season'--------------------------------------------------
# Plot number of records by season ----
plot_record_by_season(net_data)

## ----'plot-record-by-depth'---------------------------------------------------
# Plot number of records by depth ----
plot_record_by_depth(net_data)

