/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tests;

import cc.mallet.pipe.CharSequenceLowercase;
import cc.mallet.pipe.CharSequenceNoDiacritics;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestCharSequenceNoDiacritics
extends TestCase {
    public void testAccentAigu() {
        TestCharSequenceNoDiacritics.assertEquals("medecin", this.oneWordCleansing("m\u00e9decin"));
        TestCharSequenceNoDiacritics.assertEquals("etouffer", this.oneWordCleansing("\u00e9touffer"));
        TestCharSequenceNoDiacritics.assertEquals("marche", this.oneWordCleansing("march\u00e9"));
    }

    public void testAccentGrave() {
        TestCharSequenceNoDiacritics.assertEquals("tres", this.oneWordCleansing("tr\u00e8s"));
        TestCharSequenceNoDiacritics.assertEquals("deuxieme", this.oneWordCleansing("deuxi\u00e8me"));
    }

    public void testAccentCirconflexe() {
        TestCharSequenceNoDiacritics.assertEquals("foret", this.oneWordCleansing("for\u00eat"));
        TestCharSequenceNoDiacritics.assertEquals("hotel", this.oneWordCleansing("h\u00f4tel"));
    }

    public void testCedille() {
        TestCharSequenceNoDiacritics.assertEquals("garcon", this.oneWordCleansing("gar\u00e7on"));
        TestCharSequenceNoDiacritics.assertEquals("francais", this.oneWordCleansing("fran\u00e7ais"));
    }

    public void testTrema() {
        TestCharSequenceNoDiacritics.assertEquals("jamaique", this.oneWordCleansing("Jama\u00efque"));
        TestCharSequenceNoDiacritics.assertEquals("coincidence", this.oneWordCleansing("co\u00efncidence"));
    }

    public void testRussianWords() {
        TestCharSequenceNoDiacritics.assertEquals("\u0437\u0430\u043c\u043e\u043a", this.oneWordCleansing("\u0437\u0430\u043c\u043e\u0301\u043a"));
        TestCharSequenceNoDiacritics.assertEquals("\u0437\u0430\u043c\u043e\u043a", this.oneWordCleansing("\u0437\u0430\u0301\u043c\u043e\u043a"));
        TestCharSequenceNoDiacritics.assertEquals("\u0443\u0436\u0435", this.oneWordCleansing("\u0443\u0301\u0436\u0435"));
        TestCharSequenceNoDiacritics.assertEquals("\u0441\u043b\u043e\u0432\u043e", this.oneWordCleansing("\u0441\u043b\u043e\u0301\u0432\u043e"));
        TestCharSequenceNoDiacritics.assertEquals("\u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440", this.oneWordCleansing("\u043a\u043e\u043c\u043f\u044c\u044e\u0301\u0442\u0435\u0440"));
        TestCharSequenceNoDiacritics.assertEquals("\u0431\u0443\u043c\u0430\u0433\u0430", this.oneWordCleansing("\u0431\u0443\u043c\u0430\u0301\u0433\u0430"));
        TestCharSequenceNoDiacritics.assertEquals("\u044d\u043a\u0440\u0430\u043d", this.oneWordCleansing("\u044d\u043a\u0440\u0430\u0301\u043d"));
        TestCharSequenceNoDiacritics.assertEquals("\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", this.oneWordCleansing("\u0441\u043e\u043e\u0431\u0449\u0435\u0301\u043d\u0438\u0435"));
    }

    private String oneWordCleansing(String str) {
        Instance instance = new Instance(str, null, null, null);
        InstanceList instances = new InstanceList(this.createPipes());
        instances.addThruPipe(instance);
        return (String)instance.getData();
    }

    private SerialPipes createPipes() {
        ArrayList<Pipe> pipes = new ArrayList<Pipe>();
        pipes.add(new CharSequenceLowercase());
        pipes.add(new CharSequenceNoDiacritics());
        return new SerialPipes(pipes);
    }
}

